/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jsign.zip.CentralDirectoryFileHeader;
import net.jsign.zip.EndOfCentralDirectoryRecord;
import net.jsign.zip.Zip64EndOfCentralDirectoryLocator;
import net.jsign.zip.Zip64EndOfCentralDirectoryRecord;

public class CentralDirectory {
    private final EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = new EndOfCentralDirectoryRecord();
    private final Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = new Zip64EndOfCentralDirectoryLocator();
    private final Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = new Zip64EndOfCentralDirectoryRecord();
    public long centralDirectoryOffset = -1L;
    public Map<String, CentralDirectoryFileHeader> entries = new LinkedHashMap<String, CentralDirectoryFileHeader>();

    public void read(SeekableByteChannel channel) throws IOException {
        long numberOfEntries;
        this.endOfCentralDirectoryRecord.load(channel);
        if (this.endOfCentralDirectoryRecord.numberOfThisDisk > 0) {
            throw new IOException("Multi-volume archives are not supported");
        }
        if (this.endOfCentralDirectoryRecord.centralDirectoryOffset == -1) {
            channel.position(channel.position() - 20L);
            this.zip64EndOfCentralDirectoryLocator.read(channel);
            channel.position(this.zip64EndOfCentralDirectoryLocator.zip64EndOfCentralDirectoryRecordOffset);
            this.zip64EndOfCentralDirectoryRecord.read(channel);
            this.centralDirectoryOffset = this.zip64EndOfCentralDirectoryRecord.centralDirectoryOffset;
            numberOfEntries = (int)this.zip64EndOfCentralDirectoryRecord.numberOfEntries;
        } else {
            this.centralDirectoryOffset = this.endOfCentralDirectoryRecord.centralDirectoryOffset;
            numberOfEntries = this.endOfCentralDirectoryRecord.numberOfEntries;
        }
        if (this.centralDirectoryOffset < 0L || this.centralDirectoryOffset > channel.size()) {
            throw new IOException("Invalid central directory offset: " + this.centralDirectoryOffset);
        }
        channel.position(this.centralDirectoryOffset);
        int i = 0;
        while ((long)i < numberOfEntries) {
            CentralDirectoryFileHeader entry = new CentralDirectoryFileHeader();
            entry.read(channel);
            this.entries.put(new String(entry.fileName, StandardCharsets.ISO_8859_1), entry);
            ++i;
        }
    }

    public void write(SeekableByteChannel channel) throws IOException {
        long offset;
        this.centralDirectoryOffset = offset = channel.position();
        this.write(channel, offset);
    }

    public void write(SeekableByteChannel channel, long offset) throws IOException {
        ArrayList<CentralDirectoryFileHeader> entries = new ArrayList<CentralDirectoryFileHeader>(this.entries.values());
        entries.sort(Comparator.comparing(CentralDirectoryFileHeader::getLocalHeaderOffset));
        long position = channel.position();
        for (CentralDirectoryFileHeader entry : entries) {
            entry.write(channel);
        }
        long centralDirectorySize = channel.position() - position;
        if (this.endOfCentralDirectoryRecord.centralDirectoryOffset == -1 || offset > 0xFFFFFFFFL) {
            this.endOfCentralDirectoryRecord.centralDirectoryOffset = -1;
            this.endOfCentralDirectoryRecord.centralDirectorySize = -1;
            this.zip64EndOfCentralDirectoryRecord.numberOfEntriesOnThisDisk = entries.size();
            this.zip64EndOfCentralDirectoryRecord.numberOfEntries = entries.size();
            this.zip64EndOfCentralDirectoryRecord.centralDirectorySize = centralDirectorySize;
            this.zip64EndOfCentralDirectoryRecord.centralDirectoryOffset = offset;
            this.zip64EndOfCentralDirectoryRecord.write(channel);
            this.zip64EndOfCentralDirectoryLocator.zip64EndOfCentralDirectoryRecordOffset = offset + centralDirectorySize;
            this.zip64EndOfCentralDirectoryLocator.write(channel);
        } else {
            this.endOfCentralDirectoryRecord.numberOfEntriesOnThisDisk = entries.size();
            this.endOfCentralDirectoryRecord.numberOfEntries = entries.size();
            this.endOfCentralDirectoryRecord.centralDirectorySize = (int)centralDirectorySize;
            this.endOfCentralDirectoryRecord.centralDirectoryOffset = (int)offset;
        }
        this.endOfCentralDirectoryRecord.numberOfThisDisk = 0;
        this.endOfCentralDirectoryRecord.numberOfTheDiskWithTheStartOfTheCentralDirectory = 0;
        this.endOfCentralDirectoryRecord.write(channel);
    }

    public void removeEntry(String name) {
        if (this.entries.containsKey(name)) {
            CentralDirectoryFileHeader centralDirectoryFileHeader = this.entries.get(name);
            long size = this.getEntrySize(name);
            this.entries.remove(name);
            this.centralDirectoryOffset -= size;
            for (CentralDirectoryFileHeader entry : this.entries.values()) {
                if (entry.getLocalHeaderOffset() <= centralDirectoryFileHeader.getLocalHeaderOffset()) continue;
                entry.setLocalHeaderOffset(entry.getLocalHeaderOffset() - size);
            }
        }
    }

    public long getEntrySize(String name) {
        CentralDirectoryFileHeader centralDirectoryFileHeader = this.entries.get(name);
        long size = this.centralDirectoryOffset - centralDirectoryFileHeader.getLocalHeaderOffset();
        for (CentralDirectoryFileHeader entry : this.entries.values()) {
            long distance = entry.getLocalHeaderOffset() - centralDirectoryFileHeader.getLocalHeaderOffset();
            if (distance <= 0L || distance >= size) continue;
            size = distance;
        }
        return size;
    }

    /*
     * Loose catch block
     */
    public byte[] toBytes() throws IOException {
        File tmp = File.createTempFile("jsign-zip-central-directory", ".bin");
        tmp.deleteOnExit();
        try {
            try (RandomAccessFile raf = new RandomAccessFile(tmp, "rw");){
                this.write(raf.getChannel(), this.centralDirectoryOffset);
                byte[] byArray = Files.readAllBytes(tmp.toPath());
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            tmp.delete();
        }
    }
}

