/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.appx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.zip.CentralDirectory;
import net.jsign.zip.ZipFile;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.util.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSSignedData;

public class APPXFile
extends ZipFile
implements Signable {
    private static final String SIGNATURE_ENTRY = "AppxSignature.p7x";

    public APPXFile(File file) throws IOException {
        super(file);
        this.verifyPackage();
    }

    public APPXFile(SeekableByteChannel channel) throws IOException {
        super(channel);
        this.verifyPackage();
    }

    private void verifyPackage() throws IOException {
        if (this.centralDirectory.entries.get("[Content_Types].xml") == null) {
            throw new IOException("Invalid APPX/MSIX package, [Content_Types].xml is missing");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        this.addContentType("/AppxSignature.p7x", "application/vnd.ms-appx.signature");
        long endOfContentOffset = this.centralDirectory.centralDirectoryOffset;
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            endOfContentOffset = this.centralDirectory.entries.get(SIGNATURE_ENTRY).getLocalHeaderOffset();
        }
        MessageDigest axpc = digestAlgorithm.getMessageDigest();
        ChannelUtils.updateDigest(this.channel, axpc, 0L, endOfContentOffset);
        MessageDigest axcd = digestAlgorithm.getMessageDigest();
        axcd.update(this.getUnsignedCentralDirectory());
        MessageDigest axct = digestAlgorithm.getMessageDigest();
        IOUtils.copy((InputStream)this.getInputStream("[Content_Types].xml"), (OutputStream)new DigestOutputStream((OutputStream)NullOutputStream.INSTANCE, axct));
        MessageDigest axbm = digestAlgorithm.getMessageDigest();
        IOUtils.copy((InputStream)this.getInputStream("AppxBlockMap.xml"), (OutputStream)new DigestOutputStream((OutputStream)NullOutputStream.INSTANCE, axbm));
        MessageDigest axci = null;
        if (this.centralDirectory.entries.containsKey("AppxMetadata/CodeIntegrity.cat")) {
            axci = digestAlgorithm.getMessageDigest();
            IOUtils.copy((InputStream)this.getInputStream("AppxMetadata/CodeIntegrity.cat"), (OutputStream)new DigestOutputStream((OutputStream)NullOutputStream.INSTANCE, axci));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("APPX".getBytes());
        out.write("AXPC".getBytes());
        out.write(axpc.digest());
        out.write("AXCD".getBytes());
        out.write(axcd.digest());
        out.write("AXCT".getBytes());
        out.write(axct.digest());
        out.write("AXBM".getBytes());
        out.write(axbm.digest());
        if (axci != null) {
            out.write("AXCI".getBytes());
            out.write(axci.digest());
        }
        return out.toByteArray();
    }

    private byte[] getUnsignedCentralDirectory() throws IOException {
        CentralDirectory centralDirectory = new CentralDirectory();
        centralDirectory.read(this.channel);
        centralDirectory.removeEntry(SIGNATURE_ENTRY);
        return centralDirectory.toBytes();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcUuid uuid = new SpcUuid(this.isBundle() ? "B3585F0F-DEAA-9A4B-A434-95742D92ECEB" : "4BDFC50A-07CE-E24D-B76E-23C839A09FD1");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(0x1010000, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    private String normalize(String name) {
        if (name != null) {
            name = name.replaceAll(",\\s*S\\s*=", ",ST=");
        }
        return name;
    }

    @Override
    public void validate(Certificate certificate) throws IOException, IllegalArgumentException {
        X500Name name = X500Name.getInstance((Object)((X509Certificate)certificate).getSubjectX500Principal().getEncoded());
        String publisher = this.getPublisher();
        if (publisher == null || !name.equals((Object)new X500Name(this.normalize(publisher)))) {
            throw new IllegalArgumentException("The app manifest publisher name (" + publisher + ") must match the subject name of the signing certificate (" + name + ")");
        }
    }

    boolean isBundle() {
        return this.centralDirectory.entries.containsKey("AppxMetadata/AppxBundleManifest.xml");
    }

    String getPublisher() throws IOException {
        InputStream in = this.getInputStream(this.isBundle() ? "AppxMetadata/AppxBundleManifest.xml" : "AppxManifest.xml", 0xA00000);
        String manifest = new String(IOUtils.toByteArray((InputStream)in), StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile("Publisher\\s*=\\s*\"([^\"]+)", 2);
        Matcher matcher = pattern.matcher(manifest);
        return matcher.find() ? StringEscapeUtils.unescapeXml((String)matcher.group(1)) : null;
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            InputStream in = this.getInputStream(SIGNATURE_ENTRY, 0x100000);
            in.skip(4L);
            return SignatureUtils.getSignatures(IOUtils.toByteArray((InputStream)in));
        }
        return Collections.emptyList();
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            this.removeEntry(SIGNATURE_ENTRY);
        }
        if (signature != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("PKCX".getBytes());
            signature.toASN1Structure().encodeTo((OutputStream)out, "DER");
            this.addEntry(SIGNATURE_ENTRY, out.toByteArray(), false);
        }
    }

    void addContentType(String partName, String contentType) throws IOException {
        String override;
        InputStream in = this.getInputStream("[Content_Types].xml", 0xA00000);
        String contentTypes = new String(IOUtils.toByteArray((InputStream)in), StandardCharsets.UTF_8);
        if (!contentTypes.contains(override = "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/>")) {
            contentTypes = contentTypes.replace("</Types>", "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/></Types>");
            this.removeEntry("[Content_Types].xml");
            this.addEntry("[Content_Types].xml", contentTypes.getBytes(), true);
        }
    }

    @Override
    public void save() throws IOException {
    }
}

