/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.jsign.CertificateUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignerException;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.AuthenticodeSignedDataGenerator;
import net.jsign.asn1.authenticode.FilteredAttributeTableGenerator;
import net.jsign.asn1.authenticode.SpcSpOpusInfo;
import net.jsign.asn1.authenticode.SpcStatementType;
import net.jsign.jca.SigningServiceJcaProvider;
import net.jsign.nuget.NugetFile;
import net.jsign.timestamp.Timestamper;
import net.jsign.timestamp.TimestampingMode;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class AuthenticodeSigner {
    protected Certificate[] chain;
    protected PrivateKey privateKey;
    protected DigestAlgorithm digestAlgorithm = DigestAlgorithm.getDefault();
    protected String signatureAlgorithm;
    protected Provider signatureProvider;
    protected String programName;
    protected String programURL;
    protected boolean replace;
    protected boolean timestamping = true;
    protected TimestampingMode tsmode = TimestampingMode.AUTHENTICODE;
    protected String[] tsaurlOverride;
    protected Timestamper timestamper;
    protected int timestampingRetries = -1;
    protected int timestampingRetryWait = -1;

    public AuthenticodeSigner(Certificate[] chain, PrivateKey privateKey) {
        this.chain = chain;
        this.privateKey = privateKey;
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("The certificate chain is empty");
        }
    }

    public AuthenticodeSigner(KeyStore keystore, String alias, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        Certificate[] chain = keystore.getCertificateChain(alias);
        if (chain == null) {
            throw new IllegalArgumentException("No certificate found in the keystore with the alias '" + alias + "'");
        }
        this.chain = chain;
        this.privateKey = (PrivateKey)keystore.getKey(alias, password != null ? password.toCharArray() : null);
        Provider provider = keystore.getProvider();
        if (provider.getName().startsWith("SunPKCS11") || provider instanceof SigningServiceJcaProvider) {
            this.signatureProvider = provider;
        }
    }

    public AuthenticodeSigner withProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public AuthenticodeSigner withProgramURL(String programURL) {
        this.programURL = programURL;
        return this;
    }

    public AuthenticodeSigner withSignaturesReplaced(boolean replace) {
        this.replace = replace;
        return this;
    }

    public AuthenticodeSigner withTimestamping(boolean timestamping) {
        this.timestamping = timestamping;
        return this;
    }

    public AuthenticodeSigner withTimestampingMode(TimestampingMode tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public AuthenticodeSigner withTimestampingAuthority(String url) {
        return this.withTimestampingAuthority(new String[]{url});
    }

    public AuthenticodeSigner withTimestampingAuthority(String ... urls) {
        this.tsaurlOverride = urls;
        return this;
    }

    public AuthenticodeSigner withTimestamper(Timestamper timestamper) {
        this.timestamper = timestamper;
        return this;
    }

    public AuthenticodeSigner withTimestampingRetries(int timestampingRetries) {
        this.timestampingRetries = timestampingRetries;
        return this;
    }

    public AuthenticodeSigner withTimestampingRetryWait(int timestampingRetryWait) {
        this.timestampingRetryWait = timestampingRetryWait;
        return this;
    }

    public AuthenticodeSigner withDigestAlgorithm(DigestAlgorithm algorithm) {
        if (algorithm != null) {
            this.digestAlgorithm = algorithm;
        }
        return this;
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    private String getSignatureAlgorithm() {
        if (this.signatureAlgorithm != null) {
            return this.signatureAlgorithm;
        }
        if ("EC".equals(this.privateKey.getAlgorithm())) {
            return this.digestAlgorithm + "withECDSA";
        }
        if ("EdDSA".equals(this.privateKey.getAlgorithm())) {
            X509Certificate certificate = (X509Certificate)this.chain[0];
            PublicKey publicKey = certificate.getPublicKey();
            if (publicKey.toString().contains("Ed25519")) {
                return "Ed25519";
            }
            if (publicKey.toString().contains("Ed448")) {
                return "Ed448";
            }
        }
        return this.digestAlgorithm + "with" + this.privateKey.getAlgorithm();
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm, String signatureProvider) {
        return this.withSignatureAlgorithm(signatureAlgorithm, Security.getProvider(signatureProvider));
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm, Provider signatureProvider) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureProvider = signatureProvider;
        return this;
    }

    public AuthenticodeSigner withSignatureProvider(Provider signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public void sign(Signable file) throws Exception {
        List<CMSSignedData> signatures;
        file.validate(this.chain[0]);
        if (file instanceof NugetFile && !this.replace && !(signatures = file.getSignatures()).isEmpty()) {
            throw new SignerException("The file is already signed, the existing signature must be replaced explicitly");
        }
        CMSSignedData sigData = this.createSignedData(file);
        ArrayList<CMSSignedData> signatures2 = new ArrayList<CMSSignedData>();
        if (!this.replace) {
            signatures2.addAll(file.getSignatures());
        }
        signatures2.add(sigData);
        file.setSignatures(signatures2);
        file.save();
    }

    protected CMSSignedData createSignedData(Signable file) throws Exception {
        CMSTypedData contentInfo = file.createSignedContent(this.digestAlgorithm);
        CMSSignedDataGenerator generator = this.createSignedDataGenerator(file, contentInfo);
        CMSSignedData sigData = generator.generate(contentInfo, true);
        this.verify(sigData);
        if (this.timestamping) {
            Timestamper ts = this.timestamper;
            if (ts == null) {
                boolean authenticode = AuthenticodeObjectIdentifiers.isAuthenticode(sigData.getSignedContentTypeOID());
                ts = Timestamper.create(authenticode ? this.tsmode : TimestampingMode.RFC3161);
            }
            if (this.tsaurlOverride != null) {
                ts.setURLs(this.tsaurlOverride);
            }
            if (this.timestampingRetries != -1) {
                ts.setRetries(this.timestampingRetries);
            }
            if (this.timestampingRetryWait != -1) {
                ts.setRetryWait(this.timestampingRetryWait);
            }
            sigData = ts.timestamp(this.digestAlgorithm, sigData);
        }
        return sigData;
    }

    private CMSSignedDataGenerator createSignedDataGenerator(Signable file, CMSTypedData contentInfo) throws CMSException, OperatorCreationException, CertificateEncodingException {
        boolean authenticode;
        List fullChain = CertificateUtils.getFullCertificateChain(Arrays.asList(this.chain));
        if (fullChain.size() > 1) {
            fullChain.removeIf(CertificateUtils::isSelfSigned);
        }
        AuthenticodeSignedDataGenerator generator = (authenticode = AuthenticodeObjectIdentifiers.isAuthenticode(contentInfo.getContentType().getId())) ? new AuthenticodeSignedDataGenerator() : new CMSSignedDataGenerator();
        generator.addCertificates((Store)new JcaCertStore((Collection)fullChain));
        generator.addSignerInfoGenerator(this.createSignerInfoGenerator(file, authenticode));
        return generator;
    }

    private SignerInfoGenerator createSignerInfoGenerator(Signable file, boolean authenticode) throws OperatorCreationException, CertificateEncodingException {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(this.getSignatureAlgorithm());
        if (this.signatureProvider != null) {
            contentSignerBuilder.setProvider(this.signatureProvider);
        }
        ContentSigner shaSigner = contentSignerBuilder.build(this.privateKey);
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(authenticode ? this.createAuthenticatedAttributes() : file.createSignedAttributes((X509Certificate)this.chain[0]));
        AttributeTable attributeTable = new AttributeTable((ASN1Set)new DERSet(attributes.toArray(new ASN1Encodable[0])));
        Object attributeTableGenerator = new DefaultSignedAttributeTableGenerator(attributeTable);
        attributeTableGenerator = authenticode ? new FilteredAttributeTableGenerator((CMSAttributeTableGenerator)attributeTableGenerator, CMSAttributes.cmsAlgorithmProtect, CMSAttributes.signingTime) : new FilteredAttributeTableGenerator((CMSAttributeTableGenerator)attributeTableGenerator, CMSAttributes.cmsAlgorithmProtect);
        JcaX509CertificateHolder certificate = new JcaX509CertificateHolder((X509Certificate)this.chain[0]);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider, (CMSSignatureEncryptionAlgorithmFinder)new DefaultCMSSignatureEncryptionAlgorithmFinder(){

            public AlgorithmIdentifier findEncryptionAlgorithm(AlgorithmIdentifier signatureAlgorithm) {
                if (signatureAlgorithm.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.sha256WithRSAEncryption) || signatureAlgorithm.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.sha384WithRSAEncryption) || signatureAlgorithm.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
                    return new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
                }
                return super.findEncryptionAlgorithm(signatureAlgorithm);
            }
        });
        signerInfoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)attributeTableGenerator);
        signerInfoGeneratorBuilder.setContentDigest(this.createContentDigestAlgorithmIdentifier(shaSigner.getAlgorithmIdentifier()));
        return signerInfoGeneratorBuilder.build(shaSigner, (X509CertificateHolder)certificate);
    }

    private void verify(CMSSignedData signedData) throws SignatureException, OperatorCreationException {
        X509Certificate certificate = (X509Certificate)this.chain[0];
        PublicKey publicKey = certificate.getPublicKey();
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
        SignerInformationVerifier verifier = new JcaSignerInfoVerifierBuilder(digestCalculatorProvider).build(publicKey);
        boolean result = false;
        Throwable cause = null;
        try {
            result = signedData.verifySignatures(signerId -> verifier, false);
        }
        catch (Exception e) {
            cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
        }
        if (!result) {
            boolean ca = certificate.getBasicConstraints() != -1;
            String message = "Signature verification failed, ";
            message = ca ? message + "the certificate is a root or intermediate CA certificate (" + certificate.getSubjectX500Principal() + ")" : message + "the private key doesn't match the certificate";
            throw new SignatureException(message, cause);
        }
    }

    private List<Attribute> createAuthenticatedAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        SpcStatementType spcStatementType = new SpcStatementType(AuthenticodeObjectIdentifiers.SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID);
        attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_STATEMENT_TYPE_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcStatementType)));
        if (this.programName != null || this.programURL != null) {
            SpcSpOpusInfo spcSpOpusInfo = new SpcSpOpusInfo(this.programName, this.programURL);
            attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_SP_OPUS_INFO_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcSpOpusInfo)));
        }
        return attributes;
    }

    protected AlgorithmIdentifier createContentDigestAlgorithmIdentifier(AlgorithmIdentifier signatureAlgorithm) {
        if ("1.3.101.112".equals(signatureAlgorithm.getAlgorithm().getId()) || "1.3.101.113".equals(signatureAlgorithm.getAlgorithm().getId())) {
            return new AlgorithmIdentifier(this.digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
        }
        AlgorithmIdentifier ai = new DefaultDigestAlgorithmIdentifierFinder().find(signatureAlgorithm);
        if (ai.getParameters() == null) {
            ai = new AlgorithmIdentifier(ai.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
        }
        return ai;
    }
}

