/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.cat;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CatalogFile
implements Signable {
    private final SeekableByteChannel channel;
    private CMSSignedData signedData;

    public static boolean isCatalogFile(File file) {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            CatalogFile catFile = new CatalogFile(file);
            catFile.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public CatalogFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public CatalogFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        channel.position(0L);
        try {
            this.signedData = new CMSSignedData(Channels.newInputStream(channel));
        }
        catch (CMSException e) {
            channel.close();
            throw new IOException("Catalog file format error", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public CMSTypedData createSignedContent(DigestAlgorithm digestAlgorithm) {
        return this.signedData.getSignedContent();
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        if (this.signedData.getSignerInfos().size() > 0) {
            return SignatureUtils.getSignatures(this.signedData);
        }
        return new ArrayList<CMSSignedData>();
    }

    @Override
    public void setSignature(CMSSignedData signature) {
        if (signature != null) {
            this.signedData = signature;
        } else {
            try {
                this.signedData = CMSSignedData.replaceSigners((CMSSignedData)this.signedData, (SignerInformationStore)new SignerInformationStore(Collections.emptyList()));
                CollectionStore emptyStore = new CollectionStore(Collections.emptyList());
                this.signedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.signedData, (Store)emptyStore, (Store)emptyStore, (Store)emptyStore);
            }
            catch (CMSException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void save() throws IOException {
        this.channel.position(0L);
        this.channel.truncate(0L);
        this.channel.write(ByteBuffer.wrap(this.signedData.getEncoded("DER")));
    }
}

