/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.mscab;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcPeImageData;
import net.jsign.mscab.CABSignature;
import net.jsign.mscab.CFFolder;
import net.jsign.mscab.CFHeader;
import net.jsign.mscab.CFReserve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSSignedData;

public class MSCabinetFile
implements Signable {
    private final CFHeader header = new CFHeader();
    private final SeekableByteChannel channel;

    public static boolean isMSCabinetFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            MSCabinetFile cabFile = new MSCabinetFile(file);
            cabFile.close();
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("Invalid MSCabinet header signature") || e.getMessage().contains("MSCabinet file too short")) {
                return false;
            }
            throw e;
        }
    }

    public MSCabinetFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public MSCabinetFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        try {
            channel.position(0L);
            this.header.read(channel);
            if (this.header.hasSignature() && this.header.reserve.structure2.length == 16) {
                CABSignature cabsig = new CABSignature(this.header.reserve.structure2);
                if (cabsig.offset < channel.size() && cabsig.offset + cabsig.length > channel.size() || cabsig.offset > channel.size()) {
                    throw new IOException("MSCabinet file is corrupt: signature data (offset=" + cabsig.offset + ", size=" + cabsig.length + ") after the end of the file");
                }
                if (this.header.cbCabinet != cabsig.offset) {
                    throw new IOException("MSCabinet file is corrupt: the declared size of the file (" + this.header.cbCabinet + ") doesn't match the offset of the signature (" + cabsig.offset + ")");
                }
                if (this.header.cbCabinet + cabsig.length != channel.size()) {
                    throw new IOException("MSCabinet file is corrupt: the declared size of the file (" + this.header.cbCabinet + ") and the size of the signature (" + cabsig.length + ") are inconsistent with the actual size of the file (" + channel.size() + ")");
                }
            }
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public synchronized byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        CFReserve modifiedReserve = new CFReserve();
        modifiedReserve.minSize = this.header.cbCFHeader;
        if (this.header.reserve != null) {
            modifiedReserve.structure1 = this.header.reserve.structure1;
        }
        modifiedReserve.structure2 = new byte[16];
        CFHeader modifiedHeader = new CFHeader(this.header);
        modifiedHeader.setReserve(modifiedReserve);
        modifiedHeader.headerDigestUpdate(digest);
        int shift = modifiedHeader.getHeaderSize() - this.header.getHeaderSize();
        this.channel.position(this.header.getHeaderSize());
        for (int i = 0; i < this.header.cFolders; ++i) {
            CFFolder folder = CFFolder.read(this.channel);
            folder.coffCabStart += (long)shift;
            folder.digest(digest);
            ChannelUtils.updateDigest(this.channel, digest, this.channel.position(), this.channel.position() + (long)this.header.cbCFFolder);
        }
        long endPosition = this.header.cbCabinet;
        ChannelUtils.updateDigest(this.channel, digest, this.channel.position(), endPosition);
        return digest.digest();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_CAB_DATA_OBJID, new SpcPeImageData());
        return new SpcIndirectDataContent(data, digestInfo);
    }

    @Override
    public synchronized List<CMSSignedData> getSignatures() throws IOException {
        if (this.header.hasSignature()) {
            if (this.header.reserve.structure2.length == 16) {
                CABSignature cabsig = new CABSignature(this.header.reserve.structure2);
                if (cabsig.offset > 0L && cabsig.length > 0L && cabsig.length < this.channel.size()) {
                    byte[] buffer = new byte[(int)cabsig.length];
                    this.channel.position(cabsig.offset);
                    this.channel.read(ByteBuffer.wrap(buffer));
                    return SignatureUtils.getSignatures(buffer);
                }
            } else {
                return SignatureUtils.getSignatures(this.header.reserve.structure2);
            }
        }
        return new ArrayList<CMSSignedData>();
    }

    @Override
    public synchronized void setSignature(CMSSignedData signature) throws IOException {
        if (signature == null && !this.header.hasSignature()) {
            return;
        }
        byte[] content = signature != null ? signature.toASN1Structure().getEncoded("DER") : new byte[]{};
        int previousSize = this.header.getHeaderSize();
        CFReserve reserve = new CFReserve();
        reserve.minSize = this.header.cbCFHeader;
        if (this.header.reserve != null) {
            reserve.structure1 = this.header.reserve.structure1;
        }
        if (content.length > 0) {
            reserve.structure2 = new byte[16];
            this.header.setReserve(reserve);
            CABSignature cabsig = new CABSignature();
            cabsig.offset = this.header.cbCabinet;
            cabsig.length = content.length;
            reserve.structure2 = cabsig.array();
        } else {
            reserve.structure2 = new byte[0];
            this.header.setReserve(reserve);
        }
        int currentSize = this.header.getHeaderSize();
        int shift = currentSize - previousSize;
        if (shift > 0) {
            ChannelUtils.insert(this.channel, previousSize, new byte[shift]);
        } else if (shift < 0) {
            ChannelUtils.delete(this.channel, previousSize + shift, -shift);
        }
        this.header.write(this.channel);
        if (shift != 0) {
            for (int i = 0; i < this.header.cFolders; ++i) {
                long position = this.channel.position();
                CFFolder folder = CFFolder.read(this.channel);
                folder.coffCabStart += (long)shift;
                this.channel.position(position);
                folder.write(this.channel);
            }
        }
        this.channel.position(this.header.cbCabinet);
        this.channel.write(ByteBuffer.wrap(content));
        if (this.channel.position() < this.channel.size()) {
            this.channel.truncate(this.channel.position());
        }
    }

    @Override
    public void save() {
    }
}

