/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.script;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.script.Windows1252Extended;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSSignedData;

abstract class SignableScript
implements Signable {
    private File file;
    private String content;
    private Charset encoding;
    private byte[] bom;

    public SignableScript() {
        this.encoding = StandardCharsets.UTF_8;
    }

    public SignableScript(File file) throws IOException {
        this(file, StandardCharsets.UTF_8);
    }

    public SignableScript(File file, Charset encoding) throws IOException {
        this.file = file;
        this.encoding = encoding != null ? encoding : StandardCharsets.UTF_8;
        ByteOrderMark[] supportedBOMs = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
        try (BOMInputStream in = new BOMInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)), this.isByteOrderMarkSigned(), supportedBOMs);){
            if (in.hasBOM()) {
                this.encoding = Charset.forName(in.getBOMCharsetName());
                if (!this.isByteOrderMarkSigned()) {
                    this.bom = in.getBOM().getBytes();
                }
            } else if (StandardCharsets.UTF_8.equals(encoding) && !this.isUTF8AutoDetected()) {
                this.encoding = Windows1252Extended.INSTANCE;
            }
            this.setContent(new String(IOUtils.toByteArray((InputStream)in), this.encoding));
        }
    }

    abstract boolean isByteOrderMarkSigned();

    boolean isUTF8AutoDetected() {
        return true;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    abstract String getSignatureStart();

    abstract String getSignatureEnd();

    abstract String getLineCommentStart();

    abstract String getLineCommentEnd();

    abstract ASN1Object getSpcSipInfo();

    private Pattern getSignatureBlockPattern() {
        return Pattern.compile("(?s)\\r\\n" + this.getSignatureStart() + "\\r\\n(?<signatureBlock>.*)" + this.getSignatureEnd() + "\\r\\n");
    }

    private Pattern getSignatureBlockRemovalPattern() {
        return Pattern.compile("(?s)\\r?\\n" + this.getSignatureStart() + "\\r?\\n.*" + this.getSignatureEnd() + "\\r?\\n");
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        byte[] data = this.decodeSignatureBlock();
        return data != null ? SignatureUtils.getSignatures(this.decodeSignatureBlock()) : new ArrayList();
    }

    private String getSignatureBlock() {
        Matcher matcher = this.getSignatureBlockPattern().matcher(this.getContent());
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("signatureBlock");
    }

    private byte[] decodeSignatureBlock() {
        String signatureBlock = this.getSignatureBlock();
        if (signatureBlock == null) {
            return null;
        }
        signatureBlock = signatureBlock.replace(this.getLineCommentStart(), "");
        signatureBlock = signatureBlock.replace(this.getLineCommentEnd(), "");
        signatureBlock = signatureBlock.replaceAll("[\r\n]", "");
        return Base64.getDecoder().decode(signatureBlock);
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        String content = this.getContentWithoutSignatureBlock();
        if (signature != null) {
            int pos = this.getSignatureInsertionPoint(content);
            this.content = content.substring(0, pos) + this.createSignatureBlock(signature) + content.substring(pos);
        } else {
            this.content = content;
        }
    }

    private String createSignatureBlock(CMSSignedData signature) throws IOException {
        byte[] signatureBytes = signature.toASN1Structure().getEncoded("DER");
        String signatureBlob = Base64.getEncoder().encodeToString(signatureBytes);
        StringBuilder signatureBlock = new StringBuilder();
        signatureBlock.append("\r\n");
        signatureBlock.append(this.getSignatureStart()).append("\r\n");
        int blobLength = signatureBlob.length();
        for (int start = 0; start < blobLength; start += 64) {
            signatureBlock.append(this.getLineCommentStart());
            signatureBlock.append(signatureBlob, start, Math.min(blobLength, start + 64));
            signatureBlock.append(this.getLineCommentEnd());
            signatureBlock.append("\r\n");
        }
        signatureBlock.append(this.getSignatureEnd()).append("\r\n");
        return signatureBlock.toString();
    }

    protected int getSignatureInsertionPoint(String content) {
        return content.length();
    }

    protected String getContentWithoutSignatureBlock() {
        return this.getSignatureBlockRemovalPattern().matcher(this.getContent()).replaceFirst("");
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        digest.update(this.getContentWithoutSignatureBlock().getBytes(StandardCharsets.UTF_16LE));
        return digest.digest();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, this.getSpcSipInfo());
        return new SpcIndirectDataContent(data, digestInfo);
    }

    @Override
    public void save() throws IOException {
        if (this.file != null) {
            this.save(this.file);
        }
    }

    public void save(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            if (this.bom != null) {
                out.write(this.bom);
            }
            out.write(this.getContent().getBytes(this.encoding));
            out.flush();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

