/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import net.jsign.DigestAlgorithm;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Hex;

class HttpClient {
    private final File cacheDir;
    private final long expirationTime;

    public HttpClient(File cacheDir, long expirationTime) {
        this.cacheDir = cacheDir;
        this.expirationTime = expirationTime;
    }

    public InputStream getInputStream(URL url) throws IOException {
        File cacheFile = new File(this.cacheDir, this.getRequestHash(url) + ".cache");
        if (cacheFile.exists() && System.currentTimeMillis() - cacheFile.lastModified() < this.expirationTime) {
            return new FileInputStream(cacheFile);
        }
        HttpURLConnection conn = this.connect(url);
        if (conn.getResponseCode() >= 400) {
            throw new IOException("Unable to read " + url + " : " + conn.getResponseCode() + " - " + conn.getResponseMessage());
        }
        InputStream in = conn.getInputStream();
        byte[] response = IOUtils.toByteArray((InputStream)in);
        in.close();
        conn.disconnect();
        cacheFile.getParentFile().mkdirs();
        Files.write(cacheFile.toPath(), response, new OpenOption[0]);
        return new ByteArrayInputStream(response);
    }

    private HttpURLConnection connect(URL url) throws IOException {
        int redirections = 0;
        block3: while (redirections++ < 10) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            String userAgent = System.getProperty("http.agent");
            conn.setRequestProperty("User-Agent", "Jsign (https://ebourg.github.io/jsign/)" + (userAgent != null ? " " + userAgent : ""));
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setInstanceFollowRedirects(false);
            switch (conn.getResponseCode()) {
                case 301: 
                case 302: {
                    url = new URL(url, conn.getHeaderField("Location"));
                    continue block3;
                }
            }
            return conn;
        }
        throw new IOException("Too many redirections for " + url);
    }

    String getRequestHash(URL url) {
        MessageDigest digest = DigestAlgorithm.SHA1.getMessageDigest();
        digest.update(url.toString().getBytes());
        return Hex.toHexString((byte[])digest.digest());
    }
}

