/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jsign.KeyStoreType;

public class KeyStoreBuilder {
    private String parameterName = "parameter";
    private String keystore;
    private String storepass;
    private KeyStoreType storetype;
    private String keypass;
    private File keyfile;
    private File certfile;
    private File basedir = new File("empty").getParentFile();
    private Provider provider;

    public KeyStoreBuilder() {
    }

    KeyStoreBuilder(String parameterName) {
        this.parameterName = parameterName;
    }

    String parameterName() {
        return this.parameterName;
    }

    public KeyStoreBuilder keystore(File keystore) {
        return this.keystore(keystore.getPath());
    }

    public KeyStoreBuilder keystore(String keystore) {
        this.keystore = keystore;
        return this;
    }

    String keystore() {
        return this.keystore;
    }

    public KeyStoreBuilder storepass(String storepass) {
        this.storepass = storepass;
        return this;
    }

    String storepass() {
        this.storepass = this.readPassword("storepass", this.storepass);
        return this.storepass;
    }

    public KeyStoreBuilder storetype(KeyStoreType storetype) {
        this.storetype = storetype;
        return this;
    }

    public KeyStoreBuilder storetype(String storetype) {
        try {
            this.storetype = storetype != null ? KeyStoreType.valueOf(storetype.toUpperCase()) : null;
        }
        catch (IllegalArgumentException e) {
            String expectedTypes = Stream.of(KeyStoreType.values()).filter(type -> type != KeyStoreType.NONE).map(Enum::name).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Unknown keystore type '" + storetype + "' (expected types: " + expectedTypes + ")");
        }
        return this;
    }

    KeyStoreType storetype() {
        if (this.storetype == null) {
            if (this.keystore == null) {
                this.storetype = KeyStoreType.NONE;
            } else {
                File file = this.createFile(this.keystore);
                if (!file.isFile()) {
                    throw new IllegalArgumentException("Keystore file '" + this.keystore + "' not found");
                }
                this.storetype = KeyStoreType.of(file);
                if (this.storetype == null) {
                    throw new IllegalArgumentException("Keystore type of '" + this.keystore + "' not recognized");
                }
            }
        }
        return this.storetype;
    }

    public KeyStoreBuilder keypass(String keypass) {
        this.keypass = keypass;
        return this;
    }

    String keypass() {
        this.keypass = this.readPassword("keypass", this.keypass);
        return this.keypass;
    }

    public KeyStoreBuilder keyfile(String keyfile) {
        return this.keyfile(this.createFile(keyfile));
    }

    public KeyStoreBuilder keyfile(File keyfile) {
        this.keyfile = keyfile;
        return this;
    }

    File keyfile() {
        return this.keyfile;
    }

    public KeyStoreBuilder certfile(String certfile) {
        return this.certfile(this.createFile(certfile));
    }

    public KeyStoreBuilder certfile(File certfile) {
        this.certfile = certfile;
        return this;
    }

    File certfile() {
        return this.certfile;
    }

    void setBaseDir(File basedir) {
        this.basedir = basedir;
    }

    File createFile(String file) {
        if (file == null) {
            return null;
        }
        if (new File(file).isAbsolute()) {
            return new File(file);
        }
        return new File(this.basedir, file);
    }

    private String readPassword(String name, String value) {
        if (value != null) {
            if (value.startsWith("file:")) {
                String filename = value.substring("file:".length());
                Path path = this.createFile(filename).toPath();
                try {
                    value = String.join((CharSequence)"\n", Files.readAllLines(path, StandardCharsets.UTF_8)).trim();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to read the " + name + " " + this.parameterName + " from the file '" + filename + "'", e);
                }
            } else if (value.startsWith("env:")) {
                String variable = value.substring("env:".length());
                if (!System.getenv().containsKey(variable)) {
                    throw new IllegalArgumentException("Failed to read the " + name + " " + this.parameterName + ", the '" + variable + "' environment variable is not defined");
                }
                value = System.getenv(variable);
            }
        }
        return value;
    }

    void validate() throws IllegalArgumentException {
        if (this.keystore != null && this.keyfile != null) {
            throw new IllegalArgumentException("keystore " + this.parameterName + " can't be mixed with keyfile");
        }
        if (this.keystore == null && this.keyfile == null && this.certfile == null && this.storetype == null) {
            throw new IllegalArgumentException("Either keystore, or keyfile and certfile, or storetype " + this.parameterName + "s must be set");
        }
        this.storetype().validate(this);
    }

    public Provider provider() {
        if (this.provider == null) {
            this.provider = this.storetype().getProvider(this);
        }
        return this.provider;
    }

    public KeyStore build() throws KeyStoreException {
        this.validate();
        return this.storetype().getKeystore(this, this.provider());
    }

    public KeyStore.Builder builder() {
        return new KeyStore.Builder(){

            @Override
            public KeyStore getKeyStore() throws KeyStoreException {
                return KeyStoreBuilder.this.build();
            }

            @Override
            public KeyStore.ProtectionParameter getProtectionParameter(String alias) {
                String storepass = KeyStoreBuilder.this.storepass();
                return new KeyStore.PasswordProtection(storepass != null ? storepass.toCharArray() : null);
            }
        };
    }
}

