/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.jsign.ProviderUtils;
import net.jsign.jca.AutoLoginProvider;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class YubiKey {
    YubiKey() {
    }

    static Provider getProvider() {
        return new AutoLoginProvider((AuthProvider)ProviderUtils.createSunPKCS11Provider(YubiKey.getSunPKCS11Configuration()));
    }

    static String getSunPKCS11Configuration() {
        File libykcs11 = YubiKey.getYkcs11Library();
        if (!libykcs11.exists()) {
            throw new ProviderException("YubiKey PKCS11 module (ykcs11) is not installed (" + libykcs11 + " is missing)");
        }
        String configuration = "--name=yubikey\nlibrary = \"" + libykcs11.getAbsolutePath().replace("\\", "\\\\") + "\"\n";
        try {
            long slot = YubiKey.getTokenSlot(libykcs11);
            if (slot >= 0L) {
                configuration = configuration + "slot=" + slot;
            }
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return configuration;
    }

    static long getTokenSlot(File libraryPath) throws PKCS11Exception, IOException {
        PKCS11 pkcs11 = PKCS11.getInstance(libraryPath.getAbsolutePath(), "C_GetFunctionList", null, false);
        long[] slots = pkcs11.C_GetSlotList(true);
        return slots.length > 0 ? slots[0] : -1L;
    }

    static boolean isPresent() {
        try {
            return YubiKey.getTokenSlot(YubiKey.getYkcs11Library()) >= 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    static File getYkcs11Library() {
        String osname = System.getProperty("os.name");
        String arch = System.getProperty("sun.arch.data.model");
        if (osname.contains("Windows")) {
            String programfiles = "32".equals(arch) && System.getenv("ProgramFiles(x86)") != null ? System.getenv("ProgramFiles(x86)") : System.getenv("ProgramFiles");
            File libykcs11 = new File(programfiles + "/Yubico/Yubico PIV Tool/bin/libykcs11.dll");
            if (!System.getenv("PATH").contains("Yubico PIV Tool\\bin")) {
                Logger log = Logger.getLogger(YubiKey.class.getName());
                log.warning("The YubiKey library path (" + libykcs11.getParentFile().getAbsolutePath().replace('/', '\\') + ") is missing from the PATH environment variable");
            }
            return libykcs11;
        }
        if (osname.contains("Mac")) {
            return new File("/usr/local/lib/libykcs11.dylib");
        }
        ArrayList<String> paths = new ArrayList<String>();
        if ("32".equals(arch)) {
            paths.add("/usr/lib/libykcs11.so");
            paths.add("/usr/lib/libykcs11.so.1");
            paths.add("/usr/lib/i386-linux-gnu/libykcs11.so");
            paths.add("/usr/lib/arm-linux-gnueabi/libykcs11.so");
            paths.add("/usr/lib/arm-linux-gnueabihf/libykcs11.so");
        } else {
            paths.add("/usr/lib64/libykcs11.so");
            paths.add("/usr/lib64/libykcs11.so.1");
            paths.add("/usr/lib/x86_64-linux-gnu/libykcs11.so");
            paths.add("/usr/lib/aarch64-linux-gnu/libykcs11.so");
            paths.add("/usr/lib/mips64el-linux-gnuabi64/libykcs11.so");
            paths.add("/usr/lib/riscv64-linux-gnu/libykcs11.so");
        }
        for (String path : paths) {
            File libykcs11 = new File(path);
            if (!libykcs11.exists()) continue;
            return libykcs11;
        }
        return new File("/usr/local/lib/libykcs11.so");
    }
}

