/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smartcardio.CardException;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.PIVCard;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class PIVCardSigningService
implements SigningService {
    private final PIVCard card;
    private final Function<String, Certificate[]> certificateStore;

    public PIVCardSigningService(String cardname, String pin, Function<String, Certificate[]> certificateStore) throws CardException {
        PIVCard card = PIVCard.getCard(cardname);
        if (card == null) {
            throw new CardException("PIV card not found");
        }
        this.certificateStore = certificateStore;
        this.card = card;
        this.card.verify(pin);
    }

    @Override
    public String getName() {
        return "PIV";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        try {
            Set<PIVCard.Key> keys = this.card.getAvailableKeys();
            return keys.stream().map(Enum::name).collect(Collectors.toList());
        }
        catch (CardException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        LinkedHashMap<String, Certificate> certificates = new LinkedHashMap<String, Certificate>();
        PIVCard.Key key = PIVCard.Key.of(alias);
        if (key == null) {
            return null;
        }
        try {
            Certificate certificate = this.card.getCertificate(key);
            if (certificate == null) {
                return null;
            }
            String subject = ((X509Certificate)certificate).getSubjectX500Principal().getName();
            certificates.put(subject, certificate);
        }
        catch (CardException e) {
            throw new KeyStoreException(e);
        }
        if (this.certificateStore != null) {
            for (Certificate certificate : this.certificateStore.apply(alias)) {
                String subject = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                certificates.put(subject, certificate);
            }
        } else {
            certificates.putAll(this.getCertificateChain((Certificate)certificates.values().iterator().next()));
        }
        return certificates.values().toArray(new Certificate[0]);
    }

    private Map<String, X509Certificate> getCertificateChain(Certificate certificate) {
        LinkedHashMap<String, X509Certificate> chain = new LinkedHashMap<String, X509Certificate>();
        HashMap<String, X509Certificate> certificates = new HashMap<String, X509Certificate>();
        PIVCard.Key[] retiredKeys = PIVCard.Key.values();
        retiredKeys = Arrays.copyOfRange(retiredKeys, 4, retiredKeys.length);
        String issuer = ((X509Certificate)certificate).getIssuerX500Principal().getName();
        block2: for (PIVCard.Key retiredKey : retiredKeys) {
            try {
                X509Certificate issuerCertificate;
                X509Certificate extraCertificate = (X509Certificate)this.card.getCertificate(retiredKey);
                if (extraCertificate == null) continue;
                certificates.put(extraCertificate.getSubjectX500Principal().getName(), extraCertificate);
                while ((issuerCertificate = (X509Certificate)certificates.remove(issuer)) != null) {
                    chain.put(issuer, issuerCertificate);
                    if (issuer.equals(issuerCertificate.getIssuerX500Principal().getName())) break block2;
                    issuer = extraCertificate.getIssuerX500Principal().getName();
                }
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
        return chain;
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        PIVCard.Key key = PIVCard.Key.of(alias);
        try {
            Certificate certificate = this.card.getCertificate(key);
            return new SigningServicePrivateKey(alias, certificate.getPublicKey().getAlgorithm(), this);
        }
        catch (CardException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to retrieve the info for key " + alias).initCause(e);
        }
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        byte[] digest = digestAlgorithm.getMessageDigest().digest(data);
        PIVCard.Key key = PIVCard.Key.of(privateKey.getId());
        try {
            byte[] content;
            PIVCard.KeyInfo keyInfo = this.card.getKeyInfo(key);
            if ("RSA".equals(privateKey.getAlgorithm())) {
                DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE), digest);
                content = digestInfo.getEncoded("DER");
            } else {
                content = digest.length > keyInfo.size / 8 ? Arrays.copyOf(digest, keyInfo.size / 8) : digest;
            }
            return this.card.sign(key, content);
        }
        catch (IOException | CardException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

