/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import net.jsign.Console;
import net.jsign.MavenConsole;
import net.jsign.SignerException;
import net.jsign.SignerHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE)
public class JsignMojo
extends AbstractMojo {
    @Parameter
    private File file;
    @Parameter
    private FileSet fileset;
    @Parameter(property="jsign.name")
    private String name;
    @Parameter(property="jsign.url")
    private String url;
    @Parameter(property="jsign.algorithm", defaultValue="SHA-256")
    private String algorithm;
    @Parameter(property="jsign.keystore")
    private String keystore;
    @Parameter(property="jsign.storepass")
    private String storepass;
    @Parameter(property="jsign.storetype")
    private String storetype;
    @Parameter(property="jsign.alias")
    private String alias;
    @Parameter(property="jsign.certfile")
    private File certfile;
    @Parameter(property="jsign.keyfile")
    private File keyfile;
    @Parameter(property="jsign.keypass")
    private String keypass;
    @Parameter(property="jsign.tsaurl")
    private String tsaurl;
    @Parameter(property="jsign.tsmode", defaultValue="Authenticode")
    private String tsmode;
    @Parameter(property="jsign.tsretries", defaultValue="3")
    private int tsretries = -1;
    @Parameter(property="jsign.tsretrywait", defaultValue="10")
    private int tsretrywait = -1;
    @Parameter(property="jsign.replace", defaultValue="false")
    private boolean replace;
    @Parameter(property="jsign.encoding", defaultValue="UTF-8")
    private String encoding = "UTF-8";
    @Parameter(property="jsign.detached", defaultValue="false")
    private boolean detached;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(property="jsign.proxyId")
    private String proxyId;
    @Parameter(property="jsign.skip", defaultValue="false")
    protected boolean skip;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping signing");
            return;
        }
        if (this.file == null && this.fileset == null) {
            throw new MojoExecutionException("file of fileset must be set");
        }
        SignerHelper helper = new SignerHelper((Console)new MavenConsole(this.getLog()), "element");
        helper.setBaseDir(this.project.getBasedir());
        helper.name(this.name);
        helper.url(this.url);
        helper.alg(this.algorithm);
        helper.keystore(this.keystore);
        helper.storepass(this.decrypt(this.storepass));
        helper.storetype(this.storetype);
        helper.alias(this.alias);
        helper.certfile(this.certfile);
        helper.keyfile(this.keyfile);
        helper.keypass(this.decrypt(this.keypass));
        helper.tsaurl(this.tsaurl);
        helper.tsmode(this.tsmode);
        helper.tsretries(this.tsretries);
        helper.tsretrywait(this.tsretrywait);
        helper.replace(this.replace);
        helper.encoding(this.encoding);
        helper.detached(this.detached);
        Proxy proxy = this.getProxyFromSettings();
        if (proxy != null) {
            helper.proxyUrl(proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort());
            helper.proxyUser(proxy.getUsername());
            helper.proxyPass(proxy.getPassword());
        }
        try {
            if (this.file != null) {
                helper.sign(this.file);
            }
            if (this.fileset != null) {
                for (String filename : new FileSetManager().getIncludedFiles(this.fileset)) {
                    File file = new File(this.fileset.getDirectory(), filename);
                    helper.sign(file);
                }
            }
        }
        catch (SignerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private Proxy getProxyFromSettings() throws MojoExecutionException {
        if (this.settings == null) {
            return null;
        }
        if (this.proxyId != null) {
            for (Proxy proxy : this.settings.getProxies()) {
                if (!this.proxyId.equals(proxy.getId())) continue;
                return proxy;
            }
            throw new MojoExecutionException("Configured proxy with id=" + this.proxyId + " not found");
        }
        for (Proxy proxy : this.settings.getProxies()) {
            if (!proxy.isActive() || !"http".equalsIgnoreCase(proxy.getProtocol()) && !"https".equalsIgnoreCase(proxy.getProtocol())) continue;
            return proxy;
        }
        return null;
    }

    private String decrypt(String encoded) throws MojoExecutionException {
        if (encoded == null) {
            return null;
        }
        if (encoded.startsWith("mvn:")) {
            String serverId = encoded.substring(4);
            Server server = this.settings.getServer(serverId);
            if (server == null) {
                throw new MojoExecutionException("Server '" + serverId + "' not found in settings.xml");
            }
            if (server.getPassword() != null) {
                encoded = server.getPassword();
            } else if (server.getPassphrase() != null) {
                encoded = server.getPassphrase();
            } else {
                throw new MojoExecutionException("No password or passphrase found for server '" + serverId + "' in settings.xml");
            }
        }
        try {
            return this.securityDispatcher.decrypt(encoded);
        }
        catch (SecDispatcherException e) {
            this.getLog().error((CharSequence)("error using security dispatcher: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("error using security dispatcher: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

