/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.util.UUID;
import javax.management.MBeanServer;
import org.apache.commons.dbcp.BasicDataSource;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

public class ManagedBasicDataSource
extends BasicDataSource {
    public static final String DEFAULT_MBEAN_NAME = "org.apache.commons.dbcp:ManagedBasicDataSource=ManagedBasicDataSource";
    protected final String mBeanName;

    public ManagedBasicDataSource() {
        this("org.apache.commons.dbcp:ManagedBasicDataSource=ManagedBasicDataSource-" + UUID.randomUUID());
    }

    public ManagedBasicDataSource(String mBeanName) {
        this.mBeanName = mBeanName;
        this.exportMBean(ManagementFactory.getPlatformMBeanServer(), mBeanName);
    }

    public ManagedBasicDataSource(MBeanServer mBeanServer, String mBeanName) {
        this.mBeanName = mBeanName;
        this.exportMBean(mBeanServer, mBeanName);
    }

    protected synchronized void exportMBean(MBeanServer mBeanServer, String name) {
        new MBeanExporter(mBeanServer).export(name, (Object)this);
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        return super.unwrap(iface);
    }

    @Override
    @Managed(description="The current number of active connections that have been allocated from this data source.")
    public synchronized int getNumActive() {
        return super.getNumActive();
    }

    @Override
    @Managed(description="The current number of idle connections that are waiting to be allocated from this data source.")
    public synchronized int getNumIdle() {
        return super.getNumIdle();
    }

    @Override
    @Managed(description="The maximum number of active connections that can be allocated at the same time.")
    public synchronized int getMaxActive() {
        return super.getMaxActive();
    }

    @Override
    @Managed(description="Set the maximum number of active connections that can be allocated at the same time. Use a negative value for no limit.")
    public synchronized void setMaxActive(int maxActive) {
        super.setMaxActive(maxActive);
    }

    @Override
    @Managed(description="The maximum number of connections that can remain idle in the pool.")
    public synchronized int getMaxIdle() {
        return super.getMaxIdle();
    }

    @Override
    @Managed(description="Set the maximum number of connections that can remain idle in the pool.")
    public synchronized void setMaxIdle(int maxIdle) {
        super.setMaxIdle(maxIdle);
    }

    @Override
    @Managed(description="The minimum number of idle connections in the pool.")
    public synchronized int getMinIdle() {
        return super.getMinIdle();
    }

    @Override
    @Managed(description="The minimum number of idle connections in the pool.")
    public synchronized void setMinIdle(int minIdle) {
        super.setMinIdle(minIdle);
    }

    @Override
    @Managed(description="The maximum number of milliseconds that the pool will wait for a connection to be returned before throwing an exception.")
    public synchronized long getMaxWait() {
        return super.getMaxWait();
    }

    @Override
    @Managed(description="Set the maxWait property. Use -1 to make the pool wait indefinitely.")
    public synchronized void setMaxWait(long maxWait) {
        super.setMaxWait(maxWait);
    }

    @Override
    @Managed
    public synchronized String getUrl() {
        return super.getUrl();
    }

    @Override
    @Managed
    public String getUsername() {
        return super.getUsername();
    }
}

