/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbcp.ManagedBasicDataSource;

public class ManagedBasicDataSourceFactory
extends BasicDataSourceFactory {
    public static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    public static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    public static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    public static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    public static final String PROP_DRIVERCLASSNAME = "driverClassName";
    public static final String PROP_MAXACTIVE = "maxActive";
    public static final String PROP_MAXIDLE = "maxIdle";
    public static final String PROP_MINIDLE = "minIdle";
    public static final String PROP_INITIALSIZE = "initialSize";
    public static final String PROP_MAXWAIT = "maxWait";
    public static final String PROP_TESTONBORROW = "testOnBorrow";
    public static final String PROP_TESTONRETURN = "testOnReturn";
    public static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    public static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    public static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    public static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_VALIDATIONQUERY = "validationQuery";
    public static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    public static final String PROP_INITCONNECTIONSQLS = "initConnectionSqls";
    public static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    public static final String PROP_REMOVEABANDONED = "removeAbandoned";
    public static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    public static final String PROP_LOGABANDONED = "logAbandoned";
    public static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    public static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    public static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    public static final String PROP_MBEANNAME = "mbeanName";
    public static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "initConnectionSqls", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties", "mbeanName"};

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            String propertyName = ALL_PROPERTIES[i];
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return ManagedBasicDataSourceFactory.createDataSource(properties);
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        String value = null;
        value = properties.getProperty(PROP_MBEANNAME);
        ManagedBasicDataSource dataSource = value != null ? new ManagedBasicDataSource(value) : new ManagedBasicDataSource();
        value = properties.getProperty(PROP_DEFAULTAUTOCOMMIT);
        if (value != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = properties.getProperty(PROP_MAXACTIVE)) != null) {
            dataSource.setMaxActive(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXIDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINIDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIALSIZE)) != null) {
            dataSource.setInitialSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXWAIT)) != null) {
            dataSource.setMaxWait(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTONBORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONRETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = properties.getProperty(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = properties.getProperty(PROP_USERNAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            dataSource.setValidationQueryTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONED)) != null) {
            dataSource.setRemoveAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_LOGABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            dataSource.setMaxOpenPreparedStatements(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITCONNECTIONSQLS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ";");
            dataSource.setConnectionInitSqls(Collections.list(tokenizer));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties p = ManagedBasicDataSourceFactory.getProperties(value);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        if (dataSource.getInitialSize() > 0) {
            dataSource.getLogWriter();
        }
        return dataSource;
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes()));
        }
        return p;
    }
}

