/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.digest.FileDigester;
import net.nicoulaj.maven.plugins.checksum.execution.AbstractExecution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetWriteException;
import org.apache.maven.plugin.logging.Log;

public class NeverFailExecution
extends AbstractExecution {
    protected final Log logger;

    public NeverFailExecution(Log logger) {
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            this.checkParameters();
        }
        catch (ExecutionException e) {
            this.logger.error((CharSequence)e.getMessage());
            return;
        }
        for (ExecutionTarget target : this.getTargets()) {
            try {
                target.init();
            }
            catch (Exception e) {
                this.removeTarget(target);
                this.logger.warn((CharSequence)e.getMessage());
                if (!this.getTargets().isEmpty()) continue;
                this.logger.warn((CharSequence)"No output target for computed hashcodes, execution canceled.");
                return;
            }
        }
        for (File file : this.files) {
            for (String algorithm : this.getAlgorithms()) {
                try {
                    FileDigester digester = DigesterFactory.getInstance().getFileDigester(algorithm);
                    String hash = digester.calculate(file);
                    for (ExecutionTarget target : this.getTargets()) {
                        try {
                            target.write(hash, file, algorithm);
                        }
                        catch (ExecutionTargetWriteException e) {
                            this.logger.warn((CharSequence)e.getMessage());
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.warn((CharSequence)("Unsupported algorithm " + algorithm + "."));
                }
                catch (DigesterException e) {
                    this.logger.warn((CharSequence)("Unable to calculate " + algorithm + " hash for " + file.getName() + ": " + e.getMessage()));
                }
            }
        }
        for (ExecutionTarget target : this.getTargets()) {
            try {
                target.close();
            }
            catch (Exception e) {
                this.logger.warn((CharSequence)e.getMessage());
            }
        }
    }
}

