/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.util.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertisementFactory
extends ClassFactory<String, Instantiator> {
    private static final Logger LOG = Logger.getLogger(AdvertisementFactory.class.getName());
    private static final AdvertisementFactory factory = new AdvertisementFactory();
    private final Map<String, Instantiator> encodings = new HashMap<String, Instantiator>();
    private boolean loadedProperty = false;

    private AdvertisementFactory() {
    }

    private synchronized boolean loadProviders() {
        if (!AdvertisementFactory.factory.loadedProperty) {
            AdvertisementFactory.factory.loadedProperty = this.registerProviders(Advertisement.class.getName());
        }
        return AdvertisementFactory.factory.loadedProperty;
    }

    @Override
    protected Map<String, Instantiator> getAssocTable() {
        return this.encodings;
    }

    @Override
    public Class<Instantiator> getClassOfInstantiators() {
        return Instantiator.class;
    }

    @Override
    public Class<String> getClassForKey() {
        return String.class;
    }

    @Override
    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block2: {
            registeredSomething = false;
            try {
                Class<?> advClass = Class.forName(className + "$Instantiator");
                Instantiator instantiator = (Instantiator)advClass.newInstance();
                String advType = instantiator.getAdvertisementType();
                registeredSomething = AdvertisementFactory.registerAdvertisementInstance(advType, instantiator);
            }
            catch (Exception all) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.log(Level.FINE, "Failed to register '" + className + "'", all);
            }
        }
        return registeredSomething;
    }

    public static boolean registerAdvertisementInstance(String rootType, Instantiator instantiator) {
        boolean result = factory.registerAssoc(rootType, instantiator);
        return result;
    }

    public static Advertisement newAdvertisement(String advertisementType) {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(advertisementType);
        Advertisement a = instantiator.newInstance();
        return a;
    }

    @Deprecated
    public static Advertisement newAdvertisement(MimeMediaType mimetype, InputStream stream) throws IOException {
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(mimetype, stream);
        if (!(doc instanceof XMLDocument)) {
            throw new IllegalArgumentException("Advertisements must be XML");
        }
        return AdvertisementFactory.newAdvertisement((XMLDocument)doc);
    }

    @Deprecated
    public static Advertisement newAdvertisement(MimeMediaType mimetype, Reader source) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimetype, source);
        return AdvertisementFactory.newAdvertisement(doc);
    }

    @Deprecated
    public static Advertisement newAdvertisement(TextElement root) {
        if (!(root instanceof XMLElement)) {
            throw new IllegalArgumentException("Advertisements must be XML");
        }
        return AdvertisementFactory.newAdvertisement((XMLElement)root);
    }

    public static Advertisement newAdvertisement(XMLElement root) {
        factory.loadProviders();
        Instantiator instantiator = null;
        Attribute type = root.getAttribute("type");
        if (null != type) {
            try {
                instantiator = (Instantiator)factory.getInstantiator(type.getValue());
            }
            catch (NoSuchElementException notThere) {
                // empty catch block
            }
        }
        if (null == instantiator) {
            instantiator = (Instantiator)factory.getInstantiator(root.getName());
        }
        Advertisement a = instantiator.newInstance(root);
        return a;
    }

    public static interface Instantiator {
        public String getAdvertisementType();

        public Advertisement newInstance();

        public Advertisement newInstance(Element var1);
    }
}

