/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Indexer {
    private static final transient Logger LOG = Logger.getLogger(Indexer.class.getName());
    private static final String listFileName = "offsets";
    private String dir = null;
    private String file = null;
    private final Map<String, NameIndexer> indices = new HashMap<String, NameIndexer>();
    private BTreeFiler listDB = null;
    private boolean sync = true;

    public Indexer() {
    }

    public Indexer(boolean sync) {
        this.sync = sync;
    }

    public void setLocation(String dir, String file) {
        block10: {
            File[] indexFiles;
            this.dir = dir;
            this.file = file;
            File directory = new File(dir);
            for (File indexFile : indexFiles = directory.listFiles(new FilenameFilter(){

                public boolean accept(File parentDir, String fileName) {
                    return fileName.endsWith(".idx");
                }
            })) {
                String name;
                String indexFileName = indexFile.getName();
                int dash = indexFileName.lastIndexOf("-");
                int dot = indexFileName.lastIndexOf(".idx");
                if (dot <= 0 || dash <= 0 || this.indices.get(name = indexFileName.substring(dash + 1, dot).trim()) != null) continue;
                try {
                    NameIndexer indexer = new NameIndexer();
                    indexer.setLocation(dir, file + "-" + name);
                    indexer.setSync(this.sync);
                    if (!indexer.open()) {
                        indexer.create();
                        indexer.open();
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Adding :" + indexFileName + " under " + name);
                    }
                    this.indices.put(name, indexer);
                }
                catch (DBException ignore) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.log(Level.SEVERE, "Failed to create Index " + name, ignore);
                }
            }
            try {
                this.listDB = new BTreeFiler();
                this.listDB.setSync(this.sync);
                this.listDB.setLocation(directory.getCanonicalPath(), file + "-" + listFileName);
                if (!this.listDB.open()) {
                    this.listDB.create();
                    this.listDB.open();
                }
            }
            catch (DBException dbe) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed during listDB Creation", dbe);
                }
            }
            catch (IOException ie) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block10;
                LOG.log(Level.SEVERE, "Failed during listDB Creation", ie);
            }
        }
    }

    public boolean open() throws DBException {
        return true;
    }

    public boolean create() throws DBException {
        return true;
    }

    public synchronized boolean close() throws DBException {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closing Indexer");
        }
        Iterator<Map.Entry<String, NameIndexer>> eachIndex = this.indices.entrySet().iterator();
        while (eachIndex.hasNext()) {
            block6: {
                Map.Entry<String, NameIndexer> anEntry = eachIndex.next();
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Closing Index :" + anEntry.getKey());
                }
                try {
                    anEntry.getValue().close();
                }
                catch (Exception failed) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                    LOG.log(Level.WARNING, "Failure closing index :" + anEntry.getKey(), failed);
                }
            }
            eachIndex.remove();
        }
        this.indices.clear();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Closing listDB");
        }
        this.listDB.close();
        return true;
    }

    public Map<String, NameIndexer> getIndexers() {
        return Collections.unmodifiableMap(this.indices);
    }

    public BTreeFiler getListDB() {
        return this.listDB;
    }

    public void search(IndexQuery query, String name, BTreeCallback callback) throws IOException, BTreeException {
        int op;
        BTreeCallback cb = new SearchCallback(this.listDB, callback);
        if (query != null && ((op = query.getOperator()) == 8 || op == -8 || op == 5)) {
            query = new IndexQuery(0, query.getValues());
            cb = new EndsWithCallback(op, new SearchCallback(this.listDB, callback), query.getValue(0));
        }
        if (name == null) {
            if (this.indices != null) {
                Iterator<NameIndexer> i = this.indices.values().iterator();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Searching all indexes");
                }
                while (i.hasNext()) {
                    NameIndexer index = i.next();
                    index.query(query, new SearchCallback(this.listDB, callback));
                }
            }
        } else {
            NameIndexer indexer = this.indices.get(name);
            if (indexer == null) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Searching Index : " + name);
            }
            indexer.query(query, cb);
        }
    }

    public void addToIndex(Map<String, String> indexables, long pos) throws IOException, DBException {
        if (indexables == null) {
            return;
        }
        for (String name : indexables.keySet()) {
            NameIndexer indexer;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("looking up NameIndexer : " + name);
            }
            if ((indexer = this.indices.get(name)) == null) {
                indexer = new NameIndexer();
                indexer.setLocation(this.dir, this.file + "-" + name);
                indexer.setSync(this.sync);
                if (!indexer.open()) {
                    indexer.create();
                    indexer.open();
                }
                this.indices.put(name, indexer);
            }
            Key dbKey = new Key(name + indexables.get(name));
            Key indexKey = new Key(indexables.get(name));
            long listPos = Indexer.writeRecord(this.listDB, dbKey, pos);
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                StringBuilder message = new StringBuilder().append("Adding a reference at position :").append(listPos).append(" to ").append(name).append(" index, Key: ").append(indexables.get(name));
                LOG.finer(message.toString());
            }
            indexer.add(indexKey, listPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromIndex(Map<String, String> indexables, long pos) throws DBException {
        Set<String> names = indexables == null ? this.indices.keySet() : indexables.keySet();
        Long lpos = pos;
        for (String name : names) {
            NameIndexer indexer = this.indices.get(name);
            if (indexer == null) continue;
            Key dbKey = null;
            if (indexables != null) {
                dbKey = new Key(name + indexables.get(name));
            }
            Key indexKey = null;
            if (indexables != null) {
                indexKey = new Key(indexables.get(name));
            }
            BTreeFiler bTreeFiler = this.listDB;
            synchronized (bTreeFiler) {
                Record record = this.listDB.readRecord(dbKey);
                Set<Long> offsets = Indexer.readRecord(record);
                if (!offsets.isEmpty()) {
                    if (offsets.contains(lpos)) {
                        offsets.remove(lpos);
                        Value recordValue = new Value(Indexer.toByteArray(offsets));
                        this.listDB.writeRecord(dbKey, recordValue);
                    }
                    if (offsets.isEmpty()) {
                        this.listDB.deleteRecord(dbKey);
                        indexer.remove(indexKey);
                    }
                } else {
                    this.listDB.deleteRecord(dbKey);
                    indexer.remove(indexKey);
                }
            }
        }
    }

    public void purge(List<Long> list) throws IOException, BTreeException {
        IndexQuery iq = new IndexQuery(0, "");
        ArrayList<String> keys = new ArrayList<String>(this.indices.keySet());
        for (String objKey : keys) {
            NameIndexer index = this.indices.get(objKey);
            PurgeCallback pc = new PurgeCallback(this.listDB, index, objKey, list);
            index.query(iq, pc);
        }
    }

    public void purge(long pos) throws IOException, BTreeException {
        this.purge(Collections.singletonList(pos));
    }

    private static byte[] toByteArray(Set<Long> offsets) {
        try {
            int size = offsets.size();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 8 + 4);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(size);
            for (Long lpos : offsets) {
                dos.writeLong(lpos);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException ie) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Exception during array to byte array conversion", ie);
            }
            return null;
        }
    }

    public static Set<Long> readRecord(Record record) {
        TreeSet<Long> result;
        block4: {
            result = new TreeSet<Long>();
            if (record == null) {
                return result;
            }
            InputStream is = record.getValue().getInputStream();
            try {
                DataInputStream ois = new DataInputStream(is);
                int size = ois.readInt();
                for (int i = 0; i < size; ++i) {
                    result.add(ois.readLong());
                }
                ois.close();
            }
            catch (IOException ie) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "Exception while reading Entry", ie);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeRecord(BTreeFiler listDB, Key key, long pos) throws DBException, IOException {
        BTreeFiler bTreeFiler = listDB;
        synchronized (bTreeFiler) {
            Long lpos = pos;
            Record record = listDB.readRecord(key);
            Set<Long> offsets = Indexer.readRecord(record);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE) && offsets != null) {
                LOG.finer("list.contains " + pos + " : " + offsets.contains(lpos));
            }
            if (offsets != null && !offsets.contains(lpos)) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Adding a reference to record at :" + lpos);
                    LOG.finer("Writing :" + offsets.size() + " references");
                }
                offsets.add(lpos);
            }
            Value recordValue = new Value(Indexer.toByteArray(offsets));
            return listDB.writeRecord(key, recordValue);
        }
    }

    public static final class SearchCallback
    implements BTreeCallback {
        private BTreeCallback callback = null;
        private BTreeFiler listDB = null;

        public SearchCallback(BTreeFiler listDB, BTreeCallback callback) {
            this.listDB = listDB;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Found " + val.toString() + " at " + pos);
            }
            Record record = null;
            Set<Long> offsets = null;
            boolean result = true;
            try {
                BTreeFiler bTreeFiler = this.listDB;
                synchronized (bTreeFiler) {
                    record = this.listDB.readRecord(pos);
                    offsets = Indexer.readRecord(record);
                    if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Found " + offsets.size() + " entries");
                    }
                }
                for (Long lpos : offsets) {
                    result &= this.callback.indexInfo(val, lpos);
                    if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) continue;
                    LOG.finer("Callback result : " + result);
                }
            }
            catch (DBException ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                }
                return false;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PurgeCallback
    implements BTreeCallback {
        private final NameIndexer indexer;
        private final List<Long> list;
        private final BTreeFiler listDB;
        private final String indexKey;

        PurgeCallback(BTreeFiler listDB, NameIndexer indexer, String indexKey, List<Long> list) {
            this.listDB = listDB;
            this.indexer = indexer;
            this.indexKey = indexKey;
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean indexInfo(Value val, long pos) {
            block8: {
                try {
                    BTreeFiler bTreeFiler = this.listDB;
                    synchronized (bTreeFiler) {
                        Record record = this.listDB.readRecord(pos);
                        Set<Long> offsets = Indexer.readRecord(record);
                        boolean changed = offsets.removeAll(this.list);
                        if (changed) {
                            if (!offsets.isEmpty()) {
                                Value recordValue = new Value(Indexer.toByteArray(offsets));
                                this.listDB.writeRecord(pos, recordValue);
                            } else {
                                this.listDB.deleteRecord(new Key(this.indexKey + val));
                                this.indexer.remove(new Key(val));
                            }
                        }
                    }
                }
                catch (DBException ignore) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                    LOG.log(Level.WARNING, "An exception occured", ignore);
                }
            }
            return true;
        }
    }

    private static final class EndsWithCallback
    implements BTreeCallback {
        private int op = 0;
        private BTreeCallback callback = null;
        private Value pattern = null;

        EndsWithCallback(int op, BTreeCallback callback, Value pattern) {
            this.op = op;
            this.callback = callback;
            this.pattern = pattern;
        }

        public boolean indexInfo(Value val, long pos) {
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("value :" + val + " pattern :" + this.pattern);
            }
            switch (this.op) {
                case 8: {
                    if (!val.endsWith(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
                case -8: {
                    if (val.endsWith(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
                case 5: {
                    if (!val.contains(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
            }
            return true;
        }
    }
}

