/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Indexer;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrdiIndex
implements Runnable {
    private static final transient Logger LOG = Logger.getLogger(SrdiIndex.class.getName());
    private long interval = 600000L;
    private volatile boolean stop = false;
    private final Indexer srdiIndexer;
    private final BTreeFiler cacheDB;
    private Thread gcThread = null;
    private final Set<PeerID> gcPeerTBL = new HashSet<PeerID>();
    private final String indexName;

    public SrdiIndex(PeerGroup group, String indexName) {
        this.indexName = indexName;
        try {
            File storeHome;
            String pgdir = null;
            if (group == null) {
                pgdir = "srdi-index";
                storeHome = new File(".jxta");
            } else {
                pgdir = group.getPeerGroupID().getUniqueValue().toString();
                storeHome = new File(group.getStoreHome());
            }
            File rootDir = new File(new File(storeHome, "cm"), pgdir);
            rootDir = new File(rootDir, "srdi");
            if (!rootDir.exists() && !rootDir.mkdirs()) {
                throw new RuntimeException("Cm cannot create directory " + rootDir);
            }
            this.cacheDB = new BTreeFiler();
            this.cacheDB.setSync(false);
            this.cacheDB.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.cacheDB.open()) {
                this.cacheDB.create();
                this.cacheDB.open();
            }
            this.srdiIndexer = new Indexer(false);
            this.srdiIndexer.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.srdiIndexer.open()) {
                this.srdiIndexer.create();
                this.srdiIndexer.open();
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("[" + (group == null ? "none" : group.toString()) + "] : Initialized " + indexName);
            }
        }
        catch (DBException de) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unable to Initialize databases", de);
            }
            throw new UndeclaredThrowableException(de, "Unable to Initialize databases");
        }
        catch (Throwable e) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unable to create Cm", e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e, "Unable to create Cm");
        }
    }

    public SrdiIndex(PeerGroup group, String indexName, long interval) {
        this(group, indexName);
        this.interval = interval;
        this.startGC(group, indexName, interval);
    }

    protected void startGC(PeerGroup group, String indexName, long interval) {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("[" + (group == null ? "none" : group.toString()) + "] : Starting SRDI GC Thread for " + indexName);
        }
        this.gcThread = new Thread(group.getHomeThreadGroup(), this, "SrdiIndex GC :" + indexName + " every " + interval + "ms");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    public String getIndexName() {
        return this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String primaryKey, String attribute, String value, PeerID pid, long expiration) {
        block12: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.indexName + "] Adding " + primaryKey + "/" + attribute + " = '" + value + "' for " + pid);
            }
            try {
                Key key = new Key(primaryKey + attribute + value);
                long expiresin = TimeUtils.toAbsoluteTimeMillis(expiration);
                BTreeFiler bTreeFiler = this.cacheDB;
                synchronized (bTreeFiler) {
                    this.gcPeerTBL.remove(pid);
                    Record record = this.cacheDB.readRecord(key);
                    List<Entry> old = record != null ? SrdiIndex.readRecord((Record)record).list : new ArrayList<Entry>();
                    Entry entry = new Entry(pid, expiresin);
                    if (!old.contains(entry)) {
                        old.add(entry);
                    } else {
                        old.remove(old.indexOf(entry));
                        old.add(entry);
                    }
                    old = SrdiIndex.removeExpired(old);
                    long t0 = TimeUtils.timeNow();
                    byte[] data = SrdiIndex.getData(key, old);
                    if (data == null) {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.severe("Failed to serialize data");
                        }
                        return;
                    }
                    Value recordValue = new Value(data);
                    long pos = this.cacheDB.writeRecord(key, recordValue);
                    Map<String, String> indexables = this.getIndexMap(primaryKey + attribute, value);
                    this.srdiIndexer.addToIndex(indexables, pos);
                }
            }
            catch (IOException de) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed to add SRDI", de);
                }
            }
            catch (DBException de) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Failed to add SRDI", de);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getRecord(String pkey, String skey, String value) {
        Record record;
        block5: {
            record = null;
            try {
                Key key = new Key(pkey + skey + value);
                BTreeFiler bTreeFiler = this.cacheDB;
                synchronized (bTreeFiler) {
                    record = this.cacheDB.readRecord(key);
                }
            }
            catch (DBException de) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Failed to retrieve SrdiIndex record", de);
            }
        }
        return SrdiIndex.readRecord(record).list;
    }

    private Map<String, String> getIndexMap(String primaryKey, String value) {
        if (primaryKey == null) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(primaryKey, value);
        return map;
    }

    public synchronized void remove(PeerID pid) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(" Adding " + pid + " to peer GC table");
        }
        this.gcPeerTBL.add(pid);
    }

    public synchronized List<PeerID> query(String primaryKey, String attribute, String value, int threshold) {
        List<PeerID> res;
        block7: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.indexName + "] Querying for " + threshold + " " + primaryKey + "/" + attribute + " = '" + value + "'");
            }
            if (primaryKey == null) {
                return Collections.emptyList();
            }
            if (attribute == null) {
                res = this.query(primaryKey);
            } else {
                res = new ArrayList<PeerID>();
                IndexQuery iq = Cm.getIndexQuery(value);
                try {
                    this.srdiIndexer.search(iq, primaryKey + attribute, new SearchCallback(this.cacheDB, res, threshold, this.gcPeerTBL));
                }
                catch (Exception ex) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                    LOG.log(Level.WARNING, "Exception while searching in index", ex);
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.indexName + "] Returning " + res.size() + " results for " + primaryKey + "/" + attribute + " = '" + value + "'");
        }
        return res;
    }

    public synchronized List<PeerID> query(String primaryKey) {
        ArrayList<PeerID> res;
        block5: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.indexName + "] Querying for " + primaryKey);
            }
            res = new ArrayList<PeerID>();
            try {
                Map<String, NameIndexer> map = this.srdiIndexer.getIndexers();
                for (Map.Entry<String, NameIndexer> index : map.entrySet()) {
                    String indexName = index.getKey();
                    if (!indexName.startsWith(primaryKey)) continue;
                    NameIndexer idxr = index.getValue();
                    idxr.query(null, new SearchCallback(this.cacheDB, res, Integer.MAX_VALUE, this.gcPeerTBL));
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Exception while searching in index", ex);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.indexName + "] Returning " + res.size() + " results for " + primaryKey);
        }
        return res;
    }

    private static void copyIntoList(List<PeerID> to, List<Entry> from, Set<PeerID> table) {
        for (Entry entry : from) {
            boolean expired = entry.isExpired();
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.finer("Entry peerid : " + entry.peerid + (expired ? " EXPIRED " : " Expires at : " + entry.expiration));
            }
            if (!to.contains(entry.peerid) && !expired) {
                if (!table.contains(entry.peerid)) {
                    if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                        LOG.finer("adding Entry :" + entry.peerid + " to list");
                    }
                    to.add(entry.peerid);
                    continue;
                }
                if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) continue;
                LOG.finer("Skipping gc marked entry :" + entry.peerid);
                continue;
            }
            if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) continue;
            LOG.finer("Skipping expired Entry :" + entry.peerid);
        }
    }

    private static byte[] getData(Key key, List<Entry> list) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(key.toString());
            dos.writeInt(list.size());
            for (Entry anEntry : list) {
                dos.writeUTF(anEntry.peerid.toString());
                dos.writeLong(anEntry.expiration);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException ie) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Exception while reading Entry", ie);
            }
            return null;
        }
    }

    public static SrdiIndexRecord readRecord(Record record) {
        Key key;
        ArrayList<Entry> result;
        block9: {
            result = new ArrayList<Entry>();
            key = null;
            if (record == null) {
                return new SrdiIndexRecord(null, result);
            }
            if (record.getValue().getLength() <= 0) {
                return new SrdiIndexRecord(null, result);
            }
            InputStream is = record.getValue().getInputStream();
            try {
                DataInputStream ois = new DataInputStream(is);
                key = new Key(ois.readUTF());
                int size = ois.readInt();
                for (int i = 0; i < size; ++i) {
                    try {
                        String idstr = ois.readUTF();
                        PeerID pid = (PeerID)IDFactory.fromURI(new URI(idstr));
                        long exp = ois.readLong();
                        Entry entry = new Entry(pid, exp);
                        result.add(entry);
                        continue;
                    }
                    catch (URISyntaxException badID) {
                        // empty catch block
                    }
                }
                ois.close();
            }
            catch (EOFException eofe) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Empty record", eofe);
                }
            }
            catch (IOException ie) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                LOG.log(Level.WARNING, "Exception while reading Entry", ie);
            }
        }
        return new SrdiIndexRecord(key, result);
    }

    public synchronized void clear() {
        block2: {
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "failed to close index", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void garbageCollect() {
        block6: {
            try {
                Map<String, NameIndexer> map = this.srdiIndexer.getIndexers();
                for (NameIndexer idxr : map.values()) {
                    ArrayList<Long> list = new ArrayList<Long>();
                    if (this.stop) break;
                    SrdiIndex srdiIndex = this;
                    synchronized (srdiIndex) {
                        idxr.query(null, new GcCallback(this.cacheDB, this.srdiIndexer, list, this.gcPeerTBL));
                        this.srdiIndexer.purge(list);
                    }
                }
                this.gcPeerTBL.clear();
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.log(Level.WARNING, "Failure during SRDI Garbage Collect", ex);
            }
        }
    }

    private static List<Entry> removeExpired(List<Entry> list) {
        Iterator<Entry> eachEntry = list.iterator();
        while (eachEntry.hasNext()) {
            Entry entry = eachEntry.next();
            if (!entry.isExpired()) continue;
            eachEntry.remove();
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Removing expired Entry peerid :" + entry.peerid + " Expires at :" + entry.expiration);
        }
        return list;
    }

    private static boolean isExpired(long expiration) {
        return TimeUtils.timeNow() > expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        block9: {
            block8: {
                if (this.stop) {
                    return;
                }
                this.stop = true;
                try {
                    Thread temp = this.gcThread;
                    if (temp == null) break block8;
                    Thread thread = temp;
                    synchronized (thread) {
                        temp.notify();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
                this.gcPeerTBL.clear();
            }
            catch (Exception ex) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block9;
                LOG.log(Level.SEVERE, "Unable to stop the Srdi Indexer", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {}
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                Object var4_5 = null;
                SrdiIndex srdiIndex = this;
                synchronized (srdiIndex) {
                    this.gcThread = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            SrdiIndex srdiIndex3 = this;
            synchronized (srdiIndex3) {
                this.gcThread = null;
                throw throwable;
            }
        }
        while (!this.stop) {
            try {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Waiting for " + this.interval + "ms before garbage collection");
                }
                Thread thread = this.gcThread;
                synchronized (thread) {
                    this.gcThread.wait(this.interval);
                }
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
                continue;
            }
            if (this.stop) break;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Garbage collection started");
            }
            this.garbageCollect();
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Garbage collection completed");
        }
        Object var4_4 = null;
        SrdiIndex srdiIndex = this;
        synchronized (srdiIndex) {
            this.gcThread = null;
            return;
        }
    }

    public static void clearSrdi(PeerGroup group) {
        block7: {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Clearing SRDI for " + group.getPeerGroupName());
            }
            try {
                String pgdir = null;
                pgdir = group == null ? "srdi-index" : group.getPeerGroupID().getUniqueValue().toString();
                File rootDir = null;
                if (group != null) {
                    rootDir = new File(new File(new File(group.getStoreHome()), "cm"), pgdir);
                }
                if ((rootDir = new File(rootDir, "srdi")).exists()) {
                    String[] list;
                    for (String aList : list = rootDir.list()) {
                        File file;
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Removing : " + aList);
                        }
                        if ((file = new File(rootDir, aList)).delete() || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.warning("Unable to delete the file");
                    }
                    rootDir.delete();
                }
            }
            catch (Throwable t) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "Unable to clear Srdi", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SrdiIndexRecord {
        public final Key key;
        public final List<Entry> list;

        public SrdiIndexRecord(Key key, List<Entry> list) {
            this.key = key;
            this.list = list;
        }

        public boolean equals(Object obj) {
            return obj instanceof SrdiIndexRecord && this.key.equals(((SrdiIndexRecord)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static final class Entry {
        public final PeerID peerid;
        public final long expiration;

        public Entry(PeerID peerid, long expiration) {
            this.peerid = peerid;
            this.expiration = expiration;
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && this.peerid.equals(((Entry)obj).peerid);
        }

        public int hashCode() {
            return this.peerid.hashCode();
        }

        public long getExpiration() {
            return this.expiration;
        }

        public boolean isExpired() {
            return TimeUtils.timeNow() > this.expiration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GcCallback
    implements BTreeCallback {
        private final BTreeFiler cacheDB;
        private final Indexer idxr;
        private final List<Long> list;
        private final Set<PeerID> table;

        GcCallback(BTreeFiler cacheDB, Indexer idxr, List<Long> list, Set<PeerID> table) {
            this.cacheDB = cacheDB;
            this.idxr = idxr;
            this.list = list;
            this.table = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            BTreeFiler bTreeFiler = this.cacheDB;
            synchronized (bTreeFiler) {
                block15: {
                    try {
                        record = this.cacheDB.readRecord(pos);
                    }
                    catch (DBException ex) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                        }
                        return false;
                    }
                    if (record == null) {
                        return true;
                    }
                    SrdiIndexRecord rec = SrdiIndex.readRecord(record);
                    List<Entry> res = rec.list;
                    boolean changed = false;
                    Iterator<Entry> eachEntry = res.iterator();
                    while (eachEntry.hasNext()) {
                        Entry entry = eachEntry.next();
                        if (!entry.isExpired() && !this.table.contains(entry.peerid)) continue;
                        changed = true;
                        eachEntry.remove();
                    }
                    if (changed) {
                        if (res.isEmpty()) {
                            try {
                                this.cacheDB.deleteRecord(rec.key);
                                this.list.add(pos);
                            }
                            catch (DBException e) {
                                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                    LOG.log(Level.WARNING, "Exception while deleting empty record", e);
                                }
                                break block15;
                            }
                        }
                        byte[] data = SrdiIndex.getData(rec.key, res);
                        Value recordValue = new Value(data);
                        try {
                            this.cacheDB.writeRecord(pos, recordValue);
                        }
                        catch (DBException ex) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block15;
                            LOG.log(Level.WARNING, "Exception while writing back record", ex);
                        }
                    }
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SearchCallback
    implements BTreeCallback {
        private final BTreeFiler cacheDB;
        private final int threshold;
        private final List<PeerID> results;
        private final Set<PeerID> excludeTable;

        SearchCallback(BTreeFiler cacheDB, List<PeerID> results, int threshold, Set<PeerID> excludeTable) {
            this.cacheDB = cacheDB;
            this.threshold = threshold;
            this.results = results;
            this.excludeTable = excludeTable;
        }

        @Override
        public boolean indexInfo(Value val, long pos) {
            if (this.results.size() >= this.threshold) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SearchCallback.indexInfo reached Threshold :" + this.threshold);
                }
                return false;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found " + val);
            }
            Record record = null;
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception while reading indexed", ex);
                }
                return false;
            }
            if (record != null) {
                long t0 = TimeUtils.timeNow();
                SrdiIndexRecord rec = SrdiIndex.readRecord(record);
                if (Logging.SHOW_FINEST && LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Got result back in : " + (TimeUtils.timeNow() - t0) + "ms.");
                }
                SrdiIndex.copyIntoList(this.results, rec.list, this.excludeTable);
            }
            return this.results.size() < this.threshold;
        }
    }
}

