/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;

public class LoopbackMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger(LoopbackMessenger.class.getName());
    private final PeerGroup group;
    private final EndpointService endpoint;
    private final EndpointAddress srcAddress;
    private final EndpointAddress logicalDestination;
    private final Lock orderingLock = new ReentrantLock(true);

    public LoopbackMessenger(PeerGroup group, EndpointService ep, EndpointAddress src, EndpointAddress dest, EndpointAddress logicalDest) {
        super(group.getPeerGroupID(), dest, false);
        this.group = group;
        this.endpoint = ep;
        this.srcAddress = src;
        this.logicalDestination = logicalDest;
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.logicalDestination;
    }

    public long getMTU() {
        return Long.MAX_VALUE;
    }

    public boolean isIdleImpl() {
        return false;
    }

    public void closeImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageBImpl(final Message message, final String service, final String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, failure.getMessage(), failure);
            }
            throw failure;
        }
        this.orderingLock.lock();
        try {
            ((GenericPeerGroup)this.group).getExecutor().execute(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            LoopbackMessenger.this.endpoint.processIncomingMessage(message, LoopbackMessenger.this.srcAddress, LoopbackMessenger.this.getDestAddressToUse(service, serviceParam));
                        }
                        catch (Throwable uncaught) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                            LOG.log(Level.WARNING, "Uncaught Throwable in Loopback Messenger ", uncaught);
                        }
                    }
                }
            });
            Object var6_5 = null;
            this.orderingLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.orderingLock.unlock();
            throw throwable;
        }
    }
}

