/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.cbjx;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.cbjx.CbJxTransport;
import net.jxta.logging.Logging;

public class CbJxMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger(CbJxMessenger.class.getName());
    private final EndpointAddress newDestAddr;
    private final Object acquireMessengerLock = new String("Messenger Acquire Lock");
    private Messenger outBoundMessenger = null;
    private final CbJxTransport transport;

    public CbJxMessenger(CbJxTransport transport, EndpointAddress dest, Object hintIgnored) throws IOException {
        this(transport, dest);
    }

    public CbJxMessenger(CbJxTransport transport, EndpointAddress dest) throws IOException {
        super(transport.group.getPeerGroupID(), dest, false);
        this.transport = transport;
        this.newDestAddr = new EndpointAddress("jxta", dest.getProtocolAddress(), "CbJxTransport", null);
        this.outBoundMessenger = transport.endpoint.getMessengerImmediate(this.newDestAddr, null);
        if (null == this.outBoundMessenger) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Could not get messenger for " + this.newDestAddr);
            }
            throw new IOException("Could not get messenger for " + this.newDestAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeImpl() {
        Object object = this.acquireMessengerLock;
        synchronized (object) {
            this.outBoundMessenger.close();
            this.outBoundMessenger = null;
        }
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.newDestAddr;
    }

    public boolean isIdleImpl() {
        return false;
    }

    public void sendMessageBImpl(Message msg, String service, String serviceParam) throws IOException {
        msg = msg.clone();
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Messenger: sending out " + msg + " to: " + destAddressToUse);
        }
        msg = this.transport.addCryptoInfo(msg, destAddressToUse);
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info(failure.toString());
            }
            throw failure;
        }
        this.sendTo(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendTo(Message msg) throws IOException {
        Object object = this.acquireMessengerLock;
        synchronized (object) {
            if (null == this.outBoundMessenger || this.outBoundMessenger.isClosed()) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Getting messenger for " + this.newDestAddr);
                }
                this.outBoundMessenger = this.transport.endpoint.getMessengerImmediate(this.newDestAddr, null);
                if (this.outBoundMessenger == null) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Could not get messenger for " + this.newDestAddr);
                    }
                    throw new IOException("Underlying messenger could not be repaired");
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + msg + " to endpoint " + this.newDestAddr);
        }
        this.outBoundMessenger.sendMessageB(msg, null, null);
    }
}

