/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.mcast;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessagePropagater;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.msgframing.MessagePackageHeader;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitor;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.logging.Logging;
import net.jxta.meter.MonitorResources;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.TransportAdvertisement;

public class McastTransport
implements Runnable,
Module,
MessagePropagater {
    private static final Logger LOG = Logger.getLogger(McastTransport.class.getName());
    public static final ModuleClassID MCAST_TRANSPORT_CLASSID = ModuleClassID.create(URI.create("urn:jxta:uuid-0C801F65D38F421C9884D706B337B81105"));
    public static final ModuleSpecID MCAST_TRANSPORT_SPECID = ModuleSpecID.create(URI.create("urn:jxta:uuid-0C801F65D38F421C9884D706B337B8110106"));
    private String protocolName = "mcast";
    private EndpointAddress ourSrcAddr = null;
    private MessageElement msgSrcAddrElement = null;
    private String interfaceAddressStr;
    private InetAddress usingInterface;
    private boolean isClosed = false;
    private String multicastAddress = "224.0.1.85";
    private InetAddress multicastInetAddress;
    private int multicastPort = 1234;
    private EndpointAddress publicAddress = new EndpointAddress(this.protocolName, this.multicastAddress + ":" + Integer.toString(this.multicastPort), null, null);
    private int multicastPacketSize = 16384;
    private MulticastSocket multicastSocket = null;
    private Thread multicastThread = null;
    private DatagramProcessor multicastProcessor;
    private PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private EndpointService endpoint = null;
    private TransportMeter multicastTransportMeter;
    private TransportBindingMeter multicastTransportBindingMeter;
    private transient boolean disabled = false;

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof McastTransport) {
            McastTransport likeMe = (McastTransport)target;
            return this.getProtocolName().equals(likeMe.getProtocolName()) && this.getPublicAddress().equals(likeMe.getPublicAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.getPublicAddress().hashCode();
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        Advertisement paramsAdv;
        block27: {
            Enumeration list;
            this.group = group;
            this.assignedID = assignedID;
            this.implAdvertisement = (ModuleImplAdvertisement)impl;
            ConfigParams configAdv = group.getConfigAdvertisement();
            XMLElement param = (XMLElement)((Object)this.implAdvertisement.getParam());
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                XMLElement pname = (XMLElement)list.nextElement();
                this.protocolName = pname.getTextValue();
            }
            if (null == (param = (XMLElement)((Object)configAdv.getServiceParam(PeerGroup.tcpProtoClassID)))) {
                throw new IllegalArgumentException(TransportAdvertisement.getAdvertisementType() + " could not be located.");
            }
            Enumeration tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (tcpChilds.hasMoreElements()) {
                param = (XMLElement)tcpChilds.nextElement();
                Attribute typeAttr = param.getAttribute("type");
                if (!TCPAdv.getAdvertisementType().equals(typeAttr.getValue())) {
                    throw new IllegalArgumentException("transport adv is not a " + TCPAdv.getAdvertisementType());
                }
                if (tcpChilds.hasMoreElements()) {
                    throw new IllegalArgumentException("Multiple transport advs detected for " + assignedID);
                }
            } else {
                throw new IllegalArgumentException(TransportAdvertisement.getAdvertisementType() + " could not be located.");
            }
            paramsAdv = null;
            try {
                paramsAdv = AdvertisementFactory.newAdvertisement(param);
            }
            catch (NoSuchElementException notThere) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block27;
                LOG.log(Level.FINE, "Could not find parameter document", notThere);
            }
        }
        if (!(paramsAdv instanceof TCPAdv)) {
            throw new IllegalArgumentException("Provided Advertisement was not a " + TCPAdv.getAdvertisementType());
        }
        TCPAdv adv = (TCPAdv)paramsAdv;
        if (!adv.getMulticastState()) {
            this.disabled = true;
            return;
        }
        this.interfaceAddressStr = adv.getInterfaceAddress();
        if (this.interfaceAddressStr != null) {
            try {
                this.usingInterface = InetAddress.getByName(this.interfaceAddressStr);
            }
            catch (UnknownHostException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Invalid address for local interface address, using default");
                }
                this.usingInterface = IPUtils.ANYADDRESS;
            }
        } else {
            this.usingInterface = IPUtils.ANYADDRESS;
        }
        if (this.usingInterface.equals(IPUtils.ANYADDRESS)) {
            boolean localOnly = true;
            Iterator<InetAddress> eachLocal = IPUtils.getAllLocalAddresses();
            while (eachLocal.hasNext()) {
                InetAddress anAddress = eachLocal.next();
                if (anAddress.isLoopbackAddress()) continue;
                localOnly = false;
                break;
            }
            if (localOnly) {
                this.usingInterface = IPUtils.LOOPBACK;
            }
        }
        this.ourSrcAddr = new EndpointAddress(group.getPeerID(), null, null);
        this.msgSrcAddrElement = new StringMessageElement("EndpointSourceAddress", this.ourSrcAddr.toString(), null);
        this.multicastAddress = adv.getMulticastAddr();
        this.multicastPort = adv.getMulticastPort();
        try {
            this.multicastInetAddress = InetAddress.getByName(this.multicastAddress);
        }
        catch (UnknownHostException notValid) {
            IllegalArgumentException failed = new IllegalArgumentException("Invalid or unknown host name :" + this.multicastAddress);
            failed.initCause(notValid);
            throw failed;
        }
        assert (this.multicastInetAddress.isMulticastAddress());
        this.publicAddress = new EndpointAddress(this.protocolName, this.multicastAddress + ":" + Integer.toString(this.multicastPort), null, null);
        this.multicastPacketSize = adv.getMulticastSize();
        try {
            this.multicastSocket = new MulticastSocket(new InetSocketAddress(this.usingInterface, this.multicastPort));
        }
        catch (IOException failed) {
            throw new PeerGroupException("Could not open multicast socket", failed);
        }
        try {
            this.multicastSocket.setLoopbackMode(false);
        }
        catch (SocketException ignored) {
            // empty catch block
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring IP Multicast Message Transport : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID: ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration:");
            configInfo.append("\n\t\tProtocol: ").append(this.protocolName);
            configInfo.append("\n\t\tInterface address: ").append(this.interfaceAddressStr == null ? "(unspecified)" : this.interfaceAddressStr);
            configInfo.append("\n\t\tMulticast Addr: ").append(this.multicastAddress);
            configInfo.append("\n\t\tMulticast Port: ").append(this.multicastPort);
            configInfo.append("\n\t\tMulticast Packet Size: ").append(this.multicastPacketSize);
            configInfo.append("\n\tBound To :");
            configInfo.append("\n\t\tUsing Interface: ").append(this.usingInterface.getHostAddress());
            configInfo.append("\n\t\tMulticast Server Bind Addr: ").append(this.multicastSocket.getLocalSocketAddress());
            configInfo.append("\n\t\tPublic Address: ").append(this.publicAddress);
            LOG.config(configInfo.toString());
        }
    }

    public synchronized int startApp(String[] arg) {
        MessengerEventListener messengerEventListener;
        TransportServiceMonitor transportServiceMonitor;
        if (this.disabled) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("IP Multicast Message Transport disabled.");
            }
            return -2147483548;
        }
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        this.isClosed = false;
        if (TransportMeterBuildSettings.TRANSPORT_METERING && (transportServiceMonitor = (TransportServiceMonitor)MonitorManager.getServiceMonitor(this.group, MonitorResources.transportServiceMonitorClassID)) != null) {
            this.multicastTransportMeter = transportServiceMonitor.createTransportMeter("Multicast", this.publicAddress);
            this.multicastTransportBindingMeter = this.getMulticastTransportBindingMeter(this.publicAddress);
            this.multicastTransportBindingMeter.connectionEstablished(true, 0L);
            this.multicastTransportBindingMeter.connectionEstablished(false, 0L);
        }
        if ((messengerEventListener = this.endpoint.addMessageTransport(this)) == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return -1;
        }
        this.multicastProcessor = new DatagramProcessor(((StdPeerGroup)this.group).getExecutor());
        this.multicastThread = new Thread(this.group.getHomeThreadGroup(), this, "IP Multicast Listener for " + this.publicAddress);
        this.multicastThread.setDaemon(true);
        this.multicastThread.start();
        try {
            this.multicastSocket.joinGroup(this.multicastInetAddress);
        }
        catch (IOException soe) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Could not join multicast group, setting Multicast off");
            }
            return -1;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("IP Multicast Message Transport started.");
        }
        return 0;
    }

    public synchronized void stopApp() {
        if (this.isClosed || this.disabled) {
            return;
        }
        this.isClosed = true;
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
        if (null != this.multicastProcessor) {
            this.multicastProcessor.stop();
            this.multicastProcessor = null;
        }
        this.endpoint.removeMessageTransport(this);
        if (TransportMeterBuildSettings.TRANSPORT_METERING && this.multicastTransportBindingMeter != null) {
            this.multicastTransportBindingMeter.connectionClosed(true, 0L);
            this.multicastTransportBindingMeter.connectionClosed(false, 0L);
        }
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public EndpointService getEndpointService() {
        return (EndpointService)this.endpoint.getInterface();
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (!this.isClosed) {
                    DatagramPacket packet;
                    block14: {
                        byte[] buffer = new byte[this.multicastPacketSize];
                        packet = new DatagramPacket(buffer, buffer.length);
                        this.multicastSocket.receive(packet);
                        if (!this.isClosed) break block14;
                        Object var5_8 = null;
                        this.multicastThread = null;
                        return;
                    }
                    try {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("multicast message received from :" + packet.getAddress().getHostAddress());
                        }
                        this.multicastProcessor.put(packet);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    catch (InterruptedIOException woken) {
                        Thread.interrupted();
                    }
                    catch (Exception e) {
                        if (this.isClosed) {
                            Object var5_9 = null;
                            this.multicastThread = null;
                            return;
                        }
                        if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE) || this.isClosed) break;
                        LOG.log(Level.SEVERE, "failure during multicast receive", e);
                        break;
                    }
                }
                Object var5_10 = null;
                this.multicastThread = null;
                return;
            }
            catch (Throwable all) {
                if (this.isClosed) {
                    Object var5_11 = null;
                    this.multicastThread = null;
                    return;
                }
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                Object var5_12 = null;
                this.multicastThread = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            this.multicastThread = null;
            throw throwable;
        }
    }

    public synchronized boolean propagate(Message message, String pName, String pParams, int initalTTL) {
        long sendStartTime = System.currentTimeMillis();
        int numBytesInPacket = 0;
        try {
            message.replaceMessageElement("jxta", this.msgSrcAddrElement);
            EndpointAddress destAddr = new EndpointAddress(this.publicAddress, pName, pParams);
            StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddr.toString(), null);
            message.replaceMessageElement("jxta", dstAddressElement);
            WireFormatMessage serialed = WireFormatMessageFactory.toWire(message, WireFormatMessageFactory.DEFAULT_WIRE_MIME, null);
            MessagePackageHeader header = new MessagePackageHeader();
            header.setContentTypeHeader(serialed.getMimeType());
            header.setContentLengthHeader(serialed.getByteLength());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.multicastPacketSize);
            buffer.write(74);
            buffer.write(88);
            buffer.write(84);
            buffer.write(65);
            header.sendToStream(buffer);
            serialed.sendToStream(buffer);
            buffer.flush();
            buffer.close();
            numBytesInPacket = buffer.size();
            if (buffer.size() > this.multicastPacketSize && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Multicast datagram exceeds multicast size.");
            }
            DatagramPacket packet = new DatagramPacket(buffer.toByteArray(), numBytesInPacket, this.multicastInetAddress, this.multicastPort);
            this.multicastSocket.send(packet);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sent Multicast message to :" + pName + "/" + pParams);
            }
            if (TransportMeterBuildSettings.TRANSPORT_METERING && this.multicastTransportBindingMeter != null) {
                this.multicastTransportBindingMeter.messageSent(true, message, System.currentTimeMillis() - sendStartTime, numBytesInPacket);
            }
            return true;
        }
        catch (IOException e) {
            if (TransportMeterBuildSettings.TRANSPORT_METERING && this.multicastTransportBindingMeter != null) {
                this.multicastTransportBindingMeter.sendFailure(true, message, System.currentTimeMillis() - sendStartTime, numBytesInPacket);
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Multicast socket send failed", e);
            }
            return false;
        }
    }

    void processMulticast(DatagramPacket packet) {
        block13: {
            int size = packet.getLength();
            byte[] buffer = packet.getData();
            long messageReceiveBeginTime = System.currentTimeMillis();
            try {
                if (size < 4) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("damaged multicast discarded");
                    }
                    throw new IOException("damaged multicast discarded : too short");
                }
                if (74 != buffer[0] || 88 != buffer[1] || 84 != buffer[2] || 65 != buffer[3]) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("damaged multicast discarded");
                    }
                    throw new IOException("damaged multicast discarded : incorrect signature");
                }
                MessagePackageHeader header = new MessagePackageHeader();
                ByteBuffer bbuffer = ByteBuffer.wrap(buffer, 4, size - 4);
                if (!header.readHeader(bbuffer)) {
                    throw new IOException("Failed to read framing header");
                }
                MimeMediaType msgMime = header.getContentTypeHeader();
                Message msg = WireFormatMessageFactory.fromBuffer(bbuffer, msgMime, null);
                MessageElement srcAddrElem = msg.getMessageElement("jxta", "EndpointSourceAddress");
                if (null == srcAddrElem) {
                    throw new IOException("No Source Address in " + msg);
                }
                msg.removeMessageElement(srcAddrElem);
                EndpointAddress srcAddr = new EndpointAddress(srcAddrElem.toString());
                if (srcAddr.equals(this.ourSrcAddr)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Discard loopback multicast message");
                    }
                    return;
                }
                MessageElement dstAddrElem = msg.getMessageElement("jxta", "EndpointDestinationAddress");
                if (null == dstAddrElem) {
                    throw new IOException("No Destination Address in " + msg);
                }
                msg.removeMessageElement(dstAddrElem);
                EndpointAddress dstAddr = new EndpointAddress(dstAddrElem.toString());
                this.endpoint.processIncomingMessage(msg, srcAddr, dstAddr);
                if (TransportMeterBuildSettings.TRANSPORT_METERING && this.multicastTransportBindingMeter != null) {
                    this.multicastTransportBindingMeter.messageReceived(false, msg, messageReceiveBeginTime - System.currentTimeMillis(), size);
                }
            }
            catch (Exception e) {
                if (TransportMeterBuildSettings.TRANSPORT_METERING && this.multicastTransportBindingMeter != null) {
                    this.multicastTransportBindingMeter.receiveFailure(false, messageReceiveBeginTime - System.currentTimeMillis(), size);
                }
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block13;
                LOG.log(Level.FINE, "Discard incoming multicast message", e);
            }
        }
    }

    TransportBindingMeter getMulticastTransportBindingMeter(EndpointAddress destinationAddress) {
        if (this.multicastTransportMeter != null) {
            return this.multicastTransportMeter.getTransportBindingMeter(this.group.getPeerID(), destinationAddress);
        }
        return null;
    }

    private class DatagramProcessor
    implements Runnable {
        private static final int MAX_SIMULTANEOUS_PROCESSING = 5;
        final Executor executor;
        final BlockingQueue<DatagramPacket> queue = new ArrayBlockingQueue<DatagramPacket>(6);
        int currentTasks = 0;
        volatile boolean stopped = false;

        DatagramProcessor(Executor executor) {
            this.executor = executor;
        }

        void stop() {
            this.queue.clear();
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(DatagramPacket packet) throws InterruptedException {
            boolean execute = false;
            if (this.stopped) {
                return;
            }
            if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Queuing incoming datagram packet : " + packet);
            }
            this.queue.put(packet);
            DatagramProcessor datagramProcessor = this;
            synchronized (datagramProcessor) {
                if (!this.stopped && this.currentTasks < 5) {
                    ++this.currentTasks;
                    execute = true;
                }
            }
            if (execute) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINER, "Starting new executor datagram processing task");
                }
                this.executor.execute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            DatagramProcessor datagramProcessor;
            try {
                try {
                    DatagramPacket packet;
                    while (!this.stopped && null != (packet = (DatagramPacket)this.queue.poll())) {
                        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Processing incoming datagram packet : " + packet);
                        }
                        McastTransport.this.processMulticast(packet);
                    }
                    Object var3_3 = null;
                    datagramProcessor = this;
                }
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable", all);
                    }
                    Object var3_4 = null;
                    DatagramProcessor datagramProcessor3 = this;
                    synchronized (datagramProcessor3) {
                        --this.currentTasks;
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                DatagramProcessor datagramProcessor2 = this;
                synchronized (datagramProcessor2) {
                    --this.currentTasks;
                    throw throwable;
                }
            }
            synchronized (datagramProcessor) {
                --this.currentTasks;
                return;
            }
        }
    }
}

