/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.io.IOException;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.relay.RelayTransport;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.util.SeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.URISeedingManager;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayClient
implements MessageReceiver,
Runnable {
    private static final transient Logger LOG = Logger.getLogger(RelayClient.class.getName());
    private static final long DEFAULT_EXPIRATION = 1200000L;
    private final PeerGroup group;
    private final String serviceName;
    private EndpointService endpoint;
    private final EndpointAddress publicAddress;
    private final String groupName;
    private final String peerId;
    private final int maxServers;
    private final long leaseLengthToRequest;
    private final long messengerPollInterval;
    private Thread thread = null;
    private volatile boolean closed = false;
    private final List activeRelayListeners = new ArrayList();
    private final Map<EndpointAddress, RouteAdvertisement> activeRelays = new Hashtable<EndpointAddress, RouteAdvertisement>();
    private final SeedingManager seedingManager;
    RelayServerConnection currentServer = null;

    public RelayClient(PeerGroup group, String serviceName, RelayConfigAdv relayConfig) {
        this.group = group;
        this.groupName = group.getPeerGroupID().getUniqueValue().toString();
        this.serviceName = serviceName;
        this.maxServers = -1 != relayConfig.getMaxRelays() ? relayConfig.getMaxRelays() : 1;
        this.leaseLengthToRequest = -1L != relayConfig.getClientLeaseDuration() ? relayConfig.getClientLeaseDuration() : 3600000L;
        this.messengerPollInterval = -1L != relayConfig.getMessengerPollInterval() ? relayConfig.getMessengerPollInterval() : 15000L;
        URISeedingManager uriSeedingManager = new URISeedingManager(relayConfig.getAclUri(), relayConfig.getUseOnlySeeds(), group, serviceName);
        for (EndpointAddress aSeeder : Arrays.asList(relayConfig.getSeedRelays())) {
            uriSeedingManager.addSeed(aSeeder.toURI());
        }
        for (URI aSeed : Arrays.asList(relayConfig.getSeedingURIs())) {
            uriSeedingManager.addSeedingURI(aSeed);
        }
        this.seedingManager = uriSeedingManager;
        this.peerId = group.getPeerID().getUniqueValue().toString();
        this.publicAddress = new EndpointAddress("relay", this.peerId, null, null);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Relay Client");
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : ").append(group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tService Name : ").append(serviceName);
            configInfo.append("\n\t\tPublic Address : ").append(this.publicAddress);
            configInfo.append("\n\t\tMax Relay Servers : ").append(this.maxServers);
            configInfo.append("\n\t\tMax Lease Length : ").append(this.leaseLengthToRequest).append("ms.");
            configInfo.append("\n\t\tMessenger Poll Interval : ").append(this.messengerPollInterval).append("ms.");
            LOG.config(configInfo.toString());
        }
    }

    public synchronized boolean startClient() {
        this.endpoint = this.group.getEndpointService();
        if (this.endpoint.addMessageTransport(this) == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return false;
        }
        this.thread = new Thread(this.group.getHomeThreadGroup(), this, "Relay Client Worker Thread for " + this.publicAddress);
        this.thread.setDaemon(true);
        this.thread.start();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Started client : " + this.publicAddress.toString());
        }
        return true;
    }

    public synchronized void stopClient() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.endpoint.removeMessageTransport(this);
        Thread tempThread = this.thread;
        this.thread = null;
        if (tempThread != null) {
            tempThread.interrupt();
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Stopped client : " + this.publicAddress.toString());
        }
    }

    @Override
    public Iterator<EndpointAddress> getPublicAddresses() {
        return Collections.singletonList(this.publicAddress).iterator();
    }

    @Override
    public String getProtocolName() {
        return "relay";
    }

    @Override
    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    @Override
    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Start relay client thread");
        }
        try {
            try {
                long nextConnectAttemptAt = 0L;
                RdvAdvertisement referral = null;
                ArrayList<RouteAdvertisement> allSeeds = null;
                long gotLastSeedsAt = 0L;
                while (!this.closed) {
                    if (null != referral) {
                        RouteAdvertisement relayRoute = referral.getRouteAdv();
                        relayRoute.setDestPeerID(referral.getPeerID());
                        referral = this.connectToRelay(new RelayServerConnection(this, relayRoute));
                        continue;
                    }
                    long untilNextConnectAttempt = TimeUtils.toRelativeTimeMillis(nextConnectAttemptAt);
                    if (untilNextConnectAttempt > 0L) {
                        try {
                            Thread.sleep(untilNextConnectAttempt);
                        }
                        catch (InterruptedException e) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, "Thread Interrupted ", e);
                            continue;
                        }
                    }
                    nextConnectAttemptAt = TimeUtils.toAbsoluteTimeMillis(30000L);
                    if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), gotLastSeedsAt) > 300000L || allSeeds.isEmpty()) {
                        allSeeds = new ArrayList<RouteAdvertisement>(Arrays.asList(this.seedingManager.getActiveSeedRoutes()));
                        gotLastSeedsAt = TimeUtils.timeNow();
                    }
                    while (null == referral && !allSeeds.isEmpty() && !this.closed) {
                        RouteAdvertisement aSeed = (RouteAdvertisement)allSeeds.remove(0);
                        if (null == aSeed.getDestPeerID()) {
                            Vector<String> seed_eas = aSeed.getDest().getVectorEndpointAddresses();
                            if (seed_eas.isEmpty()) continue;
                            EndpointAddress aSeedHost = new EndpointAddress(seed_eas.get(0));
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Attempting relay connect to : " + aSeedHost);
                            }
                            referral = this.connectToRelay(new RelayServerConnection(this, aSeedHost));
                            continue;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Attempting relay connect to : " + aSeed.getDestPeerID());
                        }
                        referral = this.connectToRelay(new RelayServerConnection(this, aSeed));
                    }
                }
                Object var13_12 = null;
                this.thread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("stop client thread");
                }
            }
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                }
                Object var13_13 = null;
                this.thread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("stop client thread");
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.thread = null;
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("stop client thread");
            }
            throw throwable;
        }
    }

    protected boolean isRelayConnectDone() {
        return this.thread == null || Thread.currentThread() != this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RdvAdvertisement connectToRelay(RelayServerConnection server) {
        long waitTimeout;
        long requestTimeoutAt;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Connecting to " + server);
        }
        RdvAdvertisement referral = null;
        this.currentServer = server;
        if (!server.createMessenger(this.leaseLengthToRequest)) {
            return referral;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("got messenger " + server);
        }
        if (server.logicalAddress != null && "jxta".equals(server.logicalAddress.getProtocolName())) {
            server.peerId = server.logicalAddress.getProtocolAddress();
        }
        if (server.peerId == null) {
            if (server.messenger != null) {
                server.sendDisconnectMessage();
                server.messenger.close();
            }
            return referral;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("got peerId " + server);
        }
        RelayClient relayClient = this;
        synchronized (relayClient) {
            requestTimeoutAt = TimeUtils.toAbsoluteTimeMillis(5000L);
            while (this.currentServer != null && this.currentServer.leaseLength == 0L && !this.isRelayConnectDone() && (waitTimeout = requestTimeoutAt - System.currentTimeMillis()) > 0L) {
                block29: {
                    try {
                        this.wait(waitTimeout);
                    }
                    catch (InterruptedException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block29;
                        LOG.log(Level.FINE, "wait got interrupted early ", e);
                    }
                }
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("wait done");
            }
        }
        if (this.currentServer == null) {
            return server.alternateRelayAdv;
        }
        if (this.isRelayConnectDone()) {
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer = null;
            return server.alternateRelayAdv;
        }
        if (this.currentServer.leaseLength == 0L) {
            this.currentServer.sendConnectMessage(this.leaseLengthToRequest);
            relayClient = this;
            synchronized (relayClient) {
                requestTimeoutAt = TimeUtils.toAbsoluteTimeMillis(15000L);
                while (this.currentServer != null && this.currentServer.leaseLength == 0L && !this.isRelayConnectDone() && (waitTimeout = requestTimeoutAt - System.currentTimeMillis()) > 0L) {
                    block30: {
                        try {
                            this.wait(waitTimeout);
                        }
                        catch (InterruptedException e) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block30;
                            LOG.log(Level.FINE, "wait got interrupted early ", e);
                        }
                    }
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("wait done");
                }
            }
        }
        if (this.currentServer == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("did not get connect from " + server);
            }
            return server.alternateRelayAdv;
        }
        if (this.currentServer.relayAdv == null || this.currentServer.leaseLength == 0L || this.isRelayConnectDone()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("did not get connect from " + server);
            }
            if (this.currentServer.messenger != null) {
                this.currentServer.sendDisconnectMessage();
                this.currentServer.messenger.close();
            }
            this.currentServer = null;
            return server.alternateRelayAdv;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Connected to " + server);
        }
        RouteAdvertisement holdAdv = server.relayAdv;
        EndpointAddress holdDest = server.logicalAddress;
        this.addActiveRelay(holdDest, holdAdv);
        referral = this.maintainRelayConnection(server);
        this.removeActiveRelay(holdDest, holdAdv);
        return referral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RdvAdvertisement maintainRelayConnection(RelayServerConnection server) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("maintainRelayConnection() start " + this.currentServer);
        }
        if (server == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("RelayConnection() failed at start " + this.currentServer);
            }
            return null;
        }
        RelayClient relayClient = this;
        synchronized (relayClient) {
            long currentTime = System.currentTimeMillis();
            long renewLeaseAt = this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L;
            long waitTimeout = 0L;
            boolean earlyRenew = this.currentServer.seeded;
            while (this.currentServer != null && !this.isRelayConnectDone()) {
                waitTimeout = renewLeaseAt - currentTime;
                if (waitTimeout > this.messengerPollInterval || waitTimeout <= 0L) {
                    waitTimeout = this.messengerPollInterval;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("waitTimeout=" + waitTimeout + " server=" + this.currentServer);
                }
                try {
                    this.wait(waitTimeout);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("wait done, server=" + this.currentServer);
                }
                if (this.currentServer == null) break;
                currentTime = System.currentTimeMillis();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("check messenger " + this.currentServer);
                }
                if (this.currentServer.messenger.isClosed()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Server connection broken");
                    }
                    if (!this.currentServer.createMessenger(this.currentServer.leaseLength)) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Server connection NOT re-established");
                        }
                        this.currentServer = null;
                        break;
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Server connection re-established");
                    }
                    if (!this.isRelayConnectDone()) continue;
                }
                if (this.isRelayConnectDone()) break;
                renewLeaseAt = this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L;
                if (currentTime < renewLeaseAt && !earlyRenew) continue;
                earlyRenew = false;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("renew lease " + this.currentServer);
                }
                if (currentTime <= this.currentServer.leaseObtainedAt + this.currentServer.leaseLength / 3L + 240000L && this.currentServer.sendConnectMessage(this.leaseLengthToRequest)) continue;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("renew lease failed" + this.currentServer);
                }
                if (this.currentServer.messenger != null) {
                    this.currentServer.messenger.close();
                }
                this.currentServer.messenger = null;
                this.currentServer.peerId = null;
                this.currentServer.leaseLength = 0L;
                this.currentServer.leaseObtainedAt = 0L;
                this.currentServer.relayAdv = null;
                this.currentServer = null;
                break;
            }
        }
        if (this.isRelayConnectDone() && this.currentServer != null) {
            this.currentServer.sendDisconnectMessage();
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer.messenger = null;
            this.currentServer.peerId = null;
            this.currentServer.leaseLength = 0L;
            this.currentServer.leaseObtainedAt = 0L;
            this.currentServer.relayAdv = null;
            this.currentServer.alternateRelayAdv = null;
            this.currentServer = null;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("maintainRelayConnection() terminated " + this.currentServer);
        }
        return server.alternateRelayAdv;
    }

    protected synchronized void handleResponse(Message message, EndpointAddress dstAddr) {
        String serverPeerId;
        RdvAdvertisement relayAdv;
        String response;
        block25: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("handleResponse " + this.currentServer);
            }
            if (this.currentServer == null) {
                return;
            }
            response = RelayTransport.getString(message, "response");
            if (response == null) {
                return;
            }
            response = response.toLowerCase();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("response = " + response);
            }
            relayAdv = null;
            MessageElement advElement = message.getMessageElement("relay", "relayAdv");
            if (null != advElement) {
                try {
                    XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(advElement);
                    Advertisement adv = AdvertisementFactory.newAdvertisement(asDoc);
                    if (adv instanceof RdvAdvertisement) {
                        relayAdv = (RdvAdvertisement)adv;
                    }
                }
                catch (IOException e) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block25;
                    LOG.log(Level.FINE, "Could not read Relay RdvAdvertisement", e);
                }
            }
        }
        if ((serverPeerId = dstAddr.getServiceParameter()) == null) {
            return;
        }
        if (!serverPeerId.equals(this.currentServer.peerId)) {
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("serverPeerId = " + serverPeerId);
        }
        if ("connected".equals(response)) {
            long responseLease;
            block26: {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("connected response for " + this.currentServer);
                }
                String responseLeaseString = RelayTransport.getString(message, "lease");
                responseLease = 0L;
                if (responseLeaseString != null) {
                    try {
                        responseLease = Long.parseLong(responseLeaseString);
                    }
                    catch (NumberFormatException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block26;
                        LOG.log(Level.WARNING, "could not parse response lease string", e);
                    }
                }
            }
            if (responseLease <= 0L) {
                return;
            }
            this.currentServer.leaseLength = responseLease;
            this.currentServer.leaseObtainedAt = System.currentTimeMillis();
            this.currentServer.flushNeeded = false;
            if (relayAdv != null) {
                PeerID pidOfAdv = relayAdv.getPeerID();
                String pidOfAdvUnique = pidOfAdv.getUniqueValue().toString();
                if (this.currentServer.peerId.equals(pidOfAdvUnique)) {
                    this.currentServer.relayAdv = relayAdv.getRouteAdv();
                    this.currentServer.relayAdv.setDestPeerID(pidOfAdv);
                } else {
                    this.currentServer.alternateRelayAdv = relayAdv;
                }
            }
            this.notifyAll();
        } else if ("disconnected".equals(response)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("disconnected from " + this.currentServer);
            }
            this.currentServer.alternateRelayAdv = relayAdv;
            if (this.currentServer.messenger != null) {
                this.currentServer.messenger.close();
            }
            this.currentServer.messenger = null;
            this.currentServer.peerId = null;
            this.currentServer.leaseLength = 0L;
            this.currentServer.leaseObtainedAt = 0L;
            this.currentServer.relayAdv = null;
            this.currentServer = null;
            this.notifyAll();
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("response handled for " + this.currentServer);
        }
    }

    public synchronized boolean addActiveRelayListener(Object service) {
        boolean added = false;
        if (!this.activeRelayListeners.contains(service)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Register group to relay connection " + ((PeerGroup)service).getPeerGroupName());
            }
            this.activeRelayListeners.add(service);
            added = true;
        }
        return added;
    }

    public synchronized boolean removeActiveRelayListener(Object service) {
        this.activeRelayListeners.remove(service);
        return true;
    }

    public synchronized boolean addActiveRelay(EndpointAddress address, RouteAdvertisement relayRoute) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("notify add relay connection for " + address);
        }
        for (Object activeRelayListener : this.activeRelayListeners) {
            PeerGroup pg = (PeerGroup)activeRelayListener;
            this.addRelay(pg, relayRoute);
        }
        this.activeRelays.put(address, relayRoute);
        return true;
    }

    public synchronized boolean removeActiveRelay(EndpointAddress address, RouteAdvertisement relayRoute) {
        for (Object activeRelayListener : this.activeRelayListeners) {
            PeerGroup pg = (PeerGroup)activeRelayListener;
            this.removeRelay(pg, relayRoute);
        }
        this.activeRelays.remove(address);
        return true;
    }

    private void addRelay(PeerGroup pg, RouteAdvertisement relayRoute) {
        block10: {
            ModuleClassID assignedID = PeerGroup.endpointClassID;
            try {
                RouteAdvertisement route;
                PeerAdvertisement padv = pg.getPeerAdvertisement();
                XMLDocument myParam = (XMLDocument)padv.getServiceParam(assignedID);
                if (myParam == null) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("no route found in peer adv");
                    }
                    return;
                }
                Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                XMLElement param = null;
                if (paramChilds.hasMoreElements()) {
                    param = (XMLElement)paramChilds.nextElement();
                }
                if ((route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param)) == null) {
                    return;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("found route info for local peer \n" + route.display());
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("OLD route info to local peer \n" + route.display());
                }
                route.removeHop(relayRoute.getDestPeerID());
                Vector<AccessPointAdvertisement> hops = route.getVectorHops();
                hops.add(relayRoute.getDest());
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("NEW route info to local peer" + route.display());
                }
                myParam = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(assignedID, myParam);
                DiscoveryService discovery = pg.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block10;
                LOG.log(Level.FINE, "exception adding relay route ", ex);
            }
        }
    }

    private void removeRelay(PeerGroup group, RouteAdvertisement relayRoute) {
        block9: {
            ModuleClassID assignedID = PeerGroup.endpointClassID;
            PeerID relayPid = relayRoute.getDestPeerID();
            try {
                PeerAdvertisement padv = group.getPeerAdvertisement();
                XMLDocument myParam = (XMLDocument)padv.getServiceParam(assignedID);
                RouteAdvertisement route = null;
                if (myParam == null) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("no route found in peer adv");
                        return;
                    }
                } else {
                    Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                    XMLElement param = null;
                    if (paramChilds.hasMoreElements()) {
                        param = (XMLElement)paramChilds.nextElement();
                    }
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
                }
                if (route == null) {
                    return;
                }
                route.removeHop(relayPid);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("new route info to the peer" + route.display());
                }
                myParam = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                XMLDocument xptDoc = (XMLDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(assignedID, myParam);
                DiscoveryService discovery = group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Throwable theMatter) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                LOG.log(Level.WARNING, "Failed adding relay route", theMatter);
            }
        }
    }

    public Vector<AccessPointAdvertisement> getActiveRelays(PeerGroup pg) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("get active Relays list");
        }
        Vector<AccessPointAdvertisement> hops = new Vector<AccessPointAdvertisement>();
        for (RouteAdvertisement route : this.activeRelays.values()) {
            block5: {
                try {
                    DiscoveryService discovery;
                    if (pg == null || (discovery = pg.getDiscoveryService()) == null) break block5;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("publishing route to active relay " + route.display());
                    }
                    discovery.publish(route, 1200000L, 1200000L);
                }
                catch (Exception ex) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "error publishing active relay", ex);
                    continue;
                }
            }
            hops.add(route.getDest());
        }
        return hops;
    }

    private static PeerID addr2pid(EndpointAddress addr) {
        try {
            URI asURI = new URI("urn", "jxta:" + addr.getProtocolAddress(), null);
            return (PeerID)IDFactory.fromURI(asURI);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static class RelayServerConnection {
        final RelayClient client;
        Messenger messenger = null;
        EndpointAddress logicalAddress = null;
        String peerId = null;
        long leaseLength = 0L;
        long leaseObtainedAt = 0L;
        public RouteAdvertisement relayAdv = null;
        EndpointAddress relayAddress = null;
        RdvAdvertisement alternateRelayAdv = null;
        boolean seeded = false;
        boolean flushNeeded = true;

        protected RelayServerConnection(RelayClient client, EndpointAddress addr) {
            this.client = client;
            this.relayAddress = new EndpointAddress(addr, null, null);
            this.seeded = true;
        }

        protected RelayServerConnection(RelayClient client, RouteAdvertisement relayAdv) {
            this.client = client;
            this.relayAdv = relayAdv;
        }

        protected boolean createMessenger(long leaseLengthToRequest) {
            if (this.messenger != null) {
                this.messenger.close();
                this.messenger = null;
            }
            AbstractList endpointAddresses = null;
            if (this.relayAdv != null) {
                AccessPointAdvertisement accessPointAdv = this.relayAdv.getDest();
                if (accessPointAdv != null) {
                    endpointAddresses = accessPointAdv.getVectorEndpointAddresses();
                }
            } else {
                endpointAddresses = new ArrayList<String>(1);
                endpointAddresses.add(this.relayAddress.toString());
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("createMessenger to " + endpointAddresses);
            }
            if (endpointAddresses == null) {
                return false;
            }
            for (String s : endpointAddresses) {
                if (s == null) continue;
                EndpointAddress addr = new EndpointAddress(s);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("find transport for " + addr);
                }
                Iterator<MessageTransport> transports = this.client.endpoint.getAllMessageTransports();
                while (transports.hasNext() && this.messenger == null) {
                    MessageTransport transport = transports.next();
                    if (!(transport instanceof MessageSender) || !((MessageSender)transport).allowsRouting()) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("try transport " + transport);
                    }
                    if (!addr.getProtocolName().equals(transport.getProtocolName())) continue;
                    String reqStr = RelayTransport.createConnectString(leaseLengthToRequest, this.relayAdv == null, false);
                    EndpointAddress addrToUse = new EndpointAddress(addr, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + reqStr);
                    this.messenger = ((MessageSender)transport).getMessenger(addrToUse, null);
                    if (this.messenger != null && this.messenger.isClosed()) {
                        this.messenger = null;
                    }
                    if (this.messenger == null) continue;
                    this.logicalAddress = this.messenger.getLogicalDestinationAddress();
                    if (this.relayAdv != null && !RelayClient.addr2pid(this.logicalAddress).equals(this.relayAdv.getDestPeerID())) {
                        this.messenger.close();
                        this.messenger = null;
                        this.logicalAddress = null;
                    }
                    this.relayAddress = addr;
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("messenger=" + this.messenger);
            }
            return this.messenger != null;
        }

        protected boolean sendConnectMessage(long leaseLengthToRequest) {
            if (this.messenger == null || this.messenger.isClosed()) {
                return false;
            }
            Message message = RelayTransport.createConnectMessage(leaseLengthToRequest, this.relayAdv == null, this.flushNeeded);
            try {
                this.messenger.sendMessage(message, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + this.client.peerId);
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "could not send connect message", e);
                }
                return false;
            }
            return true;
        }

        protected boolean sendDisconnectMessage() {
            if (this.messenger == null || this.messenger.isClosed()) {
                return false;
            }
            Message message = RelayTransport.createDisconnectMessage();
            try {
                this.messenger.sendMessage(message, "EndpointService:" + this.client.groupName, this.client.serviceName + "/" + this.client.peerId);
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "could not send disconnect message", e);
                }
                return false;
            }
            return true;
        }

        public String toString() {
            return (this.relayAddress == null ? "(adv to " + this.relayAdv.getDestPeerID() + ")" : this.relayAddress.toString()) + " [" + this.leaseLength + ", " + this.leaseObtainedAt + "] ";
        }
    }
}

