/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroupID;

final class HttpServletMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger(HttpServletMessenger.class.getName());
    private static final int SEND_IDLE = 0;
    private static final int SEND_INPROGRESS = 1;
    private static final int SEND_SUCCESS = 2;
    private static final int SEND_FAIL = 3;
    private static final int SEND_TOOLONG = 4;
    private static final long MAX_SENDING_BLOCK = 120000L;
    private static final long MAX_SENDING_WAIT = 3000L;
    private static final EndpointAddress nullEndpointAddr = new EndpointAddress("http", "0.0.0.0:0", null, null);
    private static final Timer closeMessengerTimer = new Timer("HttpServletMessenger Expiration timer", true);
    private final EndpointAddress logicalAddress;
    private final MessageElement srcAddressElement;
    private ScheduledExipry expirationTask;
    private Message outgoingMessage = null;
    private int sendResult = 0;
    private long sendingSince = 0L;

    HttpServletMessenger(PeerGroupID peerGroupID, EndpointAddress srcAddress, EndpointAddress logicalAddress, long validFor) {
        super(peerGroupID, nullEndpointAddr, false);
        this.logicalAddress = logicalAddress;
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddress.toString(), null);
        if (0L != validFor && validFor < Long.MAX_VALUE) {
            this.expirationTask = new ScheduledExipry(this);
            closeMessengerTimer.schedule((TimerTask)this.expirationTask, validFor);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("HttpServletMessenger\n\t" + this.toString());
        }
    }

    public synchronized void closeImpl() {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("close\n\t" + this.toString());
        }
        ScheduledExipry cancelExpire = this.expirationTask;
        this.expirationTask = null;
        if (null != cancelExpire) {
            cancelExpire.cancel();
        }
        super.close();
        this.notifyAll();
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.logicalAddress;
    }

    public boolean isIdleImpl() {
        return false;
    }

    public synchronized void sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Send " + message + " to " + this.dstAddress.toString() + "\n\t" + this.toString());
        }
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, failure.getMessage(), failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), null);
        message.replaceMessageElement("jxta", dstAddressElement);
        if (!this.doSend(message)) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "sendMessage failed (messenger closed).\n\t" + this.toString(), failure);
            }
            throw failure;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("sendMessage successful for " + message + "\n\t" + this.toString());
        }
    }

    private boolean doSend(Message message) {
        boolean result;
        long waitfor;
        if (this.isClosed()) {
            return false;
        }
        long now = TimeUtils.timeNow();
        if (this.sendResult != 0) {
            if (this.sendResult == 4 && now > this.sendingSince + 120000L) {
                this.close();
            }
            return true;
        }
        this.outgoingMessage = message;
        this.sendResult = 1;
        this.sendingSince = now;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Queued " + message);
        }
        this.notifyAll();
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(3000L);
        while (!this.isClosed() && this.sendResult == 1 && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
            try {
                this.wait(waitfor);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "InterruptedException timeout = 3000\n\t" + this.toString(), e);
                break;
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Got result\n\t" + this.toString());
        }
        if (this.isClosed() && 1 == this.sendResult) {
            return false;
        }
        boolean bl = result = this.sendResult != 3;
        if (this.sendResult == 1) {
            this.sendResult = 4;
            this.outgoingMessage = null;
        } else {
            this.sendResult = 0;
        }
        this.notifyAll();
        return result;
    }

    protected synchronized Message waitForMessage(long timeout) throws InterruptedException {
        long waitfor;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Waiting (" + (0L == timeout ? "forever" : Long.toString(timeout)) + ") for message\n\t" + this.toString());
        }
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        while (!this.isClosed() && null == this.outgoingMessage && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
            this.wait(waitfor);
        }
        Message result = this.outgoingMessage;
        this.outgoingMessage = null;
        if (!this.isClosed() && result == null) {
            this.sendResult = 0;
            this.notifyAll();
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning " + result + "\n\t" + this.toString());
        }
        return result;
    }

    protected synchronized void messageSent(boolean wasSuccessful) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("messageSent(" + wasSuccessful + ")\n\t" + this.toString());
        }
        this.sendResult = 4 == this.sendResult ? 0 : (wasSuccessful ? 2 : 3);
        this.notifyAll();
    }

    public String toString() {
        return "[" + super.toString() + "] isClosed=" + this.isClosed() + " sendResult=" + this.sendResult + " outmsg=" + this.outgoingMessage;
    }

    private static class ScheduledExipry
    extends TimerTask {
        HttpServletMessenger messenger;

        ScheduledExipry(HttpServletMessenger toExpire) {
            this.messenger = toExpire;
        }

        public boolean cancel() {
            this.messenger = null;
            boolean result = super.cancel();
            closeMessengerTimer.purge();
            return result;
        }

        public void run() {
            block3: {
                try {
                    HttpServletMessenger temp = this.messenger;
                    this.messenger = null;
                    if (null != temp) {
                        temp.close();
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block3;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in timer task :" + Thread.currentThread().getName(), all);
                }
            }
        }
    }
}

