/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.servlethttp.HttpMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpMessageSender;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitor;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.logging.Logging;
import net.jxta.meter.MonitorResources;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.TransportAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletHttpTransport
implements Module {
    private static final transient Logger LOG = Logger.getLogger(ServletHttpTransport.class.getName());
    private static final String DEFAULT_HTTP_PROTOCOL_NAME = "http";
    String HTTP_PROTOCOL_NAME = "http";
    PeerGroup group;
    ID assignedID;
    ModuleImplAdvertisement implAdvertisement;
    Executor executor;
    private EndpointService endpoint = null;
    private boolean configClient = false;
    private boolean configServer = false;
    private HttpMessageSender sender = null;
    private HttpMessageReceiver receiver = null;
    private TransportMeter transportMeter;
    private TransportBindingMeter unknownTransportBindingMeter;
    InetAddress usingInterface = null;
    int usingPort = 0;
    private List<EndpointAddress> publicAddresses = null;
    private EndpointAddress publicAddress;

    @Override
    public synchronized void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        ConfigParams peerAdv;
        Enumeration httpChilds;
        XMLElement pname;
        String configProtoName;
        Enumeration list;
        this.group = group;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.executor = ((StdPeerGroup)group).getExecutor();
        XMLElement param = (XMLElement)((Object)this.implAdvertisement.getParam());
        if (param != null && (list = param.getChildren("Proto")).hasMoreElements() && null != (configProtoName = (pname = (XMLElement)list.nextElement()).getTextValue())) {
            this.HTTP_PROTOCOL_NAME = configProtoName.trim();
        }
        if ((httpChilds = (param = (XMLElement)((Object)(peerAdv = group.getConfigAdvertisement()).getServiceParam(assignedID))).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
            param = (XMLElement)httpChilds.nextElement();
            Attribute typeAttr = param.getAttribute("type");
            if (!HTTPAdv.getAdvertisementType().equals(typeAttr.getValue())) {
                throw new IllegalArgumentException("Transport adv is not an http adv");
            }
            if (httpChilds.hasMoreElements()) {
                throw new IllegalArgumentException("Configuration contained multiple http advertisements");
            }
        } else {
            throw new IllegalArgumentException("Configuration did not contain http advertisement");
        }
        Advertisement paramsAdv = AdvertisementFactory.newAdvertisement(param);
        if (!(paramsAdv instanceof HTTPAdv)) {
            throw new IllegalArgumentException("Provided advertisement was not a " + HTTPAdv.getAdvertisementType());
        }
        HTTPAdv httpAdv = (HTTPAdv)paramsAdv;
        String interfaceAddressStr = httpAdv.getInterfaceAddress();
        boolean publicAddressOnly = httpAdv.getPublicAddressOnly();
        if (interfaceAddressStr != null) {
            try {
                this.usingInterface = InetAddress.getByName(interfaceAddressStr);
            }
            catch (UnknownHostException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Invalid address for local interface address, using default");
                }
                this.usingInterface = IPUtils.ANYADDRESS;
            }
        } else {
            this.usingInterface = IPUtils.ANYADDRESS;
        }
        this.usingPort = httpAdv.getPort();
        this.configClient = httpAdv.isClientEnabled();
        this.configServer = httpAdv.isServerEnabled();
        this.publicAddresses = this.getPublicAddresses(this.configServer, httpAdv.getServer(), this.usingInterface, this.usingPort, publicAddressOnly);
        if (!this.configClient && !this.configServer) {
            throw new IllegalArgumentException("Neither incoming nor outgoing connections configured.");
        }
        this.publicAddress = this.publicAddresses.get(0);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring HTTP Message Transport : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation:");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description: ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI: ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code: ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: ").append(group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: ").append(group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tProtocol: ").append(httpAdv.getProtocol());
            configInfo.append("\n\t\tClient Enabled: ").append(this.configClient);
            configInfo.append("\n\t\tServer Enabled: ").append(this.configServer);
            configInfo.append("\n\t\tPublic address: ").append(httpAdv.getServer() == null ? "(unspecified)" : httpAdv.getServer());
            configInfo.append("\n\t\tInterface address: ").append(interfaceAddressStr == null ? "(unspecified)" : interfaceAddressStr);
            configInfo.append("\n\t\tUnicast Server Bind Addr: ").append(IPUtils.getHostAddress(this.usingInterface)).append(":").append(this.usingPort);
            configInfo.append("\n\t\tPublic Addresses: ");
            configInfo.append("\n\t\t\tDefault Endpoint Addr : ").append(this.publicAddress);
            for (EndpointAddress anAddr : this.publicAddresses) {
                configInfo.append("\n\t\t\tEndpoint Addr : ").append(anAddr);
            }
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public synchronized int startApp(String[] args) {
        TransportServiceMonitor transportServiceMonitor;
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        if (TransportMeterBuildSettings.TRANSPORT_METERING && (transportServiceMonitor = (TransportServiceMonitor)MonitorManager.getServiceMonitor(this.group, MonitorResources.transportServiceMonitorClassID)) != null) {
            this.transportMeter = transportServiceMonitor.createTransportMeter("HTTP", this.publicAddress);
            this.unknownTransportBindingMeter = this.transportMeter.getTransportBindingMeter(TransportMeter.UNKNOWN_PEER, TransportMeter.UNKNOWN_ADDRESS);
        }
        if (this.configServer) {
            try {
                this.receiver = new HttpMessageReceiver(this, this.publicAddresses, this.usingInterface, this.usingPort);
                this.receiver.start();
            }
            catch (PeerGroupException e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Could not start http message receiver", e);
                }
                return -1;
            }
        }
        if (this.configClient) {
            try {
                this.sender = new HttpMessageSender(this, new EndpointAddress("jxta", this.group.getPeerID().getUniqueValue().toString(), null, null));
                this.sender.start();
            }
            catch (PeerGroupException e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Could not start http message sender", e);
                }
                return -1;
            }
        }
        return 0;
    }

    @Override
    public synchronized void stopApp() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        this.endpoint = null;
    }

    EndpointService getEndpointService() {
        return this.endpoint;
    }

    private List<EndpointAddress> getPublicAddresses(boolean serverEnabled, String serverName, InetAddress usingInterface, int serverSocketPort, boolean publicAddressOnly) {
        ArrayList<EndpointAddress> publicAddresses = new ArrayList<EndpointAddress>();
        if (serverEnabled && serverName != null) {
            EndpointAddress newAddr = new EndpointAddress(this.HTTP_PROTOCOL_NAME, serverName, null, null);
            publicAddresses.add(newAddr);
            if (publicAddressOnly) {
                return publicAddresses;
            }
        }
        if (usingInterface.equals(IPUtils.ANYADDRESS)) {
            Iterator<InetAddress> eachLocal = IPUtils.getAllLocalAddresses();
            ArrayList<EndpointAddress> wildAddrs = new ArrayList<EndpointAddress>();
            while (eachLocal.hasNext()) {
                InetAddress anAddress = eachLocal.next();
                String hostAddress = IPUtils.getHostAddress(anAddress);
                EndpointAddress newAddr = new EndpointAddress(this.HTTP_PROTOCOL_NAME, hostAddress + ":" + Integer.toString(serverSocketPort), null, null);
                if (publicAddresses.contains(newAddr)) continue;
                wildAddrs.add(newAddr);
            }
            Collections.sort(wildAddrs, new Comparator<EndpointAddress>(){

                @Override
                public int compare(EndpointAddress one, EndpointAddress two) {
                    return one.toString().compareTo(two.toString());
                }

                @Override
                public boolean equals(Object that) {
                    return this == that;
                }
            });
            publicAddresses.addAll(wildAddrs);
        } else {
            String hostAddress = IPUtils.getHostAddress(usingInterface);
            EndpointAddress newAddr = new EndpointAddress(this.HTTP_PROTOCOL_NAME, hostAddress + ":" + Integer.toString(serverSocketPort), null, null);
            if (!publicAddresses.contains(newAddr)) {
                publicAddresses.add(newAddr);
            }
        }
        return publicAddresses;
    }

    TransportBindingMeter getTransportBindingMeter(String peerIDString, EndpointAddress destinationAddress) {
        if (this.transportMeter != null) {
            return this.transportMeter.getTransportBindingMeter(peerIDString != null ? peerIDString : TransportMeter.UNKNOWN_PEER, destinationAddress);
        }
        return null;
    }

    TransportBindingMeter getUnknownTransportBindingMeter() {
        return this.unknownTransportBindingMeter;
    }
}

