/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tcp.IncomingUnicastServer;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeter;
import net.jxta.impl.endpoint.transportMeter.TransportMeterBuildSettings;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitor;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.logging.Logging;
import net.jxta.meter.MonitorResources;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.TransportAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpTransport
implements Module,
MessageSender,
MessageReceiver {
    private static final Logger LOG = Logger.getLogger(TcpTransport.class.getName());
    static final int SendBufferSize = 65536;
    static final int RecvBufferSize = 65536;
    static final int LingerDelay = 120;
    static int connectionTimeOut = 10000;
    static final int MaxAcceptCnxBacklog = 50;
    private String serverName;
    private final List<EndpointAddress> publicAddresses;
    private EndpointAddress publicAddress;
    private String interfaceAddressStr;
    InetAddress usingInterface;
    private int serverSocketPort;
    private int restrictionPort;
    private IncomingUnicastServer unicastServer;
    private boolean isClosed;
    private long messagesSent;
    private long messagesReceived;
    private long bytesSent;
    private long bytesReceived;
    private long connectionsAccepted;
    PeerGroup group;
    EndpointService endpoint;
    Executor executor;
    private String protocolName;
    private TransportMeter unicastTransportMeter;
    private TransportMeter multicastTransportMeter;
    private boolean publicAddressOnly;
    private MessengerEventListener messengerEventListener;
    private Thread messengerSelectorThread;
    Selector messengerSelector;
    private final Map<TcpMessenger, SocketChannel> regisMap;
    private final Set<SocketChannel> unregisMap;
    ThreadGroup myThreadGroup;
    protected static final int MAX_WRITE_SELECTORS = 50;
    private static final Stack<Selector> writeSelectorCache = new Stack();
    private int extraWriteSelectors;

    public TcpTransport() {
        block7: {
            block6: {
                this.serverName = null;
                this.publicAddresses = new ArrayList<EndpointAddress>();
                this.publicAddress = null;
                this.restrictionPort = -1;
                this.unicastServer = null;
                this.isClosed = false;
                this.messagesSent = 0L;
                this.messagesReceived = 0L;
                this.bytesSent = 0L;
                this.bytesReceived = 0L;
                this.connectionsAccepted = 0L;
                this.group = null;
                this.endpoint = null;
                this.protocolName = "tcp";
                this.publicAddressOnly = false;
                this.messengerEventListener = null;
                this.messengerSelector = null;
                this.regisMap = new ConcurrentHashMap<TcpMessenger, SocketChannel>();
                this.unregisMap = Collections.synchronizedSet(new HashSet());
                this.myThreadGroup = null;
                this.extraWriteSelectors = 0;
                try {
                    for (int i = 0; i < 50; ++i) {
                        writeSelectorCache.add(Selector.open());
                    }
                }
                catch (IOException ex) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block6;
                    LOG.severe("Failed adding selector to  write selector pool");
                }
            }
            try {
                String connectTOStr = System.getProperty("sun.net.client.defaultConnectTimeout");
                if (connectTOStr != null) {
                    connectionTimeOut = Integer.parseInt(connectTOStr);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.warning("Could not parse system property: sun.net.client.defaultConnectTimeout");
            }
        }
    }

    public long getConnectionsAccepted() {
        return this.connectionsAccepted;
    }

    public void incrementConnectionsAccepted() {
        ++this.connectionsAccepted;
    }

    public void incrementMessagesSent() {
        ++this.messagesSent;
    }

    public void incrementMessagesReceived() {
        ++this.messagesReceived;
    }

    public void incrementBytesSent(long bytes) {
        this.bytesSent += bytes;
    }

    public void incrementBytesReceived(long bytes) {
        this.bytesReceived += bytes;
    }

    public long getMessagesSent() {
        return this.messagesSent;
    }

    public long getMessagesReceived() {
        return this.messagesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TcpTransport) {
            TcpTransport likeMe = (TcpTransport)target;
            if (!this.getProtocolName().equals(likeMe.getProtocolName())) {
                return false;
            }
            Iterator<EndpointAddress> itsAddrs = likeMe.publicAddresses.iterator();
            for (EndpointAddress publicAddress1 : this.publicAddresses) {
                if (!itsAddrs.hasNext()) {
                    return false;
                }
                EndpointAddress mine = publicAddress1;
                EndpointAddress its = itsAddrs.next();
                if (mine.equals(its)) continue;
                return false;
            }
            return !itsAddrs.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this.getPublicAddress().hashCode();
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        Advertisement paramsAdv;
        ModuleImplAdvertisement implAdvertisement;
        block37: {
            Enumeration list;
            this.group = group;
            implAdvertisement = (ModuleImplAdvertisement)impl;
            this.executor = ((StdPeerGroup)group).getExecutor();
            ConfigParams configAdv = group.getConfigAdvertisement();
            XMLElement param = (XMLElement)((Object)implAdvertisement.getParam());
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                XMLElement pname = (XMLElement)list.nextElement();
                this.protocolName = pname.getTextValue();
            }
            if (null == (param = (XMLElement)((Object)configAdv.getServiceParam(assignedID)))) {
                throw new IllegalArgumentException(TransportAdvertisement.getAdvertisementType() + " could not be located.");
            }
            Enumeration tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (tcpChilds.hasMoreElements()) {
                param = (XMLElement)tcpChilds.nextElement();
                Attribute typeAttr = param.getAttribute("type");
                if (!TCPAdv.getAdvertisementType().equals(typeAttr.getValue())) {
                    throw new IllegalArgumentException("transport adv is not a " + TCPAdv.getAdvertisementType());
                }
                if (tcpChilds.hasMoreElements()) {
                    throw new IllegalArgumentException("Multiple transport advs detected for " + assignedID);
                }
            } else {
                throw new IllegalArgumentException(TransportAdvertisement.getAdvertisementType() + " could not be located.");
            }
            paramsAdv = null;
            try {
                paramsAdv = AdvertisementFactory.newAdvertisement(param);
            }
            catch (NoSuchElementException notThere) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block37;
                LOG.log(Level.FINE, "Could not find parameter document", notThere);
            }
        }
        if (!(paramsAdv instanceof TCPAdv)) {
            throw new IllegalArgumentException("Provided Advertisement was not a " + TCPAdv.getAdvertisementType());
        }
        TCPAdv adv = (TCPAdv)paramsAdv;
        this.interfaceAddressStr = adv.getInterfaceAddress();
        if (this.interfaceAddressStr != null) {
            try {
                this.usingInterface = InetAddress.getByName(this.interfaceAddressStr);
            }
            catch (UnknownHostException failed) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Invalid address for local interface address, using default");
                }
                this.usingInterface = IPUtils.ANYADDRESS;
            }
        } else {
            this.usingInterface = IPUtils.ANYADDRESS;
        }
        this.serverName = adv.getServer();
        this.serverSocketPort = adv.getPort();
        this.publicAddressOnly = adv.getPublicAddressOnly();
        if (adv.isServerEnabled()) {
            String hostAddress;
            try {
                this.unicastServer = new IncomingUnicastServer(this, this.usingInterface, this.serverSocketPort, adv.getStartPort(), adv.getEndPort());
            }
            catch (IOException failed) {
                throw new PeerGroupException("Failed to open server socket.", failed);
            }
            InetSocketAddress boundAddress = this.unicastServer.getLocalSocketAddress();
            if (this.serverName != null) {
                EndpointAddress newAddr = new EndpointAddress(this.protocolName, this.serverName, null, null);
                this.publicAddresses.add(newAddr);
            }
            boolean localOnly = true;
            if (this.usingInterface.equals(IPUtils.ANYADDRESS)) {
                Iterator<InetAddress> eachLocal = IPUtils.getAllLocalAddresses();
                ArrayList<EndpointAddress> wildAddrs = new ArrayList<EndpointAddress>();
                while (eachLocal.hasNext()) {
                    InetAddress anAddress = eachLocal.next();
                    String hostAddress2 = IPUtils.getHostAddress(anAddress);
                    EndpointAddress newAddr = new EndpointAddress(this.protocolName, hostAddress2 + ":" + Integer.toString(boundAddress.getPort()), null, null);
                    if (!anAddress.isLoopbackAddress()) {
                        localOnly = false;
                    }
                    if (this.publicAddresses.contains(newAddr)) continue;
                    wildAddrs.add(newAddr);
                }
                Collections.sort(wildAddrs, new Comparator<EndpointAddress>(){

                    @Override
                    public int compare(EndpointAddress one, EndpointAddress two) {
                        return one.toString().compareTo(two.toString());
                    }

                    @Override
                    public boolean equals(Object that) {
                        return this == that;
                    }
                });
                if (this.serverName == null || !this.publicAddressOnly) {
                    this.publicAddresses.addAll(wildAddrs);
                }
            } else {
                if (!this.usingInterface.isLoopbackAddress()) {
                    localOnly = false;
                }
                hostAddress = IPUtils.getHostAddress(this.usingInterface);
                EndpointAddress newAddr = new EndpointAddress(this.protocolName, hostAddress + ":" + Integer.toString(boundAddress.getPort()), null, null);
                if (!(this.serverName != null && this.publicAddressOnly || this.publicAddresses.contains(newAddr))) {
                    this.publicAddresses.add(newAddr);
                }
            }
            if (localOnly) {
                this.usingInterface = IPUtils.LOOPBACK;
                this.publicAddresses.clear();
                hostAddress = IPUtils.getHostAddress(this.usingInterface);
                EndpointAddress pubAddr = new EndpointAddress(this.protocolName, hostAddress + ":" + Integer.toString(boundAddress.getPort()), null, null);
                this.publicAddresses.add(pubAddr);
            }
            this.publicAddress = this.publicAddresses.get(0);
        } else {
            if (this.usingInterface.equals(IPUtils.ANYADDRESS)) {
                boolean localOnly = true;
                Iterator<InetAddress> eachLocal = IPUtils.getAllLocalAddresses();
                while (eachLocal.hasNext()) {
                    InetAddress anAddress = eachLocal.next();
                    if (anAddress.isLoopbackAddress()) continue;
                    localOnly = false;
                    break;
                }
                if (localOnly) {
                    this.usingInterface = IPUtils.LOOPBACK;
                }
            }
            String hostAddress = IPUtils.getHostAddress(this.usingInterface);
            this.publicAddress = new EndpointAddress(this.protocolName, hostAddress + ":0", null, null);
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring TCP Message Transport : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID: ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration:");
            configInfo.append("\n\t\tProtocol: ").append(this.protocolName);
            configInfo.append("\n\t\tPublic address: ").append(this.serverName == null ? "(unspecified)" : this.serverName);
            configInfo.append("\n\t\tInterface address: ").append(this.interfaceAddressStr == null ? "(unspecified)" : this.interfaceAddressStr);
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tUsing Interface: ").append(this.usingInterface.getHostAddress());
            if (null != this.unicastServer) {
                if (-1 == this.unicastServer.getStartPort()) {
                    configInfo.append("\n\t\tUnicast Server Bind Addr: ").append(this.usingInterface.getHostAddress()).append(":").append(this.serverSocketPort);
                } else {
                    configInfo.append("\n\t\tUnicast Server Bind Addr: ").append(this.usingInterface.getHostAddress()).append(":").append(this.serverSocketPort).append(" [").append(this.unicastServer.getStartPort()).append("-").append(this.unicastServer.getEndPort()).append("]");
                }
                configInfo.append("\n\t\tUnicast Server Bound Addr: ").append(this.unicastServer.getLocalSocketAddress());
            } else {
                configInfo.append("\n\t\tUnicast Server : disabled");
            }
            configInfo.append("\n\t\tPublic Addresses: ");
            configInfo.append("\n\t\t\tDefault Endpoint Addr : ").append(this.publicAddress);
            for (EndpointAddress anAddr : this.publicAddresses) {
                configInfo.append("\n\t\t\tEndpoint Addr : ").append(anAddr);
            }
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public synchronized int startApp(String[] arg) {
        TransportServiceMonitor transportServiceMonitor;
        block10: {
            this.endpoint = this.group.getEndpointService();
            if (null == this.endpoint) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Stalled until there is an endpoint service");
                }
                return 2;
            }
            try {
                this.messengerSelector = SelectorProvider.provider().openSelector();
            }
            catch (IOException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                LOG.log(Level.WARNING, "Could not create a messenger selector", e);
            }
        }
        this.messengerSelectorThread = new Thread(this.group.getHomeThreadGroup(), new MessengerSelectorThread(), "TCP Transport MessengerSelectorThread for " + this);
        this.messengerSelectorThread.setDaemon(true);
        this.messengerSelectorThread.start();
        this.messengerEventListener = this.endpoint.addMessageTransport(this);
        if (this.messengerEventListener == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return -1;
        }
        if (this.unicastServer != null && !this.unicastServer.start()) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Unable to start TCP Unicast Server");
            }
            return -1;
        }
        if (TransportMeterBuildSettings.TRANSPORT_METERING && (transportServiceMonitor = (TransportServiceMonitor)MonitorManager.getServiceMonitor(this.group, MonitorResources.transportServiceMonitorClassID)) != null) {
            this.unicastTransportMeter = transportServiceMonitor.createTransportMeter("TCP", this.publicAddress);
        }
        this.isClosed = false;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("TCP Message Transport started.");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopApp() {
        block9: {
            Thread temp;
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.unicastServer != null) {
                this.unicastServer.stop();
                this.unicastServer = null;
            }
            if (null != (temp = this.messengerSelectorThread)) {
                temp.interrupt();
                try {
                    this.messengerSelector.close();
                }
                catch (IOException failed) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block9;
                    LOG.log(Level.SEVERE, "IO error occured while closing server socket", failed);
                }
            }
        }
        Stack<Selector> stack = writeSelectorCache;
        synchronized (stack) {
            this.extraWriteSelectors += 50;
        }
        this.endpoint.removeMessageTransport(this);
        this.endpoint = null;
        this.group = null;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info(MessageFormat.format("Total bytes sent : {0}", this.getBytesSent()));
            LOG.info(MessageFormat.format("Total Messages sent : {0}", this.getMessagesSent()));
            LOG.info(MessageFormat.format("Total bytes received : {0}", this.getBytesReceived()));
            LOG.info(MessageFormat.format("Total Messages received : {0}", this.getMessagesReceived()));
            LOG.info(MessageFormat.format("Total connections accepted : {0}", this.getConnectionsAccepted()));
            LOG.info("TCP Message Transport shut down.");
        }
    }

    @Override
    public String getProtocolName() {
        return this.protocolName;
    }

    @Override
    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public EndpointService getEndpointService() {
        return (EndpointService)this.endpoint.getInterface();
    }

    @Override
    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    @Override
    public Iterator<EndpointAddress> getPublicAddresses() {
        return Collections.unmodifiableList(this.publicAddresses).iterator();
    }

    @Override
    public boolean isConnectionOriented() {
        return true;
    }

    @Override
    public boolean allowsRouting() {
        return true;
    }

    @Override
    public Messenger getMessenger(EndpointAddress dst, Object hintIgnored) {
        return this.getMessenger(dst, hintIgnored, true);
    }

    public Messenger getMessenger(EndpointAddress dst, Object hintIgnored, boolean selfDestruct) {
        if (!dst.getProtocolName().equalsIgnoreCase(this.getProtocolName())) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot make messenger for protocol: " + dst.getProtocolName());
            }
            return null;
        }
        EndpointAddress plainAddr = new EndpointAddress(dst, null, null);
        if (this.publicAddresses.contains(plainAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("return LoopbackMessenger for addr : " + dst);
            }
            return new LoopbackMessenger(this.group, this.endpoint, this.getPublicAddress(), dst, new EndpointAddress("jxta", this.group.getPeerID().getUniqueValue().toString(), null, null));
        }
        try {
            return new TcpMessenger(dst, this, selfDestruct);
        }
        catch (Exception caught) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Could not get messenger for " + dst, caught);
                } else {
                    LOG.warning("Could not get messenger for " + dst + " : " + caught.getMessage());
                }
            }
            if (caught instanceof RuntimeException) {
                throw (RuntimeException)caught;
            }
            return null;
        }
    }

    @Override
    public boolean ping(EndpointAddress addr) {
        boolean result;
        block6: {
            result = false;
            long pingStartTime = 0L;
            if (TransportMeterBuildSettings.TRANSPORT_METERING) {
                pingStartTime = System.currentTimeMillis();
            }
            EndpointAddress endpointAddress = new EndpointAddress(addr, null, null);
            try {
                TransportBindingMeter transportBindingMeter;
                TcpMessenger tcpMessenger = new TcpMessenger(endpointAddress, this);
                if (TransportMeterBuildSettings.TRANSPORT_METERING && (transportBindingMeter = tcpMessenger.getTransportBindingMeter()) != null) {
                    transportBindingMeter.ping(System.currentTimeMillis() - pingStartTime);
                }
                result = true;
            }
            catch (Throwable e) {
                TransportBindingMeter transportBindingMeter;
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "failure pinging " + addr.toString(), e);
                }
                if (!TransportMeterBuildSettings.TRANSPORT_METERING || (transportBindingMeter = this.getUnicastTransportBindingMeter(null, endpointAddress)) == null) break block6;
                transportBindingMeter.pingFailed(System.currentTimeMillis() - pingStartTime);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("ping to " + addr.toString() + " == " + result);
        }
        return result;
    }

    int getRestrictionPort() {
        return this.restrictionPort;
    }

    TransportBindingMeter getUnicastTransportBindingMeter(PeerID peerID, EndpointAddress destinationAddress) {
        if (this.unicastTransportMeter != null) {
            return this.unicastTransportMeter.getTransportBindingMeter(peerID != null ? peerID.toString() : TransportMeter.UNKNOWN_PEER, destinationAddress);
        }
        return null;
    }

    void messengerReadyEvent(Messenger newMessenger, EndpointAddress connAddr) {
        this.messengerEventListener.messengerReady(new MessengerEvent(this, newMessenger, connAddr));
    }

    IncomingUnicastServer getServer() {
        return this.unicastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Selector getSelector() throws InterruptedException {
        Stack<Selector> stack = writeSelectorCache;
        synchronized (stack) {
            Selector selector;
            block9: {
                selector = null;
                try {
                    if (!writeSelectorCache.isEmpty()) {
                        selector = writeSelectorCache.pop();
                    }
                }
                catch (EmptyStackException ese) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block9;
                    LOG.fine("No write selector available, waiting for one");
                }
            }
            for (int attempts = 0; selector == null && attempts < 2; ++attempts) {
                writeSelectorCache.wait(connectionTimeOut);
                try {
                    if (writeSelectorCache.isEmpty()) continue;
                    selector = writeSelectorCache.pop();
                    continue;
                }
                catch (EmptyStackException ese) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "Failed to get a write selector available, waiting for one", ese);
                }
            }
            return selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnSelector(Selector selector) {
        Stack<Selector> stack = writeSelectorCache;
        synchronized (stack) {
            if (this.extraWriteSelectors > 0) {
                --this.extraWriteSelectors;
            } else {
                writeSelectorCache.push(selector);
                writeSelectorCache.notify();
            }
        }
    }

    void register(SocketChannel channel, TcpMessenger messenger) {
        this.regisMap.put(messenger, channel);
        this.messengerSelector.wakeup();
    }

    void unregister(SocketChannel channel) {
        this.unregisMap.add(channel);
        this.messengerSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateChannelRegisterations() {
        Object anEntry;
        if (!this.regisMap.isEmpty() && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Registering {0} channels with MessengerSelectorThread", this.regisMap.size()));
        }
        if (!this.regisMap.isEmpty()) {
            Iterator<Map.Entry<TcpMessenger, SocketChannel>> eachMsgr = this.regisMap.entrySet().iterator();
            while (eachMsgr.hasNext()) {
                anEntry = eachMsgr.next();
                TcpMessenger msgr = (TcpMessenger)anEntry.getKey();
                SocketChannel channel = (SocketChannel)anEntry.getValue();
                SelectionKey key = channel.keyFor(this.messengerSelector);
                try {
                    if (key == null) {
                        key = channel.register(this.messengerSelector, 1, msgr);
                    }
                    key.interestOps(key.interestOps() | 1);
                    if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                        LOG.finer(MessageFormat.format("Key interestOps on channel {0}, bit set :{1}", channel, key.interestOps()));
                    }
                }
                catch (ClosedChannelException e) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Failed to register Channel with messenger selector", e);
                    }
                    msgr.close();
                }
                catch (CancelledKeyException e) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Key is already cancelled, removing key from registeration map", e);
                    }
                }
                catch (IllegalBlockingModeException e) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Invalid blocking channel mode, closing messenger", e);
                    }
                    msgr.close();
                }
                eachMsgr.remove();
            }
        }
        if (!this.unregisMap.isEmpty() && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine(MessageFormat.format("Unregistering {0} channels with MessengerSelectorThread", this.unregisMap.size()));
        }
        if (!this.unregisMap.isEmpty()) {
            Iterator eachChannel;
            anEntry = this.unregisMap;
            synchronized (anEntry) {
                ArrayList<SocketChannel> allChannels = new ArrayList<SocketChannel>(this.unregisMap);
                this.unregisMap.clear();
                eachChannel = allChannels.iterator();
            }
            while (eachChannel.hasNext()) {
                SocketChannel aChannel = (SocketChannel)eachChannel.next();
                SelectionKey key = aChannel.keyFor(this.messengerSelector);
                if (null == key) continue;
                try {
                    key.cancel();
                }
                catch (CancelledKeyException e) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "Key is already cancelled, removing key from registeration map", e);
                }
            }
        }
    }

    private class MessengerSelectorThread
    implements Runnable {
        private MessengerSelectorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("MessengerSelectorThread polling started");
                    }
                    while (!TcpTransport.this.isClosed) {
                        try {
                            int selectedKeys;
                            block25: {
                                selectedKeys = 0;
                                TcpTransport.this.updateChannelRegisterations();
                                try {
                                    selectedKeys = TcpTransport.this.messengerSelector.select();
                                }
                                catch (CancelledKeyException cke) {
                                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block25;
                                    LOG.log(Level.FINE, "Key was cancelled", cke);
                                }
                            }
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine(MessageFormat.format("MessengerSelector has {0} selected keys", selectedKeys));
                            }
                            if (selectedKeys == 0 && TcpTransport.this.messengerSelector.selectNow() == 0) continue;
                            Set<SelectionKey> keySet = TcpTransport.this.messengerSelector.selectedKeys();
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine(MessageFormat.format("KeySet has {0} selected keys", keySet.size()));
                            }
                            Iterator<SelectionKey> it = keySet.iterator();
                            while (it.hasNext()) {
                                SelectionKey key = it.next();
                                it.remove();
                                if (key.isValid()) {
                                    try {
                                        if (!key.isReadable() || !key.channel().isOpen()) continue;
                                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                                        TcpMessenger msgr = (TcpMessenger)key.attachment();
                                        try {
                                            TcpTransport.this.executor.execute(msgr);
                                        }
                                        catch (RejectedExecutionException re) {
                                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                                            LOG.log(Level.FINE, MessageFormat.format("Executor rejected task for messenger :{0}", msgr.toString()), re);
                                        }
                                    }
                                    catch (CancelledKeyException cce) {}
                                    continue;
                                }
                                try {
                                    key.channel().close();
                                }
                                catch (IOException io) {
                                    // empty catch block
                                }
                                key.cancel();
                                key = null;
                            }
                        }
                        catch (ClosedSelectorException cse) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("IO Selector closed");
                        }
                        catch (InterruptedIOException woken) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, "Thread inturrupted", woken);
                        }
                        catch (IOException e1) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.log(Level.WARNING, "An exception occurred while selecting keys", e1);
                        }
                        catch (SecurityException e2) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.log(Level.WARNING, "A security exception occurred while selecting keys", e2);
                        }
                    }
                    Object var8_15 = null;
                }
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && Logging.SHOW_SEVERE) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable", all);
                    }
                    Object var8_16 = null;
                    TcpTransport.this.messengerSelectorThread = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                TcpTransport.this.messengerSelectorThread = null;
                throw throwable;
            }
            TcpTransport.this.messengerSelectorThread = null;
        }
    }
}

