/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsInputStream;
import net.jxta.impl.endpoint.tls.JTlsOutputStream;
import net.jxta.impl.endpoint.tls.TlsSocket;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.util.IgnoreFlushFilterOutputStream;

class TlsConn {
    private static final transient Logger LOG = Logger.getLogger(TlsConn.class.getName());
    static final int BOSIZE = 16000;
    final TlsTransport transport;
    final EndpointAddress destAddr;
    private boolean client;
    private volatile HandshakeState currentState;
    private boolean closing = false;
    long lastAccessed;
    final String lastAccessedLock = new String("lastAccessedLock");
    final String closeLock = new String("closeLock");
    int retrans;
    final TlsSocket tlsSocket;
    private final SSLContext context;
    private SSLSocket ssls;
    private OutputStream plaintext_out = null;
    private PlaintextMessageReader readerThread = null;
    private String acquireMessengerLock = new String("Messenger Acquire Lock");
    private Messenger outBoundMessenger = null;

    TlsConn(TlsTransport tp, EndpointAddress destAddr, boolean client) throws Exception {
        this.transport = tp;
        this.destAddr = destAddr;
        this.client = client;
        this.currentState = client ? HandshakeState.CLIENTSTART : HandshakeState.SERVERSTART;
        this.lastAccessed = TimeUtils.timeNow();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info((client ? "Initiating" : "Accepting") + " new connection for : " + destAddr.getProtocolAddress());
        }
        boolean choseTMF = false;
        TrustManagerFactory tmf = null;
        String overrideTMF = System.getProperty("net.jxta.impl.endpoint.tls.TMFAlgorithm");
        if (!choseTMF && null != overrideTMF) {
            tmf = TrustManagerFactory.getInstance(overrideTMF);
            choseTMF = true;
        }
        List<Provider> providers = Arrays.asList(Security.getProviders());
        HashSet<String> providerNames = new HashSet<String>();
        Iterator eachProvider = providers.iterator();
        while (eachProvider.hasNext()) {
            providerNames.add(((Provider)eachProvider.next()).getName());
        }
        if (!choseTMF && providerNames.contains("SunJSSE")) {
            tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            choseTMF = true;
        }
        if (!choseTMF && providerNames.contains("IBMJSSE")) {
            tmf = TrustManagerFactory.getInstance("IbmX509", "IBMJSSE");
            choseTMF = true;
        }
        if (!choseTMF) {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            LOG.warning("Using defeualt Trust Manager Factory algorithm. This may not work as expected.");
        }
        KeyStore trusted = this.transport.membership.getPSEConfig().getKeyStore();
        tmf.init(trusted);
        TrustManager[] tms = tmf.getTrustManagers();
        KeyManager[] kms = new KeyManager[]{new PSECredentialKeyManager(this.transport.credential, trusted)};
        this.context = SSLContext.getInstance("TLS");
        this.context.init(kms, tms, null);
        SSLSocketFactory factory = this.context.getSocketFactory();
        TlsSocket newConnect = new TlsSocket(new JTlsInputStream(this, tp.MIN_IDLE_RECONNECT), new JTlsOutputStream(this.transport, this));
        this.ssls = (SSLSocket)factory.createSocket(newConnect, destAddr.getProtocolAddress(), 1376911, true);
        this.ssls.setEnabledProtocols(new String[]{"TLSv1"});
        this.ssls.setUseClientMode(client);
        if (!client) {
            this.ssls.setNeedClientAuth(true);
        }
        this.tlsSocket = newConnect;
    }

    public String toString() {
        return super.toString() + "/" + (Object)((Object)this.getHandshakeState()) + ":" + (this.client ? "Client" : "Server") + " for " + this.destAddr;
    }

    HandshakeState getHandshakeState() {
        return this.currentState;
    }

    synchronized HandshakeState setHandshakeState(HandshakeState newstate) {
        HandshakeState oldstate = this.currentState;
        this.currentState = newstate;
        this.notifyAll();
        return oldstate;
    }

    void finishHandshake() throws IOException {
        long startTime = 0L;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            startTime = TimeUtils.timeNow();
            LOG.info((this.client ? "Client:" : "Server:") + " Handshake START");
        }
        this.setHandshakeState(HandshakeState.HANDSHAKESTARTED);
        SSLSession newSession = this.ssls.getSession();
        if ("SSL_NULL_WITH_NULL_NULL".equals(newSession.getCipherSuite())) {
            this.setHandshakeState(HandshakeState.HANDSHAKEFAILED);
            throw new IOException("Handshake failed");
        }
        this.setHandshakeState(HandshakeState.HANDSHAKEFINISHED);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            long hsTime = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startTime) / 1000L;
            LOG.info((this.client ? "Client:" : "Server:") + "Handshake DONE in " + hsTime + " secs");
        }
        this.plaintext_out = new BufferedOutputStream(this.ssls.getOutputStream(), 16000);
        this.readerThread = new PlaintextMessageReader(this.ssls.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(HandshakeState finalstate) throws IOException {
        String string = this.lastAccessedLock;
        synchronized (string) {
            this.lastAccessed = Long.MIN_VALUE;
        }
        string = this.closeLock;
        synchronized (string) {
            block17: {
                this.closing = true;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Shutting down " + this);
                }
                this.setHandshakeState(HandshakeState.CONNECTIONCLOSING);
                try {
                    block16: {
                        try {
                            if (null != this.tlsSocket) {
                                try {
                                    this.tlsSocket.close();
                                }
                                catch (IOException ignored) {
                                    // empty catch block
                                }
                            }
                            if (null != this.ssls) {
                                try {
                                    this.ssls.close();
                                }
                                catch (IOException ignored) {
                                    // empty catch block
                                }
                                this.ssls = null;
                            }
                            if (null == this.outBoundMessenger) break block16;
                            this.outBoundMessenger.close();
                            this.outBoundMessenger = null;
                        }
                        catch (Throwable failed) {
                            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "Throwable during close " + this, failed);
                            }
                            IOException failure = new IOException("Throwable during close()");
                            failure.initCause(failed);
                            Object var6_7 = null;
                            this.closeLock.notifyAll();
                            this.closing = false;
                            this.setHandshakeState(finalstate);
                            break block17;
                        }
                    }
                    Object var6_6 = null;
                    this.closeLock.notifyAll();
                    this.closing = false;
                    this.setHandshakeState(finalstate);
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.closeLock.notifyAll();
                    this.closing = false;
                    this.setHandshakeState(finalstate);
                    throw throwable;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendToRemoteTls(Message msg) throws IOException {
        String string = this.acquireMessengerLock;
        synchronized (string) {
            if (null == this.outBoundMessenger || this.outBoundMessenger.isClosed()) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Getting messenger for " + this.destAddr);
                }
                EndpointAddress realAddr = new EndpointAddress(this.destAddr, "TlsTransport", null);
                this.outBoundMessenger = this.transport.endpoint.getMessenger(realAddr);
                if (this.outBoundMessenger == null) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Could not get messenger for " + realAddr);
                    }
                    return false;
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + msg + " to " + this.destAddr);
        }
        return this.outBoundMessenger.sendMessage(msg);
    }

    void sendMessage(Message msg) throws IOException {
        try {
            WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, JTlsDefs.MTYPE, null);
            serialed.sendToStream(new IgnoreFlushFilterOutputStream(this.plaintext_out));
            this.plaintext_out.flush();
        }
        catch (IOException failed) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Closing " + this + " due to exception ", failed);
            }
            this.close(HandshakeState.CONNECTIONDEAD);
            throw failed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PSECredentialKeyManager
    implements X509KeyManager {
        PSECredential cred;
        KeyStore trusted;

        public PSECredentialKeyManager(PSECredential useCred, KeyStore trusted) {
            this.cred = useCred;
            this.trusted = trusted;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            for (String aKeyType : Arrays.asList(keyType)) {
                String result = this.checkTheOne(aKeyType, Arrays.asList(issuers));
                if (null == result) continue;
                return result;
            }
            return null;
        }

        private String checkTheOne(String keyType, Collection<Principal> allIssuers) {
            List<X509Certificate> certificates = Arrays.asList(this.cred.getCertificateChain());
            for (X509Certificate certificate : certificates) {
                if (!certificate.getPublicKey().getAlgorithm().equals(keyType)) continue;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CHECKING: " + certificate.getIssuerX500Principal() + " in " + allIssuers);
                }
                if (!allIssuers.contains(certificate.getIssuerX500Principal())) continue;
                return "theone";
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] available = this.getServerAliases(keyType, issuers);
            if (null != available) {
                return available[0];
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (alias.equals("theone")) {
                return this.cred.getCertificateChain();
            }
            try {
                return (X509Certificate[])this.trusted.getCertificateChain(alias);
            }
            catch (KeyStoreException ignored) {
                return null;
            }
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            ArrayList<String> clientAliases = new ArrayList<String>();
            try {
                Enumeration<String> eachAlias = this.trusted.aliases();
                List<Principal> allIssuers = null;
                if (null != issuers) {
                    allIssuers = Arrays.asList(issuers);
                }
                while (eachAlias.hasMoreElements()) {
                    String anAlias = eachAlias.nextElement();
                    if (!this.trusted.isCertificateEntry(anAlias)) continue;
                    try {
                        X509Certificate aCert = (X509Certificate)this.trusted.getCertificate(anAlias);
                        if (null == aCert || !aCert.getPublicKey().getAlgorithm().equals(keyType)) continue;
                        if (null != allIssuers) {
                            if (!allIssuers.contains(aCert.getIssuerX500Principal())) continue;
                            clientAliases.add(anAlias);
                            continue;
                        }
                        clientAliases.add(anAlias);
                    }
                    catch (KeyStoreException ignored) {}
                }
            }
            catch (KeyStoreException ignored) {
                // empty catch block
            }
            return clientAliases.toArray(new String[clientAliases.size()]);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (alias.equals("theone")) {
                return this.cred.getPrivateKey();
            }
            return null;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            if (keyType.equals(this.cred.getCertificate().getPublicKey().getAlgorithm())) {
                if (null == issuers) {
                    return new String[]{"theone"};
                }
                List<Principal> allIssuers = Arrays.asList(issuers);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Looking for : " + this.cred.getCertificate().getIssuerX500Principal());
                    LOG.fine("Issuers : " + allIssuers);
                    X500Principal prin = this.cred.getCertificate().getIssuerX500Principal();
                    LOG.fine("  Principal Type :" + prin.getClass().getName());
                    for (Principal tmp : allIssuers) {
                        LOG.fine("Issuer Type : " + tmp.getClass().getName());
                        LOG.fine("Issuer value : " + tmp);
                        LOG.fine("tmp.equals(prin) : " + ((Object)tmp).equals(prin));
                    }
                }
                X509Certificate[] chain = this.cred.getCertificateChain();
                for (X509Certificate aCert : Arrays.asList(chain)) {
                    if (!allIssuers.contains(aCert.getIssuerX500Principal())) continue;
                    return new String[]{"theone"};
                }
            }
            return null;
        }
    }

    private class PlaintextMessageReader
    implements Runnable {
        InputStream ptin = null;
        Thread workerThread = null;

        public PlaintextMessageReader(InputStream ptin) {
            this.ptin = ptin;
            this.workerThread = new Thread(TlsConn.this.transport.myThreadGroup, this, "JXTA TLS Plaintext Reader for " + TlsConn.this.destAddr);
            this.workerThread.setDaemon(true);
            this.workerThread.start();
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Started ReadPlaintextMessage thread for " + TlsConn.this.destAddr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                Message msg;
                try {
                    try {
                        try {}
                        catch (IOException iox) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block13;
                            LOG.log(Level.WARNING, "I/O error while reading decrypted Message", iox);
                            break block13;
                        }
                    }
                    catch (Throwable all) {
                        if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                        }
                        Object var5_6 = null;
                        this.workerThread = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.workerThread = null;
                    throw throwable;
                }
                while (null != (msg = WireFormatMessageFactory.fromWire(this.ptin, JTlsDefs.MTYPE, null))) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Dispatching " + msg + " to TlsTransport");
                    }
                    TlsConn.this.transport.processReceivedMessage(msg);
                    String string = TlsConn.this.lastAccessedLock;
                    synchronized (string) {
                        TlsConn.this.lastAccessed = TimeUtils.timeNow();
                    }
                }
            }
            Object var5_5 = null;
            this.workerThread = null;
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Finishing ReadPlaintextMessage thread");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HandshakeState {
        CLIENTSTART,
        SERVERSTART,
        HANDSHAKESTARTED,
        HANDSHAKEFAILED,
        HANDSHAKEFINISHED,
        CONNECTIONCLOSING,
        CONNECTIONDEAD;

    }
}

