/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleSpecID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public class ModuleClassID
extends net.jxta.platform.ModuleClassID {
    private static final int moduleClassIdOffset = 0;
    private static final int moduleRoleIdOffset = 16;
    private static final int padOffset = 32;
    private static final int padSize = 31;
    protected IDBytes id;

    protected ModuleClassID(IDBytes id) {
        this.id = id;
    }

    protected ModuleClassID(UUID classUUID, UUID roleUUID) {
        this.id = new IDBytes(5);
        this.id.longIntoBytes(0, classUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, classUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, roleUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, roleUUID.getLeastSignificantBits());
    }

    public ModuleClassID() {
        this(UUIDFactory.newUUID(), new UUID(0L, 0L));
    }

    public ModuleClassID(ModuleClassID classID) {
        this(classID.getClassUUID(), UUIDFactory.newUUID());
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof ModuleClassID) {
            ModuleClassID mcidTarget = (ModuleClassID)target;
            return this.id.equals(mcidTarget.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public net.jxta.platform.ModuleClassID getBaseClass() {
        return new ModuleClassID(this.getClassUUID(), new UUID(0L, 0L));
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleClassID classId) {
        return this.getClassUUID().equals(((ModuleClassID)classId).getClassUUID());
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleSpecID specId) {
        return this.getClassUUID().equals(((ModuleSpecID)specId).getClassUUID());
    }

    protected UUID getClassUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        return result;
    }

    protected UUID getRoleUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        return result;
    }
}

