/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.binaryID.BinaryID;
import net.jxta.impl.id.binaryID.CodatBinaryID;
import net.jxta.impl.id.binaryID.IDFormat;
import net.jxta.impl.id.binaryID.ModuleClassBinaryID;
import net.jxta.impl.id.binaryID.ModuleSpecBinaryID;
import net.jxta.impl.id.binaryID.PeerBinaryID;
import net.jxta.impl.id.binaryID.PeerGroupBinaryID;
import net.jxta.impl.id.binaryID.PipeBinaryID;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;

public final class Instantiator
implements IDFactory.URIInstantiator {
    private static final transient Logger LOG = Logger.getLogger(Instantiator.class.getName());
    static final String BinaryIDEncoded = "binaryid";
    private static final Random randNumGenerator = new SecureRandom();

    public String getSupportedIDFormat() {
        return BinaryIDEncoded;
    }

    public ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        int colonAt = encoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(encoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        encoded = encoded.substring(colonAt + 1);
        try {
            return this.fromURNNamespaceSpecificPart(encoded);
        }
        catch (URISyntaxException failed) {
            MalformedURLException failure = new MalformedURLException("Failure parsing URL");
            failure.initCause(failed);
            throw failure;
        }
    }

    public ID fromURI(URI source) throws URISyntaxException {
        if (!"urn".equalsIgnoreCase(source.getScheme())) {
            throw new URISyntaxException(source.toString(), "URI scheme was not as expected.");
        }
        String decoded = source.getSchemeSpecificPart();
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new URISyntaxException(source.toString(), "URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new URISyntaxException(source.toString(), "URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        decoded = decoded.substring(colonAt + 1);
        return this.fromURNNamespaceSpecificPart(decoded);
    }

    public ID fromURNNamespaceSpecificPart(String encoded) throws URISyntaxException {
        int dashAt = encoded.indexOf(45);
        if (-1 == dashAt) {
            throw new URISyntaxException(encoded, "URN Encodingtype was missing.");
        }
        if (!encoded.substring(0, dashAt).equals(BinaryIDEncoded)) {
            throw new URISyntaxException(encoded, "JXTA id format was not as expected. Should have been BinaryIDEncoded found:" + encoded.substring(0, dashAt));
        }
        if ((encoded = encoded.substring(dashAt + 1)).length() < 1) {
            throw new URISyntaxException(encoded, "URN does not contain enough chars. Must have at least one byte");
        }
        BinaryID id = new BinaryID(encoded);
        ID result = null;
        switch (id.type()) {
            case 103: {
                result = new CodatBinaryID(encoded);
                break;
            }
            case 97: {
                result = new PeerGroupBinaryID(encoded);
                if (!PeerGroupID.worldPeerGroupID.equals(result)) break;
                result = PeerGroupID.worldPeerGroupID;
                break;
            }
            case 98: {
                result = new PeerBinaryID(encoded);
                break;
            }
            case 99: {
                result = new PipeBinaryID(encoded);
                break;
            }
            case 100: {
                result = new ModuleClassBinaryID(encoded);
                break;
            }
            case 102: {
                result = new ModuleSpecBinaryID(encoded);
                break;
            }
            default: {
                throw new URISyntaxException(encoded, "jxta ID type not recognized");
            }
        }
        return result;
    }

    private byte[] randomID() {
        byte[] randBuf16 = new byte[16];
        randNumGenerator.nextBytes(randBuf16);
        return randBuf16;
    }

    public CodatID newCodatID(PeerGroupID groupID) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, this.randomID(), false);
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] seed) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, seed, false);
    }

    public CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, this.randomID(), false);
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] idValue, InputStream in) throws IOException {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new CodatBinaryID(parentGroupID, idValue, false);
    }

    public PeerID newPeerID(PeerGroupID groupID) {
        LOG.log(Level.SEVERE, "random peer created", new RuntimeException());
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerBinaryID(parentGroupID, this.randomID(), false);
    }

    public PeerID newPeerID(PeerGroupID groupID, byte[] idValue) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PeerBinaryID(parentGroupID, idValue, false);
    }

    public PeerGroupID newPeerGroupID() {
        return IDFactory.newPeerGroupID(this.randomID());
    }

    public PeerGroupID newPeerGroupID(byte[] idValue) {
        return new PeerGroupBinaryID(idValue, false);
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent) {
        LOG.log(Level.SEVERE, "random peergroup created", new RuntimeException());
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(parent);
        return IDFactory.newPeerGroupID(parentGroupID, this.randomID());
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent, byte[] idValue) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(parent);
        return new PeerGroupBinaryID(parentGroupID, idValue, false);
    }

    public PipeID newPipeID(PeerGroupID groupID) {
        PeerGroupID parentGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return IDFactory.newPipeID(parentGroupID, this.randomID());
    }

    public PipeID newPipeID(PeerGroupID groupID, byte[] idValue) {
        PeerGroupID peerGroupID = (PeerGroupID)IDFormat.translateFromWellKnown(groupID);
        return new PipeBinaryID(peerGroupID, idValue, false);
    }

    public ModuleClassID newModuleClassID() {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }

    public ModuleClassID newModuleClassID(ModuleClassID classID) {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }

    public ModuleSpecID newModuleSpecID(ModuleClassID classID) {
        throw new UnsupportedOperationException("This form is not supported because a binary ID is meant to be created with a random ID. Use UUID package instead.");
    }
}

