/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.unknown;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.ProviderException;
import net.jxta.codat.CodatID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.unknown.ID;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import sun.net.www.protocol.urn.Handler;

final class Instantiator
implements IDFactory.URIInstantiator {
    static final String unknownFormat = "unknown";

    Instantiator() {
    }

    public String getSupportedIDFormat() {
        return unknownFormat;
    }

    public net.jxta.id.ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        String decoded = Handler.decodeURN(encoded);
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        decoded = decoded.substring(colonAt + 1);
        result = new ID(decoded);
        return result;
    }

    public CodatID newCodatID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        throw new ProviderException("unsupported id type");
    }

    public CodatID newCodatID(PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        throw new ProviderException("unsupported id type");
    }

    public PeerID newPeerID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public PeerID newPeerID(PeerGroupID groupID, byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public PeerGroupID newPeerGroupID() {
        throw new ProviderException("unsupported id type");
    }

    public PeerGroupID newPeerGroupID(byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent) {
        throw new ProviderException("unsupported id type");
    }

    public PeerGroupID newPeerGroupID(PeerGroupID parent, byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public PipeID newPipeID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public PipeID newPipeID(PeerGroupID groupID, byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public ModuleClassID newModuleClassID() {
        throw new ProviderException("unsupported id type");
    }

    public ModuleClassID newModuleClassID(ModuleClassID classID) {
        throw new ProviderException("unsupported id type");
    }

    public ModuleSpecID newModuleSpecID(ModuleClassID classID) {
        throw new ProviderException("unsupported id type");
    }

    public net.jxta.id.ID fromURI(URI source) throws URISyntaxException {
        if (!"urn".equalsIgnoreCase(source.getScheme())) {
            throw new URISyntaxException(source.toString(), "URI scheme was not as expected.");
        }
        String decoded = source.getSchemeSpecificPart();
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new URISyntaxException(source.toString(), "URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new URISyntaxException(source.toString(), "URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        decoded = decoded.substring(colonAt + 1);
        return this.fromURNNamespaceSpecificPart(decoded);
    }

    public net.jxta.id.ID fromURNNamespaceSpecificPart(String source) throws URISyntaxException {
        ID result = new ID(source);
        return result;
    }
}

