/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Element;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.peer.PeerInfoHandler;
import net.jxta.impl.peer.PeerInfoMessenger;
import net.jxta.impl.peer.PeerInfoServiceImpl;
import net.jxta.impl.peer.RemoteMonitorQuery;
import net.jxta.impl.peer.RemoteMonitorResponse;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.logging.Logging;
import net.jxta.meter.MonitorEvent;
import net.jxta.meter.MonitorException;
import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorFilterException;
import net.jxta.meter.MonitorListener;
import net.jxta.meter.MonitorReport;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.PeerMonitorInfo;
import net.jxta.meter.PeerMonitorInfoEvent;
import net.jxta.meter.PeerMonitorInfoListener;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.PeerInfoQueryMessage;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

class RemoteMonitorPeerInfoHandler
implements PeerInfoHandler {
    public static final String MONITOR_HANDLER_NAME = "Monitor";
    public static final int MAX_LEASE = 300000;
    public static final int MIN_LEASE = 60000;
    private static final Random rand = new Random();
    private static final Logger LOG = Logger.getLogger(RemoteMonitorPeerInfoHandler.class.getName());
    private Hashtable<Integer, RequestInfo> requestInfos = new Hashtable();
    private Hashtable<Integer, LeaseInfo> leaseInfos = new Hashtable();
    private Hashtable<Integer, Long> timeouts = new Hashtable();
    private PeerGroup peerGroup;
    private PeerInfoServiceImpl peerInfoServiceImpl;
    private Timer timer = new Timer(true);

    RemoteMonitorPeerInfoHandler(PeerGroup peerGroup, PeerInfoServiceImpl peerInfoServiceImpl) {
        this.peerGroup = peerGroup;
        this.peerInfoServiceImpl = peerInfoServiceImpl;
        this.timer.schedule((TimerTask)new TimerThreadNamer("RemoteMonitorPeerInfo timer for " + peerGroup.getPeerGroupID()), 0L);
    }

    public void stop() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextLeaseId() {
        int id;
        Random random = rand;
        synchronized (random) {
            id = rand.nextInt(Integer.MAX_VALUE);
        }
        return id;
    }

    public void getPeerMonitorInfo(final PeerID peerID, PeerMonitorInfoListener peerMonitorInfoListener, long timeout, PeerInfoMessenger peerInfoMessenger) throws MonitorException {
        int queryId = this.peerInfoServiceImpl.getNextQueryId();
        RemoteMonitorQuery remoteMonitorQuery = RemoteMonitorQuery.createPeerMonitorInfoQuery();
        peerInfoMessenger.sendPeerInfoRequest(queryId, peerID, MONITOR_HANDLER_NAME, remoteMonitorQuery);
        final RequestInfo requestInfo = new RequestInfo(peerID, queryId, peerMonitorInfoListener, timeout, peerInfoMessenger);
        this.requestInfos.put(queryId, requestInfo);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (!requestInfo.responseReceived) {
                    PeerMonitorInfoEvent peerMonitorInfoEvent = new PeerMonitorInfoEvent(peerID, null);
                    requestInfo.peerMonitorInfoListener.peerMonitorInfoNotReceived(peerMonitorInfoEvent);
                    RemoteMonitorPeerInfoHandler.this.requestInfos.remove(requestInfo.queryId);
                }
            }
        }, timeout);
    }

    public void getCumulativeMonitorReport(PeerID peerID, MonitorFilter monitorFilter, MonitorListener monitorListener, long timeout, PeerInfoMessenger peerInfoMessenger) throws MonitorException {
        int queryId = this.peerInfoServiceImpl.getNextQueryId();
        RemoteMonitorQuery remoteMonitorQuery = RemoteMonitorQuery.createGetCumulativeReportQuery(monitorFilter);
        peerInfoMessenger.sendPeerInfoRequest(queryId, peerID, MONITOR_HANDLER_NAME, remoteMonitorQuery);
        final RequestInfo requestInfo = new RequestInfo(peerID, queryId, monitorListener, timeout, peerInfoMessenger);
        this.requestInfos.put(queryId, requestInfo);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (!requestInfo.responseReceived) {
                    RemoteMonitorPeerInfoHandler.this.requestInfos.remove(requestInfo.queryId);
                }
            }
        }, timeout);
    }

    public void addRemoteMonitorListener(PeerID peerID, MonitorFilter monitorFilter, long reportRate, boolean includeCumulative, MonitorListener monitorListener, long lease, long timeout, PeerInfoMessenger peerInfoMessenger) throws MonitorException {
        int queryId = this.peerInfoServiceImpl.getNextQueryId();
        RemoteMonitorQuery remoteMonitorQuery = RemoteMonitorQuery.createRegisterMonitorQuery(includeCumulative, monitorFilter, reportRate, lease);
        peerInfoMessenger.sendPeerInfoRequest(queryId, peerID, MONITOR_HANDLER_NAME, remoteMonitorQuery);
        final RequestInfo requestInfo = new RequestInfo(peerID, queryId, monitorListener, timeout, peerInfoMessenger);
        requestInfo.requestedLease = lease;
        this.requestInfos.put(queryId, requestInfo);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (!requestInfo.responseReceived) {
                    MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(203, requestInfo.peerId, requestInfo.queryId);
                    requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                    RemoteMonitorPeerInfoHandler.this.requestInfos.remove(requestInfo.queryId);
                }
            }
        }, timeout);
        this.scheduleTimeout(requestInfo);
    }

    public void removeRemoteMonitorListener(PeerID peerID, MonitorListener monitorListener, long timeout, PeerInfoMessenger peerInfoMessenger) throws MonitorException {
        int queryId = this.peerInfoServiceImpl.getNextQueryId();
        RequestInfo oldRequestInfo = null;
        Enumeration<RequestInfo> e = this.requestInfos.elements();
        while (e.hasMoreElements()) {
            RequestInfo ri = e.nextElement();
            if (ri.monitorListener != monitorListener) continue;
            oldRequestInfo = ri;
            break;
        }
        if (oldRequestInfo != null) {
            RemoteMonitorQuery remoteMonitorQuery = RemoteMonitorQuery.createRemoveMonitorListenerQuery(oldRequestInfo.leaseId);
            peerInfoMessenger.sendPeerInfoRequest(queryId, peerID, MONITOR_HANDLER_NAME, remoteMonitorQuery);
            RequestInfo requestInfo = new RequestInfo(peerID, queryId, monitorListener, timeout, peerInfoMessenger);
            requestInfo.origRequestId = oldRequestInfo.queryId;
            this.requestInfos.put(queryId, requestInfo);
        }
        final RequestInfo requestInfo = oldRequestInfo;
        this.timer.schedule(new TimerTask(){

            public void run() {
                RemoteMonitorPeerInfoHandler.this.requestInfos.remove(new Integer(requestInfo.queryId));
            }
        }, timeout);
    }

    public void removeRemoteMonitorListener(MonitorListener monitorListener, long timeout, PeerInfoMessenger peerInfoMessenger) throws MonitorException {
        Enumeration<RequestInfo> e = this.requestInfos.elements();
        while (e.hasMoreElements()) {
            RequestInfo requestInfo = e.nextElement();
            if (requestInfo.monitorListener != monitorListener) continue;
            this.removeRemoteMonitorListener(requestInfo.peerId, monitorListener, timeout, peerInfoMessenger);
        }
    }

    public void processRequest(int queryId, PeerID requestSourceID, PeerInfoQueryMessage peerInfoQueryMessage, Element requestElement, PeerInfoMessenger peerInfoMessenger) {
        block11: {
            try {
                RemoteMonitorQuery remoteMonitorQuery = (RemoteMonitorQuery)DocumentSerializableUtilities.getDocumentSerializable(requestElement, RemoteMonitorQuery.class);
                if (remoteMonitorQuery.isRegisterMonitorQuery()) {
                    this.handleRegisterMonitorQuery(queryId, requestSourceID, remoteMonitorQuery, peerInfoMessenger);
                } else if (remoteMonitorQuery.isCumulativeReportQuery()) {
                    this.handleCumulativeReportQuery(queryId, requestSourceID, remoteMonitorQuery.getMonitorFilter(), peerInfoMessenger);
                } else if (remoteMonitorQuery.isRemoveMonitorQuery()) {
                    this.handleRemoveMonitorQuery(queryId, requestSourceID, remoteMonitorQuery, peerInfoMessenger);
                } else if (remoteMonitorQuery.isPeerMonitorInfoQuery()) {
                    this.handlePeerMonitorInfoQuery(queryId, requestSourceID, peerInfoMessenger);
                } else if (remoteMonitorQuery.isLeaseRenewal()) {
                    this.handleLeaseRenewalQuery(queryId, requestSourceID, remoteMonitorQuery, peerInfoMessenger);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block11;
                LOG.log(Level.FINE, "Monitor failed in processQuery", e);
            }
        }
    }

    public void processResponse(int queryId, PeerInfoResponseMessage peerInfoResponseMessage, Element responseElement, PeerInfoMessenger peerInfoMessenger) {
        block20: {
            try {
                RemoteMonitorResponse remoteMonitorResponse = (RemoteMonitorResponse)DocumentSerializableUtilities.getDocumentSerializable(responseElement, RemoteMonitorResponse.class);
                RequestInfo requestInfo = this.requestInfos.get(new Integer(queryId));
                if (requestInfo != null) {
                    requestInfo.responseReceived = true;
                    this.resetTimeout(requestInfo);
                    if (remoteMonitorResponse.isMonitorRegistered()) {
                        int leaseId = remoteMonitorResponse.getLeaseId();
                        long leaseLength = remoteMonitorResponse.getLease();
                        requestInfo.leaseId = leaseId;
                        this.scheduleLeaseRenewal(requestInfo, leaseLength);
                    } else if (remoteMonitorResponse.isMonitorRemoved()) {
                        this.requestInfos.remove(new Integer(requestInfo.origRequestId));
                        this.requestInfos.remove(new Integer(queryId));
                    } else if (remoteMonitorResponse.isCumulativeReport() || remoteMonitorResponse.isMonitorReport()) {
                        MonitorReport monitorReport = remoteMonitorResponse.getMonitorReport();
                        MonitorEvent monitorEvent = MonitorEvent.createRemoteMonitorReportEvent(requestInfo.peerId, requestInfo.queryId, monitorReport);
                        requestInfo.monitorListener.processMonitorReport(monitorEvent);
                    } else if (remoteMonitorResponse.isInvalidFilter()) {
                        MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(206, requestInfo.peerId, requestInfo.queryId);
                        requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                        this.requestInfos.remove(new Integer(queryId));
                    } else if (remoteMonitorResponse.isInvalidReportRate()) {
                        MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(205, requestInfo.peerId, requestInfo.queryId);
                        requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                        this.requestInfos.remove(new Integer(queryId));
                    } else if (remoteMonitorResponse.isMeteringNotSupported()) {
                        MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(204, requestInfo.peerId, requestInfo.queryId);
                        requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                        this.requestInfos.remove(new Integer(queryId));
                    } else if (remoteMonitorResponse.isRequestDenied()) {
                        MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(204, requestInfo.peerId, requestInfo.queryId);
                        requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                    } else if (remoteMonitorResponse.isPeerMonitorInfo()) {
                        PeerMonitorInfoEvent peerMonitorInfoEvent = new PeerMonitorInfoEvent(requestInfo.peerId, remoteMonitorResponse.getPeerMonitorInfo());
                        requestInfo.peerMonitorInfoListener.peerMonitorInfoReceived(peerMonitorInfoEvent);
                        this.requestInfos.remove(new Integer(queryId));
                    } else if (remoteMonitorResponse.isLeaseRenewed()) {
                        long lease = remoteMonitorResponse.getLease();
                        int origRequestId = requestInfo.origRequestId;
                        RequestInfo origRequest = this.requestInfos.get(new Integer(origRequestId));
                        this.scheduleLeaseRenewal(origRequest, lease);
                        this.requestInfos.remove(new Integer(queryId));
                    }
                }
            }
            catch (DocumentSerializationException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block20;
                LOG.log(Level.FINE, "Document Serialization Failed", e);
            }
        }
    }

    private void resetTimeout(RequestInfo requestInfo) {
        this.timeouts.put(requestInfo.queryId, requestInfo.timeout + System.currentTimeMillis());
    }

    private long getTimeout(int queryId) {
        return this.timeouts.get(queryId);
    }

    private void scheduleTimeout(final RequestInfo requestInfo) {
        final int queryId = requestInfo.queryId;
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (RemoteMonitorPeerInfoHandler.this.requestInfos.containsKey(new Integer(queryId))) {
                    try {
                        if (System.currentTimeMillis() > RemoteMonitorPeerInfoHandler.this.getTimeout(queryId)) {
                            MonitorEvent monitorEvent = MonitorEvent.createFailureEvent(203, requestInfo.peerId, queryId);
                            requestInfo.monitorListener.monitorRequestFailed(monitorEvent);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.cancel();
                }
            }
        }, requestInfo.timeout, requestInfo.timeout);
    }

    private void scheduleLeaseRenewal(RequestInfo requestInfo, long leaseLength) {
        long roundTrip = requestInfo.requestTime - System.currentTimeMillis();
        long renewTime = leaseLength - roundTrip - 30000L;
        final int queryId = requestInfo.queryId;
        if (renewTime > 60000L) {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    block2: {
                        try {
                            RemoteMonitorPeerInfoHandler.this.renewLease(queryId);
                        }
                        catch (Exception e) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block2;
                            LOG.log(Level.FINE, "Lease Renewal Failed", e);
                        }
                    }
                }
            }, renewTime);
        }
    }

    private void handleRegisterMonitorQuery(final int queryId, final PeerID requestSourceID, RemoteMonitorQuery remoteMonitorQuery, final PeerInfoMessenger peerInfoMessenger) {
        block7: {
            MonitorFilter monitorFilter = remoteMonitorQuery.getMonitorFilter();
            long lease = remoteMonitorQuery.getLease();
            long reportRate = remoteMonitorQuery.getReportRate();
            boolean includeCumulative = remoteMonitorQuery.isIncludeCumulative();
            MonitorListener monitorListener = new MonitorListener(){

                public void processMonitorReport(MonitorEvent monitorEvent) {
                    block2: {
                        MonitorReport monitorReport = monitorEvent.getMonitorReport();
                        try {
                            RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createMonitorReportResponse(queryId, monitorReport);
                            peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, RemoteMonitorPeerInfoHandler.MONITOR_HANDLER_NAME, remoteMonitorResponse);
                        }
                        catch (Exception e) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine(e.toString());
                        }
                    }
                }

                public void monitorReportingCancelled(MonitorEvent monitorEvent) {
                    throw new RuntimeException("METHOD NOT IMPLEMENTED");
                }

                public void monitorRequestFailed(MonitorEvent monitorEvent) {
                    throw new RuntimeException("METHOD NOT IMPLEMENTED");
                }
            };
            int leaseId = this.getNextLeaseId();
            LeaseInfo leaseInfo = new LeaseInfo(leaseId, requestSourceID, queryId, monitorListener, lease, peerInfoMessenger);
            long leaseTime = this.getLeaseTime(lease);
            this.setupLeaseTimeout(leaseInfo.leaseId, leaseTime);
            try {
                Iterator i = monitorFilter.getServiceMonitorFilters();
                while (i.hasNext()) {
                    ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)i.next();
                    if (!serviceMonitorFilter.getModuleClassID().equals(MonitorResources.transportServiceMonitorClassID)) continue;
                    try {
                        MonitorFilter worldGroupFilter = new MonitorFilter("worldGroupFilter");
                        worldGroupFilter.addServiceMonitorFilter(serviceMonitorFilter);
                        i.remove();
                        PeerGroup worldGroup = this.peerGroup.newGroup(PeerGroupID.worldPeerGroupID);
                        PeerInfoService worldService = worldGroup.getPeerInfoService();
                        worldService.addMonitorListener(worldGroupFilter, remoteMonitorQuery.getReportRate(), includeCumulative, monitorListener);
                        leaseInfo.listenerAddedToWorldGroup = true;
                        leaseInfo.worldGroup = worldGroup;
                    }
                    catch (PeerGroupException e) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine(e.toString());
                    }
                }
                if (monitorFilter.getServiceMonitorFilterCount() > 0) {
                    this.peerInfoServiceImpl.addMonitorListener(monitorFilter, reportRate, includeCumulative, monitorListener);
                }
                this.leaseInfos.put(leaseId, leaseInfo);
                RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createMonitorRegisteredResponse(queryId, leaseId, leaseTime);
                peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
            }
            catch (MonitorFilterException e) {
                RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createInvalidFilterResponse(queryId);
                peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
            }
            catch (MonitorException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine(e.toString());
            }
        }
    }

    private void handleRemoveMonitorQuery(int queryId, PeerID requestSourceID, RemoteMonitorQuery remoteMonitorQuery, PeerInfoMessenger peerInfoMessenger) {
        block4: {
            try {
                int leaseId = remoteMonitorQuery.getLeaseId();
                LeaseInfo leaseInfo = this.leaseInfos.get(new Integer(leaseId));
                if (leaseInfo != null) {
                    MonitorListener monitorListener = leaseInfo.monitorListener;
                    this.peerInfoServiceImpl.removeMonitorListener(monitorListener);
                    if (leaseInfo.listenerAddedToWorldGroup) {
                        PeerInfoService peerInfoService = leaseInfo.worldGroup.getPeerInfoService();
                        peerInfoService.removeMonitorListener(monitorListener);
                    }
                    RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createMonitorRemovedResponse(queryId);
                    peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
                }
            }
            catch (MonitorException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine(e.toString());
            }
        }
    }

    private void handleCumulativeReportQuery(int queryId, PeerID requestSourceID, MonitorFilter monitorFilter, PeerInfoMessenger peerInfoMessenger) throws MonitorException, DocumentSerializationException {
        MonitorReport monitorReport = this.peerInfoServiceImpl.getCumulativeMonitorReport(monitorFilter);
        RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createCumulativeReportResponse(queryId, monitorReport);
        peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
    }

    private void handlePeerMonitorInfoQuery(int queryId, PeerID requestSourceID, PeerInfoMessenger peerInfoMessenger) throws DocumentSerializationException {
        block2: {
            try {
                PeerGroup worldGroup = this.peerGroup.newGroup(PeerGroupID.worldPeerGroupID);
                PeerInfoService worldService = worldGroup.getPeerInfoService();
                PeerMonitorInfo peerMonitorInfo = worldService.getPeerMonitorInfo();
                RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createPeerMonitorInfoResponse(queryId, peerMonitorInfo);
                peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
            }
            catch (PeerGroupException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine(e.toString());
            }
        }
    }

    private void handleLeaseRenewalQuery(int queryId, PeerID requestSourceID, RemoteMonitorQuery remoteMonitorQuery, PeerInfoMessenger peerInfoMessenger) throws DocumentSerializationException {
        int leaseId = remoteMonitorQuery.getLeaseId();
        LeaseInfo leaseInfo = this.leaseInfos.get(new Integer(leaseId));
        if (leaseInfo != null) {
            long reqLease = remoteMonitorQuery.getLease();
            long lease = this.getLeaseTime(reqLease);
            leaseInfo.validUntil = System.currentTimeMillis() + lease;
            this.setupLeaseTimeout(leaseInfo.leaseId, lease);
            RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createLeaseRenewedResponse(queryId, leaseInfo.leaseId, lease);
            peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
        } else {
            RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createDeniedResponse(queryId);
            peerInfoMessenger.sendPeerInfoResponse(queryId, requestSourceID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
        }
    }

    long getLeaseTime(long requestedLease) {
        long leaseTime = requestedLease < 300000L ? requestedLease : 300000L;
        leaseTime = leaseTime > 60000L ? leaseTime : 60000L;
        return leaseTime;
    }

    private void cancelLease(LeaseInfo leaseInfo) throws MonitorException, DocumentSerializationException {
        if (leaseInfo.listenerAddedToWorldGroup) {
            leaseInfo.worldGroup.getPeerInfoService().removeMonitorListener(leaseInfo.monitorListener);
        }
        RemoteMonitorResponse remoteMonitorResponse = RemoteMonitorResponse.createLeaseEndedResponse(leaseInfo.queryId, leaseInfo.leaseId);
        leaseInfo.peerInfoMessenger.sendPeerInfoResponse(leaseInfo.queryId, leaseInfo.peerID, MONITOR_HANDLER_NAME, remoteMonitorResponse);
    }

    private void renewLease(int queryId) {
        block3: {
            try {
                RequestInfo requestInfo = this.requestInfos.get(new Integer(queryId));
                if (requestInfo != null) {
                    int renewalQueryId = this.peerInfoServiceImpl.getNextQueryId();
                    PeerID peerID = requestInfo.peerId;
                    long timeout = requestInfo.timeout;
                    RemoteMonitorQuery remoteMonitorQuery = RemoteMonitorQuery.createLeaseRenewalQuery(requestInfo.leaseId, requestInfo.requestedLease);
                    requestInfo.peerInfoMessenger.sendPeerInfoRequest(queryId, peerID, MONITOR_HANDLER_NAME, remoteMonitorQuery);
                    RequestInfo renewalRequestInfo = new RequestInfo(peerID, queryId, timeout, requestInfo.peerInfoMessenger);
                    renewalRequestInfo.requestedLease = requestInfo.requestedLease;
                    renewalRequestInfo.origRequestId = queryId;
                    this.requestInfos.put(renewalQueryId, renewalRequestInfo);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block3;
                LOG.log(Level.FINE, "error while attempting Monitor lease renewal", e);
            }
        }
    }

    private void setupLeaseTimeout(final int leaseId, long lease) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                LeaseInfo leaseInfo = (LeaseInfo)RemoteMonitorPeerInfoHandler.this.leaseInfos.get(new Integer(leaseId));
                if (leaseInfo == null) return;
                long currentTime = System.currentTimeMillis();
                if (leaseInfo.validUntil > currentTime) return;
                try {
                    try {
                        RemoteMonitorPeerInfoHandler.this.cancelLease(leaseInfo);
                    }
                    catch (Exception e) {
                        Object var6_4 = null;
                        RemoteMonitorPeerInfoHandler.this.leaseInfos.remove(leaseInfo.queryId);
                        return;
                    }
                    Object var6_3 = null;
                    RemoteMonitorPeerInfoHandler.this.leaseInfos.remove(leaseInfo.queryId);
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    RemoteMonitorPeerInfoHandler.this.leaseInfos.remove(leaseInfo.queryId);
                    throw throwable;
                }
            }
        }, lease);
    }

    private class LeaseInfo {
        int leaseId;
        PeerID peerID;
        int queryId;
        MonitorListener monitorListener;
        long validUntil;
        boolean listenerAddedToWorldGroup = false;
        PeerGroup worldGroup;
        PeerInfoMessenger peerInfoMessenger;

        LeaseInfo(int leaseId, PeerID peerID, int queryId, MonitorListener monitorListener, long leaseLength, PeerInfoMessenger peerInfoMessenger) {
            this.leaseId = leaseId;
            this.peerID = peerID;
            this.queryId = queryId;
            this.monitorListener = monitorListener;
            this.peerInfoMessenger = peerInfoMessenger;
            this.validUntil = System.currentTimeMillis() + leaseLength;
        }
    }

    private class RequestInfo {
        long requestTime = System.currentTimeMillis();
        PeerID peerId;
        int queryId;
        int origRequestId;
        MonitorListener monitorListener;
        PeerMonitorInfoListener peerMonitorInfoListener;
        long timeout;
        long validUntil;
        boolean responseReceived = false;
        int leaseId;
        long requestedLease;
        PeerInfoMessenger peerInfoMessenger;

        RequestInfo(PeerID peerId, int queryId, MonitorListener monitorListener, long timeout, PeerInfoMessenger peerInfoMessenger) {
            this(peerId, queryId, timeout, peerInfoMessenger);
            this.monitorListener = monitorListener;
        }

        RequestInfo(PeerID peerId, int queryId, PeerMonitorInfoListener peerMonitorInfoListener, long timeout, PeerInfoMessenger peerInfoMessenger) {
            this(peerId, queryId, timeout, peerInfoMessenger);
            this.peerMonitorInfoListener = peerMonitorInfoListener;
        }

        RequestInfo(PeerID peerId, int queryId, long timeout, PeerInfoMessenger peerInfoMessenger) {
            this.peerId = peerId;
            this.queryId = queryId;
            this.timeout = timeout;
            this.peerInfoMessenger = peerInfoMessenger;
            this.validUntil = System.currentTimeMillis() + timeout;
        }
    }
}

