/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.loader.RefJxtaLoader;
import net.jxta.impl.peergroup.CompatibilityEquater;
import net.jxta.impl.peergroup.PeerGroupInterface;
import net.jxta.impl.peergroup.RefCountPeerGroupInterface;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericPeerGroup
implements PeerGroup {
    private static final transient Logger LOG = Logger.getLogger(GenericPeerGroup.class.getName());
    private static final Map<ID, ConfigParams> group_configs = Collections.synchronizedMap(new HashMap());
    private static final JxtaLoader loader = new RefJxtaLoader(new URL[0], new CompatibilityEquater(){

        public boolean compatible(Element test) {
            return StdPeerGroup.isCompatible(test);
        }
    });
    private EndpointService endpoint;
    private ResolverService resolver;
    private DiscoveryService discovery;
    private PipeService pipe;
    private MembershipService membership;
    private RendezVousService rendezvous;
    private PeerInfoService peerinfo;
    private AccessService access;
    private final PeerAdvertisement peerAdvertisement;
    private PeerGroupAdvertisement peerGroupAdvertisement = null;
    protected ModuleImplAdvertisement implAdvertisement = null;
    protected ConfigParams configAdvertisement = null;
    protected PeerGroup parentGroup = null;
    protected URI jxtaHome = null;
    private final Map<ModuleClassID, Service> services = new HashMap<ModuleClassID, Service>();
    private volatile boolean stopping = false;
    private boolean published = false;
    private int masterRefCount = 0;
    private boolean stopWhenUnreferenced = false;
    protected volatile boolean initComplete = false;
    private ThreadGroup threadGroup = null;
    private final int COREPOOLSIZE = 5;
    private final long KEEPALIVETIME = 15L;
    private final int MAXPOOLSIZE = 100;
    private BlockingQueue<Runnable> taskQueue;
    private ThreadPoolExecutor threadPool;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    @Override
    public PeerGroup getParentGroup() {
        if (this.parentGroup == null) {
            return null;
        }
        return this.parentGroup.getWeakInterface();
    }

    @Override
    public URI getStoreHome() {
        return this.jxtaHome;
    }

    protected void setStoreHome(URI newHome) {
        this.jxtaHome = newHome;
    }

    public static JxtaLoader getJxtaLoader() {
        return loader;
    }

    public GenericPeerGroup() {
        this.peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
    }

    public boolean equals(Object target) {
        if (!(target instanceof PeerGroup)) {
            return false;
        }
        PeerGroup targetAsPeerGroup = (PeerGroup)target;
        if (null == this.parentGroup && null != targetAsPeerGroup.getParentGroup()) {
            return false;
        }
        if (null != this.parentGroup && null == targetAsPeerGroup.getParentGroup()) {
            return false;
        }
        if (null != this.parentGroup && !this.parentGroup.equals(targetAsPeerGroup.getParentGroup())) {
            return false;
        }
        return this.getPeerGroupID().equals(targetAsPeerGroup.getPeerGroupID());
    }

    public int hashCode() {
        if (null == this.peerAdvertisement || null == this.getPeerGroupID()) {
            throw new IllegalStateException("PeerGroup not sufficiently initialized");
        }
        return this.getPeerGroupID().hashCode();
    }

    public String toString() {
        if (null == this.getPeerGroupID()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getPeerGroupID().toString());
        String peerGroupName = this.peerGroupAdvertisement.getName();
        if (null != peerGroupName) {
            result.append(" \"");
            result.append(peerGroupName);
            result.append('\"');
        }
        result.append('[');
        result.append(this.masterRefCount);
        result.append(']');
        if (null != this.parentGroup) {
            result.append(" / ");
            result.append(this.parentGroup.toString());
        }
        return result.toString();
    }

    @Override
    public ThreadGroup getHomeThreadGroup() {
        return this.threadGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<Advertisement> discoverSome(DiscoveryService discovery, int type, String attr, String value, int seconds, Class thisClass) {
        long discoverUntil = TimeUtils.toAbsoluteTimeMillis((long)seconds * 1000L);
        long lastRemoteAt = 0L;
        ArrayList<Advertisement> results = new ArrayList<Advertisement>();
        try {
            do {
                Enumeration<Advertisement> res = discovery.getLocalAdvertisements(type, attr, value);
                while (res.hasMoreElements()) {
                    Advertisement a = res.nextElement();
                    if (!thisClass.isInstance(a)) continue;
                    results.add(a);
                }
                if (!results.isEmpty()) return results;
                if (TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), lastRemoteAt) > 30000L) {
                    discovery.getRemoteAdvertisements(null, type, attr, value, 20);
                    lastRemoteAt = TimeUtils.timeNow();
                }
                Thread.sleep(1000L);
            } while (TimeUtils.timeNow() < discoverUntil);
            return results;
        }
        catch (Exception whatever) {
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) return results;
            LOG.log(Level.WARNING, "Failure during discovery", whatever);
        }
        return results;
    }

    private Advertisement discoverOne(int type, String attr, String value, int seconds, Class thisClass) {
        Iterator<Advertisement> res = this.discoverSome(this.discovery, type, attr, value, seconds, thisClass).iterator();
        if (!res.hasNext()) {
            return null;
        }
        return res.next();
    }

    private void setShortCut(ModuleClassID mcid, Service service) {
        if (endpointClassID.equals(mcid)) {
            this.endpoint = (EndpointService)service;
            return;
        }
        if (resolverClassID.equals(mcid)) {
            this.resolver = (ResolverService)service;
            return;
        }
        if (discoveryClassID.equals(mcid)) {
            this.discovery = (DiscoveryService)service;
            return;
        }
        if (pipeClassID.equals(mcid)) {
            this.pipe = (PipeService)service;
            return;
        }
        if (membershipClassID.equals(mcid)) {
            this.membership = (MembershipService)service;
            return;
        }
        if (peerinfoClassID.equals(mcid)) {
            this.peerinfo = (PeerInfoService)service;
            return;
        }
        if (rendezvousClassID.equals(mcid)) {
            this.rendezvous = (RendezVousService)service;
            return;
        }
        if (accessClassID.equals(mcid)) {
            this.access = (AccessService)service;
        }
    }

    protected synchronized void addService(ModuleClassID mcid, Service service) {
        if (this.stopping) {
            return;
        }
        if (this.services.containsKey(mcid)) {
            throw new IllegalStateException("Service" + mcid + " already registered.");
        }
        this.services.put(mcid, service);
        this.setShortCut(mcid, service);
    }

    @Override
    public synchronized Service lookupService(ID mcid) throws ServiceNotFoundException {
        Service p = this.services.get(mcid);
        if (p == null) {
            throw new ServiceNotFoundException("Not found: " + mcid.toString());
        }
        return p.getInterface();
    }

    @Override
    public Service lookupService(ID mcid, int roleIndex) throws ServiceNotFoundException {
        if (roleIndex != 0) {
            throw new ServiceNotFoundException("Not found: " + mcid + "[" + roleIndex + "]");
        }
        return this.lookupService(mcid);
    }

    @Override
    public Iterator getRoleMap(ID name) {
        return Collections.singletonList(name).iterator();
    }

    protected void checkServices() throws ServiceNotFoundException {
        Service ignored = this.lookupService(endpointClassID);
        ignored = this.lookupService(resolverClassID);
        ignored = this.lookupService(membershipClassID);
        ignored = this.lookupService(accessClassID);
    }

    protected synchronized void removeService(ModuleClassID mcid) throws ServiceNotFoundException {
        this.setShortCut(mcid, null);
        Service p = this.services.remove(mcid);
        if (p == null) {
            throw new ServiceNotFoundException("Not found: " + mcid.toString());
        }
        p.stopApp();
    }

    @Override
    public Module loadModule(ID assigned, Advertisement impl) throws ProtocolNotSupportedException, PeerGroupException {
        return this.loadModule(assigned, (ModuleImplAdvertisement)impl, false);
    }

    /*
     * Unable to fully structure code
     */
    protected Module loadModule(ID assigned, ModuleImplAdvertisement implAdv, boolean privileged) throws ProtocolNotSupportedException, PeerGroupException {
        compat = implAdv.getCompat();
        if (null == compat) {
            throw new IllegalArgumentException("No compatibility statement for : " + assigned);
        }
        if (!this.compatible(compat)) {
            if (Logging.SHOW_WARNING && GenericPeerGroup.LOG.isLoggable(Level.WARNING)) {
                GenericPeerGroup.LOG.warning("Incompatible Module : " + assigned);
            }
            throw new ProtocolNotSupportedException("Incompatible Module : " + assigned);
        }
        newMod = null;
        if (null != implAdv.getCode() && null != implAdv.getUri()) {
            try {
                try {
                    clazz = GenericPeerGroup.loader.findClass(implAdv.getModuleSpecID());
                }
                catch (ClassNotFoundException notLoaded) {
                    clazz = GenericPeerGroup.loader.defineClass(implAdv);
                }
                if (null == clazz) {
                    throw new ClassNotFoundException("Cannot load class (" + implAdv.getCode() + ") : " + assigned);
                }
                newMod = clazz.newInstance();
                newMod.init(privileged != false ? this : (PeerGroup)this.getInterface(), assigned, implAdv);
                if (!Logging.SHOW_INFO || !GenericPeerGroup.LOG.isLoggable(Level.INFO)) ** GOTO lbl32
                GenericPeerGroup.LOG.info("Loaded" + (privileged != false ? " privileged" : "") + " module : " + implAdv.getDescription() + " (" + implAdv.getCode() + ")");
            }
            catch (Exception ex) {
                try {
                    newMod.stopApp();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw new PeerGroupException("Could not load module for : " + assigned + " (" + implAdv.getDescription() + ")", ex);
            }
        } else {
            error = null == implAdv.getCode() ? "ModuleImpAdvertisement missing Code element" : (null == implAdv.getUri() ? "ModuleImpAdvertisement missing URI element" : "ModuleImpAdvertisement missing both Code and URI elements");
            throw new PeerGroupException("Can not load module : " + error + " for" + assigned);
        }
lbl32:
        // 2 sources

        try {
            if (this.discovery != null) {
                this.discovery.publish(implAdv, 31536000000L, 1209600000L);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return newMod;
    }

    @Override
    public Module loadModule(ID assigned, ModuleSpecID specID, int where) {
        return this.loadModule(assigned, specID, where, false);
    }

    protected Module loadModule(ID assignedID, ModuleSpecID specID, int where, boolean privileged) {
        ArrayList<Advertisement> allModuleImplAdvs = new ArrayList<Advertisement>();
        ModuleImplAdvertisement loadedImplAdv = loader.findModuleImplAdvertisement(specID);
        if (null != loadedImplAdv) {
            allModuleImplAdvs.add(loadedImplAdv);
        } else {
            boolean fromParent;
            boolean fromHere = where == 0 || where == 2;
            boolean bl = fromParent = where == 1 || where == 2;
            if (fromHere && null != this.discovery) {
                Collection<Advertisement> here = this.discoverSome(this.discovery, 2, "MSID", specID.toString(), 120, ModuleImplAdvertisement.class);
                allModuleImplAdvs.addAll(here);
            }
            if (fromParent && null != this.getParentGroup() && null != this.parentGroup.getDiscoveryService()) {
                Collection<Advertisement> parent = this.discoverSome(this.parentGroup.getDiscoveryService(), 2, "MSID", specID.toString(), 120, ModuleImplAdvertisement.class);
                allModuleImplAdvs.addAll(parent);
            }
        }
        Throwable recentFailure = null;
        for (Advertisement eachAdv : allModuleImplAdvs) {
            if (!(eachAdv instanceof ModuleImplAdvertisement)) continue;
            ModuleImplAdvertisement foundImpl = (ModuleImplAdvertisement)eachAdv;
            try {
                if (!specID.equals(foundImpl.getModuleSpecID())) continue;
                Module newMod = this.loadModule(assignedID, foundImpl, privileged);
                return newMod;
            }
            catch (ProtocolNotSupportedException failed) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Incompatbile impl adv");
            }
            catch (PeerGroupException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Initialization failed", failed);
            }
            catch (Throwable e) {
                recentFailure = e;
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Not a usable impl adv: ", e);
            }
        }
        if (null != recentFailure) {
            if (recentFailure instanceof Error) {
                throw (Error)recentFailure;
            }
            if (recentFailure instanceof RuntimeException) {
                throw (RuntimeException)recentFailure;
            }
            throw new UndeclaredThrowableException(recentFailure);
        }
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Could not find a loadable implementation for SpecID: " + specID);
        }
        return null;
    }

    @Override
    public ConfigParams getConfigAdvertisement() {
        return this.configAdvertisement;
    }

    protected void setConfigAdvertisement(ConfigParams config) {
        this.configAdvertisement = config;
    }

    public static void setGroupConfigAdvertisement(ID groupid, ConfigParams params) {
        if (null != params) {
            group_configs.put(groupid, params);
        } else {
            group_configs.remove(groupid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(PeerGroup homeGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        try {
            this.initFirst(homeGroup, assignedID, impl);
            this.initLast();
            Object var5_4 = null;
            this.initComplete = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.initComplete = true;
            throw throwable;
        }
    }

    protected void initFirst(PeerGroup homeGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        block31: {
            this.implAdvertisement = (ModuleImplAdvertisement)impl;
            this.parentGroup = homeGroup;
            if (null != this.parentGroup) {
                this.jxtaHome = this.parentGroup.getStoreHome();
            }
            if (null != assignedID && null == this.getConfigAdvertisement()) {
                this.setConfigAdvertisement(group_configs.remove(assignedID));
            }
            try {
                Enumeration<Advertisement> found;
                DiscoveryService disco;
                if (null == assignedID) {
                    if ("cbid".equals(IDFactory.getDefaultIDFormat())) {
                        throw new IllegalStateException("Cannot generate group id for cbid group");
                    }
                    assignedID = IDFactory.newPeerGroupID();
                } else if (this.parentGroup != null && null != (disco = this.parentGroup.getDiscoveryService()) && (found = disco.getLocalAdvertisements(1, "GID", assignedID.toString())).hasMoreElements()) {
                    this.peerGroupAdvertisement = (PeerGroupAdvertisement)found.nextElement();
                }
                if (!(assignedID instanceof PeerGroupID)) {
                    throw new PeerGroupException("assignedID must be a peer group ID");
                }
                this.peerAdvertisement.setPeerGroupID((PeerGroupID)assignedID);
                if (this.configAdvertisement != null && this.configAdvertisement instanceof PlatformConfig) {
                    PlatformConfig platformConfig = (PlatformConfig)this.configAdvertisement;
                    PeerID configPID = platformConfig.getPeerID();
                    if (null == configPID || ID.nullID == configPID) {
                        if ("cbid".equals(IDFactory.getDefaultIDFormat())) {
                            XMLElement param = (XMLElement)((Object)platformConfig.getServiceParam(PeerGroup.membershipClassID));
                            if (null == param) {
                                throw new IllegalArgumentException(PSEConfigAdv.getAdvertisementType() + " could not be located");
                            }
                            Advertisement paramsAdv = null;
                            try {
                                paramsAdv = AdvertisementFactory.newAdvertisement(param);
                            }
                            catch (NoSuchElementException noadv) {
                                // empty catch block
                            }
                            if (!(paramsAdv instanceof PSEConfigAdv)) {
                                throw new IllegalArgumentException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
                            }
                            PSEConfigAdv config = (PSEConfigAdv)paramsAdv;
                            X509Certificate clientRoot = config.getCertificate();
                            byte[] pub_der = clientRoot.getPublicKey().getEncoded();
                            platformConfig.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID, pub_der));
                        } else {
                            platformConfig.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID));
                        }
                    }
                    this.peerAdvertisement.setPeerID(platformConfig.getPeerID());
                    this.peerAdvertisement.setName(platformConfig.getName());
                    this.peerAdvertisement.setDesc(platformConfig.getDesc());
                } else if (null == this.parentGroup) {
                    this.peerAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID));
                } else {
                    this.peerAdvertisement.setPeerID(this.parentGroup.getPeerAdvertisement().getPeerID());
                    this.peerAdvertisement.setName(this.parentGroup.getPeerAdvertisement().getName());
                    this.peerAdvertisement.setDesc(this.parentGroup.getPeerAdvertisement().getDesc());
                }
                if (this.peerGroupAdvertisement == null) {
                    this.peerGroupAdvertisement = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
                    this.peerGroupAdvertisement.setPeerGroupID((PeerGroupID)assignedID);
                    this.peerGroupAdvertisement.setModuleSpecID(this.implAdvertisement.getModuleSpecID());
                } else {
                    this.published = true;
                }
                if (this.configAdvertisement == null) {
                    PlatformConfig conf = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
                    conf.setPeerID(this.peerAdvertisement.getPeerID());
                    conf.setName(this.peerAdvertisement.getName());
                    conf.setDesc(this.peerAdvertisement.getDesc());
                    this.configAdvertisement = conf;
                }
                Hashtable<ID, StructuredDocument> grpParams = this.peerGroupAdvertisement.getServiceParams();
                Enumeration<ID> keys = grpParams.keys();
                while (keys.hasMoreElements()) {
                    ID key = keys.nextElement();
                    Element e = grpParams.get(key);
                    if (this.configAdvertisement.getServiceParam(key) != null) continue;
                    this.configAdvertisement.putServiceParam(key, e);
                }
                if (!globalRegistry.registerInstance((PeerGroupID)assignedID, this)) {
                    throw new PeerGroupException("Group already instantiated");
                }
            }
            catch (Throwable any) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Group init failed", any);
                }
                if (any instanceof Error) {
                    throw (Error)any;
                }
                if (any instanceof RuntimeException) {
                    throw (RuntimeException)any;
                }
                if (any instanceof PeerGroupException) {
                    throw (PeerGroupException)any;
                }
                throw new PeerGroupException("Group init failed", any);
            }
            ThreadGroup parentThreadGroup = null != this.parentGroup ? this.parentGroup.getHomeThreadGroup() : Thread.currentThread().getThreadGroup();
            this.threadGroup = new ThreadGroup(parentThreadGroup, "Group " + this.peerGroupAdvertisement.getPeerGroupID());
            this.taskQueue = new ArrayBlockingQueue<Runnable>(10);
            this.threadPool = new ThreadPoolExecutor(5, 100, 15L, TimeUnit.SECONDS, this.taskQueue, new PeerGroupThreadFactory("Executor", this.getHomeThreadGroup()), new CallerBlocksPolicy());
            try {
                Method allowCoreThreadTimeOut = this.threadPool.getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                allowCoreThreadTimeOut.invoke((Object)this.threadPool, Boolean.TRUE);
            }
            catch (Throwable ohWell) {
                if (!Logging.SHOW_FINEST || !LOG.isLoggable(Level.FINEST)) break block31;
                LOG.log(Level.FINEST, "Failed to enable 'allowCoreThreadTimeOut'", ohWell);
            }
        }
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new PeerGroupThreadFactory("Scheduled Executor", this.getHomeThreadGroup()));
    }

    protected void initLast() throws PeerGroupException {
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Group : " + this.getPeerGroupID());
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tModule Spec ID : ").append(this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tPeer Group ID : ").append(this.getPeerGroupID());
            configInfo.append("\n\t\tGroup Name : ").append(this.getPeerGroupName());
            configInfo.append("\n\t\tPeer ID in Group : ").append(this.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null == this.parentGroup) {
                configInfo.append("\n\t\tHome Group : (none)");
            } else {
                configInfo.append("\n\t\tHome Group : \"").append(this.parentGroup.getPeerGroupName()).append("\" / ").append(this.parentGroup.getPeerGroupID());
            }
            configInfo.append("\n\t\tServices :");
            for (Map.Entry<ModuleClassID, Service> anEntry : this.services.entrySet()) {
                ModuleClassID aMCID = anEntry.getKey();
                ModuleImplAdvertisement anImplAdv = (ModuleImplAdvertisement)anEntry.getValue().getImplAdvertisement();
                configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(anImplAdv.getDescription());
            }
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public int startApp(String[] arg) {
        return 0;
    }

    @Override
    public void stopApp() {
        this.stopping = true;
        ArrayList<ModuleClassID> allServices = new ArrayList<ModuleClassID>(this.services.keySet());
        for (ModuleClassID aService : allServices) {
            try {
                this.removeService(aService);
            }
            catch (Exception failure) {
                LOG.log(Level.WARNING, "Failure shutting down service : " + aService, failure);
            }
        }
        if (!this.services.isEmpty()) {
            LOG.warning(this.services.size() + " services could not be shut down during peer group stop.");
        }
        this.services.clear();
        globalRegistry.unRegisterInstance(this.peerGroupAdvertisement.getPeerGroupID(), this);
        if (this.parentGroup != null) {
            this.parentGroup.unref();
            this.parentGroup = null;
        }
        this.threadPool.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.initComplete = false;
    }

    @Override
    public void unref() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decRefCount() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            --this.masterRefCount;
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                Throwable trace = new Throwable("Stack Trace");
                StackTraceElement[] elements = trace.getStackTrace();
                LOG.info("[" + this.getPeerGroupID() + "] GROUP REF COUNT DECCREMENTED TO: " + this.masterRefCount + " by\n\t" + elements[2]);
            }
            if (this.masterRefCount != 0) {
                return;
            }
            if (!this.stopWhenUnreferenced) {
                return;
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("[" + this.getPeerGroupID() + "] STOPPING UNREFERENCED GROUP");
        }
        this.stopApp();
        this.masterRefCount = Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getInterface() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            ++this.masterRefCount;
            if (this.masterRefCount < 1) {
                throw new IllegalStateException("Group has been shutdown. getInterface() is not available");
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                Throwable trace = new Throwable("Stack Trace");
                StackTraceElement[] elements = trace.getStackTrace();
                LOG.info("[" + this.getPeerGroupID() + "] GROUP REF COUNT INCREMENTED TO: " + this.masterRefCount + " by\n\t" + elements[2]);
            }
            if (this.initComplete) {
                this.stopWhenUnreferenced = true;
            }
        }
        return new RefCountPeerGroupInterface(this);
    }

    @Override
    public PeerGroup getWeakInterface() {
        return new PeerGroupInterface(this);
    }

    @Override
    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement.clone();
    }

    @Override
    public void publishGroup(String name, String description) throws IOException {
        if (this.published) {
            return;
        }
        this.peerGroupAdvertisement.setName(name);
        this.peerGroupAdvertisement.setDescription(description);
        if (this.parentGroup == null) {
            return;
        }
        DiscoveryService parentDiscovery = this.parentGroup.getDiscoveryService();
        if (null == parentDiscovery) {
            return;
        }
        parentDiscovery.publish(this.peerGroupAdvertisement, 31536000000L, 1209600000L);
        this.published = true;
    }

    @Override
    public PeerGroup newGroup(Advertisement pgAdv) throws PeerGroupException {
        PeerGroup theNewGroup;
        PeerGroupAdvertisement adv;
        block5: {
            adv = (PeerGroupAdvertisement)pgAdv;
            PeerGroupID gid = adv.getPeerGroupID();
            if (gid == null || ID.nullID.equals(gid)) {
                throw new IllegalArgumentException("Advertisement did not contain a peer group ID");
            }
            theNewGroup = globalRegistry.lookupInstance(gid);
            if (theNewGroup != null) {
                return theNewGroup;
            }
            try {
                this.discovery.publish(adv, 31536000000L, 1209600000L);
            }
            catch (Exception any) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "Could not publish the group advertisement: ", any);
            }
        }
        theNewGroup = (PeerGroup)this.loadModule(adv.getPeerGroupID(), adv.getModuleSpecID(), 0, false);
        if (theNewGroup == null) {
            throw new PeerGroupException("Could not find group implementation with " + adv.getModuleSpecID());
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    @Override
    public PeerGroup newGroup(PeerGroupID gid, Advertisement impl, String name, String description) throws PeerGroupException {
        PeerGroup theNewGroup;
        block7: {
            theNewGroup = null;
            if (null != gid) {
                theNewGroup = globalRegistry.lookupInstance(gid);
            }
            if (theNewGroup != null) {
                return theNewGroup;
            }
            try {
                theNewGroup = (PeerGroup)this.loadModule((ID)gid, (ModuleImplAdvertisement)impl, false);
            }
            catch (Throwable any) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Could not load group implementation", any);
                }
                throw new PeerGroupException("Could not load group implementation", any);
            }
            try {
                theNewGroup.publishGroup(name, description);
            }
            catch (Exception any) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "Could not publish group or implementation:", any);
            }
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    @Override
    public PeerGroup newGroup(PeerGroupID gid) throws PeerGroupException {
        PeerGroupAdvertisement adv;
        if (gid == null || ID.nullID.equals(gid)) {
            throw new IllegalArgumentException("Invalid peer group ID");
        }
        PeerGroup result = globalRegistry.lookupInstance(gid);
        if (result != null) {
            return result;
        }
        try {
            adv = (PeerGroupAdvertisement)this.discoverOne(1, "GID", gid.toString(), 120, PeerGroupAdvertisement.class);
        }
        catch (Throwable any) {
            throw new PeerGroupException("Failed finding group advertisement for " + gid, any);
        }
        if (adv == null) {
            throw new PeerGroupException("Could not find group advertisement for group " + gid);
        }
        return this.newGroup(adv);
    }

    @Override
    public JxtaLoader getLoader() {
        return loader;
    }

    @Override
    public String getPeerName() {
        if (null == this.peerAdvertisement) {
            throw new IllegalStateException("PeerGroup not sufficiently initialized");
        }
        return this.peerAdvertisement.getName();
    }

    @Override
    public String getPeerGroupName() {
        if (null == this.peerGroupAdvertisement) {
            throw new IllegalStateException("PeerGroup not sufficiently initialized");
        }
        return this.peerGroupAdvertisement.getName();
    }

    @Override
    public PeerGroupID getPeerGroupID() {
        if (null == this.peerGroupAdvertisement) {
            throw new IllegalStateException("PeerGroup not sufficiently initialized");
        }
        return this.peerGroupAdvertisement.getPeerGroupID();
    }

    @Override
    public PeerID getPeerID() {
        if (null == this.peerAdvertisement) {
            throw new IllegalStateException("PeerGroup not sufficiently initialized");
        }
        return this.peerAdvertisement.getPeerID();
    }

    @Override
    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    @Override
    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        return this.peerGroupAdvertisement;
    }

    @Override
    public boolean isRendezvous() {
        if (this.rendezvous == null && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Rendezvous service null");
        }
        return this.rendezvous != null && this.rendezvous.isRendezVous();
    }

    @Override
    public EndpointService getEndpointService() {
        if (this.endpoint == null) {
            return null;
        }
        return (EndpointService)this.endpoint.getInterface();
    }

    @Override
    public ResolverService getResolverService() {
        if (this.resolver == null) {
            return null;
        }
        return (ResolverService)this.resolver.getInterface();
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        if (this.discovery == null) {
            return null;
        }
        return (DiscoveryService)this.discovery.getInterface();
    }

    @Override
    public PeerInfoService getPeerInfoService() {
        if (this.peerinfo == null) {
            return null;
        }
        return (PeerInfoService)this.peerinfo.getInterface();
    }

    @Override
    public MembershipService getMembershipService() {
        if (this.membership == null) {
            return null;
        }
        return (MembershipService)this.membership.getInterface();
    }

    @Override
    public PipeService getPipeService() {
        if (this.pipe == null) {
            return null;
        }
        return (PipeService)this.pipe.getInterface();
    }

    @Override
    public RendezVousService getRendezVousService() {
        if (this.rendezvous == null) {
            return null;
        }
        return (RendezVousService)this.rendezvous.getInterface();
    }

    @Override
    public AccessService getAccessService() {
        if (this.access == null) {
            return null;
        }
        return (AccessService)this.access.getInterface();
    }

    public Executor getExecutor() {
        return this.threadPool;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    static class PeerGroupThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String name;
        final ThreadGroup threadgroup;

        PeerGroupThreadFactory(String name, ThreadGroup threadgroup) {
            this.name = name;
            this.threadgroup = threadgroup;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.threadgroup, runnable, this.name + " - " + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static class CallerBlocksPolicy
    implements RejectedExecutionHandler {
        private CallerBlocksPolicy() {
        }

        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            while (!executor.isShutdown()) {
                executor.purge();
                try {
                    boolean pushed = queue.offer(runnable, 500L, TimeUnit.MILLISECONDS);
                    if (!pushed) continue;
                    break;
                }
                catch (InterruptedException woken) {
                    throw new RejectedExecutionException("Interrupted while attempting to enqueue", woken);
                }
            }
        }
    }
}

