/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerAdvertisement;

public class DiscoveryResponse
extends DiscoveryResponseMsg {
    private static final transient Logger LOG = Logger.getLogger(DiscoveryResponse.class.getName());
    private static final String countTag = "Count";
    private static final String expirationTag = "Expiration";
    private static final String peerAdvTag = "PeerAdv";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    private static final String responsesTag = "Response";
    private static final String typeTag = "Type";

    public DiscoveryResponse() {
    }

    public DiscoveryResponse(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        String docName = doc.getName();
        if (!DiscoveryResponse.getAdvertisementType().equals(docName)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + docName);
        }
        this.readIt(doc);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryResponse.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            ((XMLDocument)adv).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = adv.createElement(countTag, Integer.toString(this.responses.size()));
        adv.appendChild(e);
        e = adv.createElement(typeTag, Integer.toString(this.type));
        adv.appendChild(e);
        PeerAdvertisement myPeerAdv = this.getPeerAdvertisement();
        if (null != myPeerAdv) {
            e = adv.createElement(peerAdvTag, myPeerAdv.toString());
            adv.appendChild(e);
        }
        if (this.attr != null && this.attr.length() > 0) {
            e = adv.createElement(queryAttrTag, this.getQueryAttr());
            adv.appendChild(e);
            if (this.value != null && this.value.length() > 0) {
                e = adv.createElement(queryValueTag, this.value);
                adv.appendChild(e);
            }
        }
        Enumeration<String> advs = this.getResponses();
        Enumeration<Long> exps = this.getExpirations();
        try {
            while (advs.hasMoreElements()) {
                Long l = exps.nextElement();
                String response = advs.nextElement();
                e = adv.createElement(responsesTag, response);
                adv.appendChild(e);
                if (!(adv instanceof Attributable)) continue;
                ((Attributable)e).addAttribute(expirationTag, l.toString());
            }
        }
        catch (Exception failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Got an Exception during doc creation", failed);
            }
            IllegalStateException failure = new IllegalStateException("Got an Exception during doc creation");
            failure.initCause(failed);
            throw failure;
        }
        return adv;
    }

    private void readIt(XMLElement doc) {
        Vector<String> res = new Vector<String>();
        Vector<Long> exps = new Vector<Long>();
        try {
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                long exp;
                XMLElement elem = (XMLElement)elements.nextElement();
                if (elem.getName().equals(typeTag)) {
                    this.type = Integer.parseInt(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(peerAdvTag)) {
                    String peerString = elem.getTextValue();
                    if (null == peerString || (peerString = peerString.trim()).length() <= 0) continue;
                    XMLDocument xmlPeerAdv = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(peerString));
                    this.setPeerAdvertisement((PeerAdvertisement)AdvertisementFactory.newAdvertisement(xmlPeerAdv));
                    continue;
                }
                if (elem.getName().equals(queryAttrTag)) {
                    this.setQueryAttr(elem.getTextValue());
                    continue;
                }
                if (elem.getName().equals(queryValueTag)) {
                    this.setQueryValue(elem.getTextValue());
                    continue;
                }
                if (!elem.getName().equals(responsesTag)) continue;
                String aResponse = elem.getTextValue();
                if (null == aResponse) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Discarding an empty response tag");
                    continue;
                }
                res.add(aResponse);
                Attribute attr = elem.getAttribute(expirationTag);
                if (null != attr) {
                    exp = Long.parseLong(attr.getValue());
                } else {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Received an old-style DiscoveryResponse.\n You received a response from a peer that does \nnot support advertisement aging. \nSetting expiration to DiscoveryService.DEFAULT_EXPIRATION ");
                    }
                    exp = 0x6DDD00L;
                }
                exps.add(exp);
            }
        }
        catch (Exception failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Got an Exception during Parse ", failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Got an Exception during parse");
            failure.initCause(failed);
            throw failure;
        }
        this.setResponses(res);
        this.setExpirations(exps);
    }

    public String toString() {
        try {
            XMLDocument doc = (XMLDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

