/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.protocol.PeerAdvertisement;

public class LeaseRequestMsg {
    private static final transient Logger LOG = Logger.getLogger(LeaseRequestMsg.class.getName());
    private static final String LEASE_REQUEST_MSG = "LeaseRequestMessage";
    private static final String CLIENT_ID_ATTR = "client_id";
    private static final String REQUESTED_LEASE_ATTR = "requested_lease";
    private static final String SERVER_ADV_GEN_ATTR = "server_adv_gen";
    private static final String REFERRAL_ADVS_ATTR = "referral_advs";
    private static final String CLIENT_CRED_TAG = "Credential";
    private static final String CLIENT_ADV_TAG = "ClientAdv";
    private static final String CLIENT_ADV_EXP_ATTR = "ClientAdv";
    private static final String OPTION_TAG = "Options";
    private ID clientID = null;
    private long requestedLease = Long.MIN_VALUE;
    private UUID serverAdvGen = null;
    private int referralAdvs = Integer.MIN_VALUE;
    private XMLElement credential = null;
    private PeerAdvertisement clientAdv = null;
    private long clientAdvExp = Integer.MIN_VALUE;
    private List options = new ArrayList();

    public LeaseRequestMsg() {
    }

    public LeaseRequestMsg(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doc.getName().equals(LeaseRequestMsg.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + LeaseRequestMsg.getMessageType());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aLeaseReqAttr = eachAttr.nextElement();
            if (REQUESTED_LEASE_ATTR.equals(aLeaseReqAttr.getName())) {
                this.requestedLease = Long.valueOf(aLeaseReqAttr.getValue());
                continue;
            }
            if (SERVER_ADV_GEN_ATTR.equals(aLeaseReqAttr.getName())) {
                this.serverAdvGen = UUID.fromString(aLeaseReqAttr.getValue());
                continue;
            }
            if (CLIENT_ID_ATTR.equals(aLeaseReqAttr.getName())) {
                try {
                    URI srcURI = new URI(aLeaseReqAttr.getValue());
                    ID srcID = IDFactory.fromURI(srcURI);
                    this.setClientID(srcID);
                    continue;
                }
                catch (URISyntaxException badID) {
                    IllegalArgumentException iae = new IllegalArgumentException("Bad ID in message");
                    iae.initCause(badID);
                    throw iae;
                }
            }
            if ("type".equals(aLeaseReqAttr.getName()) || "xmlns:jxta".equals(aLeaseReqAttr.getName()) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + aLeaseReqAttr.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem.toString());
        }
        if (null == this.getClientID()) {
            throw new IllegalArgumentException("Missing client ID value.");
        }
        if (this.getRequestedLease() < 0L && this.getRequestedLease() != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid requested lease duration.");
        }
        if (this.getReferralAdvs() < 0 && this.getReferralAdvs() != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid referral advertisements request value.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LeaseRequestMsg clone = (LeaseRequestMsg)super.clone();
        clone.setClientID(this.getClientID());
        clone.setServerAdvGen(this.getServerAdvGen());
        clone.setRequestedLease(this.getRequestedLease());
        clone.setReferralAdvs(this.getReferralAdvs());
        clone.setCredential(this.getCredential());
        return clone;
    }

    public ID getClientID() {
        return this.clientID;
    }

    public void setClientID(ID clientID) {
        this.clientID = clientID;
    }

    public UUID getServerAdvGen() {
        return this.serverAdvGen;
    }

    public void setServerAdvGen(UUID serverAdvGen) {
        this.serverAdvGen = serverAdvGen;
    }

    public long getRequestedLease() {
        return this.requestedLease;
    }

    public void setRequestedLease(long requestedLease) {
        this.requestedLease = requestedLease;
    }

    public int getReferralAdvs() {
        return this.referralAdvs;
    }

    public void setReferralAdvs(int referralAdvs) {
        this.referralAdvs = referralAdvs;
    }

    public XMLElement getCredential() {
        return (XMLElement)((Object)(null != this.credential ? StructuredDocumentUtils.copyAsDocument(this.credential) : null));
    }

    public void setCredential(XMLElement newCred) {
        this.credential = (XMLElement)((Object)(null != newCred ? StructuredDocumentUtils.copyAsDocument(newCred) : null));
    }

    public static String getMessageType() {
        return "jxta:LeaseRequestMsg";
    }

    protected boolean handleElement(XMLElement elem) {
        if (CLIENT_CRED_TAG.equals(elem.getName())) {
            this.credential = (XMLElement)((Object)StructuredDocumentUtils.copyAsDocument(elem));
            return true;
        }
        String value = elem.getTextValue();
        if (null != value && 0 == (value = value.trim()).length()) {
            value = null;
        }
        if (null == value) {
            return false;
        }
        return false;
    }

    public Document getDocument(MimeMediaType mediaType) {
        if (null == this.getClientID()) {
            throw new IllegalStateException("Missing client ID value.");
        }
        if (this.getRequestedLease() < 0L && this.getRequestedLease() != Long.MIN_VALUE) {
            throw new IllegalStateException("Invalid requested lease duration.");
        }
        if (this.getReferralAdvs() < 0 && this.getReferralAdvs() != Integer.MIN_VALUE) {
            throw new IllegalStateException("Invalid referral advertisements request value.");
        }
        StructuredDocument msg = StructuredDocumentFactory.newStructuredDocument(mediaType, LeaseRequestMsg.getMessageType());
        if (!(msg instanceof Attributable)) {
            throw new UnsupportedOperationException("Only 'Attributable' document types are supported.");
        }
        if (msg instanceof XMLDocument) {
            ((XMLDocument)msg).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        ((Attributable)((Object)msg)).addAttribute(CLIENT_ID_ATTR, this.getClientID().toString());
        if (Long.MIN_VALUE != this.getRequestedLease()) {
            ((Attributable)((Object)msg)).addAttribute(REQUESTED_LEASE_ATTR, Long.toString(this.getRequestedLease()));
        }
        if (null != this.getServerAdvGen()) {
            ((Attributable)((Object)msg)).addAttribute(SERVER_ADV_GEN_ATTR, this.getServerAdvGen().toString());
        }
        if (null != this.credential) {
            StructuredDocumentUtils.copyElements(msg, msg, this.credential, CLIENT_CRED_TAG);
        }
        return msg;
    }
}

