/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.adhoc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdhocPeerRdvService
extends RendezVousServiceProvider {
    private static final transient Logger LOG = Logger.getLogger(AdhocPeerRdvService.class.getName());
    private static final int DEFAULT_MAX_TTL = 2;

    public AdhocPeerRdvService(PeerGroup g, RendezVousServiceImpl rdvService) {
        super(g, rdvService);
        ConfigParams confAdv = g.getConfigAdvertisement();
        if (confAdv != null) {
            RdvConfigAdv rdvConfigAdv;
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                if (null != configDoc) {
                    configDoc.addAttribute("type", RdvConfigAdv.getAdvertisementType());
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
            this.MAX_TTL = adv instanceof RdvConfigAdv ? (-1 != (rdvConfigAdv = (RdvConfigAdv)adv).getMaxTTL() ? rdvConfigAdv.getMaxTTL() : 2) : 2;
        } else {
            this.MAX_TTL = 2;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("RendezVous Service is initialized for " + g.getPeerGroupID() + " as an ad hoc peer. ");
        }
    }

    @Override
    protected int startApp(String[] arg) {
        super.startApp(arg);
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.startEdge();
        }
        this.rdvService.generateEvent(9, this.group.getPeerID());
        return 0;
    }

    @Override
    public synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.stopApp();
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.stopEdge();
        }
    }

    @Override
    public Vector<ID> getConnectedPeerIDs() {
        return new Vector<ID>(0);
    }

    @Override
    public boolean isConnectedToRendezVous() {
        return true;
    }

    @Override
    public void connectToRendezVous(EndpointAddress addr, Object hint) throws IOException {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    @Override
    public void challengeRendezVous(ID peer, long delay) {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    @Override
    public void disconnectFromRendezVous(ID peerId) {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        }
    }

    @Override
    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void propagate(Enumeration<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) {
        ttl = Math.min(ttl, this.MAX_TTL);
        propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null == propHdr) return;
        numPeers = 0;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if (!destPeerIDs.hasMoreElements()) {
                    var13_12 = null;
                    if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING == false) return;
                    if (this.rendezvousMeter == null) return;
                    this.rendezvousMeter.propagateToPeers(numPeers);
                    return;
                }
                dest = destPeerIDs.nextElement();
                if (Logging.SHOW_FINE && AdhocPeerRdvService.LOG.isLoggable(Level.FINE)) {
                    AdhocPeerRdvService.LOG.fine("Sending " + msg + " to client " + dest);
                }
                if (null == (messenger = this.rdvService.endpoint.getMessenger(addr = AdhocPeerRdvService.mkAddress(dest, "JxtaPropagate", this.PropPName)))) continue;
                try {
                    messenger.sendMessage(msg);
                    ++numPeers;
                }
                catch (IOException failed) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable var12_14) {
            var13_13 = null;
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING == false) throw var12_14;
            if (this.rendezvousMeter == null) throw var12_14;
            this.rendezvousMeter.propagateToPeers(numPeers);
            throw var12_14;
        }
        ** GOTO lbl-1000
    }

    @Override
    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            try {
                this.sendToNetwork(msg, propHdr);
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.propagateToNeighbors();
                }
            }
            catch (IOException failed) {
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                    this.rendezvousMeter.propagateToNeighborsFailed();
                }
                throw failed;
            }
        }
    }

    @Override
    public void walk(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
    }

    @Override
    public void walk(Vector<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        this.propagate(destPeerIDs.elements(), msg, serviceName, serviceParam, ttl);
    }

    @Override
    protected void repropagate(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam) {
        block8: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Repropagating " + msg + " (" + propHdr.getMsgId() + ")");
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.receivedMessageRepropagatedInGroup();
            }
            try {
                propHdr = this.updatePropHeader(msg, propHdr, serviceName, serviceParam, this.MAX_TTL);
                if (null != propHdr) {
                    this.sendToNetwork(msg, propHdr);
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No propagate header, declining to repropagate " + msg + ")");
                }
            }
            catch (Exception ez1) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                if (propHdr != null) {
                    LOG.log(Level.WARNING, "Failed to repropagate " + msg + " (" + propHdr.getMsgId() + ")", ez1);
                }
                LOG.log(Level.WARNING, "Could to repropagate " + msg, ez1);
            }
        }
    }
}

