/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RendezvousConnectionMetric
implements DocumentSerializable {
    public static final String CONNECTING = "connecting";
    public static final String CONNECTED = "connected";
    public static final String DISCONNECTED = "disconnected";
    public static final String REFUSED = "refused";
    private PeerID peerID;
    private String state = null;
    private long transitionTime;
    private long lease;
    private int numConnectionsBegun = 0;
    private int numConnectionsEstablished = 0;
    private int numConnectionsRefused = 0;
    private long totalTimesToConnect;
    private long totalTimeConnected;
    private long lastLeaseRenewalTime;
    private int numLeaseRenewals;
    private int numDisconnects;

    public RendezvousConnectionMetric() {
    }

    public RendezvousConnectionMetric(PeerID peerID) {
        this.peerID = peerID;
        this.state = DISCONNECTED;
    }

    public RendezvousConnectionMetric(RendezvousConnectionMetric prototype) {
        this.peerID = prototype.peerID;
        this.state = prototype.state;
        this.transitionTime = prototype.transitionTime;
        this.lastLeaseRenewalTime = prototype.lastLeaseRenewalTime;
        this.lease = prototype.lease;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public String getState() {
        return this.state;
    }

    public long getTransitionTime() {
        return this.transitionTime;
    }

    public boolean isConnecting() {
        return this.state != null && this.state.equals(CONNECTING);
    }

    public long getBeginConnectionTime() {
        return this.isConnecting() ? this.transitionTime : 0L;
    }

    public boolean isConnected() {
        return this.state != null && this.state.equals(CONNECTED);
    }

    public long getTimeConnectionEstablished() {
        return this.isConnected() ? this.transitionTime : 0L;
    }

    public long getLease() {
        return this.lease;
    }

    public int getNumConnectionsBegun() {
        return this.numConnectionsBegun;
    }

    public int getNumConnectionsEstablished() {
        return this.numConnectionsEstablished;
    }

    public int getNumConnectionsRefused() {
        return this.numConnectionsRefused;
    }

    public long getTotalTimesToConnect() {
        return this.totalTimesToConnect;
    }

    public long getLastLeaseRenewalTime() {
        return this.lastLeaseRenewalTime;
    }

    public int getNumLeaseRenewals() {
        return this.numLeaseRenewals;
    }

    public int getNumDisconnects() {
        return this.numDisconnects;
    }

    public long getDisconnectTime() {
        return this.isDisconnected() ? this.transitionTime : 0L;
    }

    public boolean isDisconnected() {
        return this.state != null && (this.state.equals(DISCONNECTED) || this.state.equals(REFUSED));
    }

    public long getTotalTimeConnected() {
        return this.totalTimeConnected;
    }

    public long getTotalTimeConnected(long adjustmentTime) {
        long result = this.totalTimeConnected;
        if (this.isConnected()) {
            result += adjustmentTime - this.transitionTime;
        }
        return result;
    }

    public long getTimeConnected() {
        return this.getTimeConnected(System.currentTimeMillis());
    }

    public long getTimeConnected(long adjustmentTime) {
        if (this.isConnected()) {
            return adjustmentTime - this.transitionTime;
        }
        return 0L;
    }

    private void resetState(String state, long transitionTime) {
        if (this.isConnected()) {
            this.totalTimeConnected += System.currentTimeMillis() - this.transitionTime;
        }
        this.state = state;
        this.transitionTime = transitionTime;
    }

    void beginConnection(long transitionTime) {
        this.resetState(CONNECTING, transitionTime);
        ++this.numConnectionsBegun;
    }

    void connectionEstablished(long transitionTime, long timeToConnectTime, long lease) {
        this.resetState(CONNECTED, transitionTime);
        this.totalTimesToConnect += timeToConnectTime;
        ++this.numConnectionsEstablished;
        this.lease = lease;
    }

    void leaseRenewed(long lastLeaseRenewalTime, long lease) {
        ++this.numLeaseRenewals;
        this.lastLeaseRenewalTime = lastLeaseRenewalTime;
        this.lease = lease;
        if (!this.isConnected()) {
            this.resetState(CONNECTED, lastLeaseRenewalTime);
        }
    }

    void connectionRefused(long transitionTime) {
        this.resetState(REFUSED, this.lastLeaseRenewalTime);
        ++this.numConnectionsRefused;
    }

    void connectionDisconnected(long transitionTime) {
        this.resetState(DISCONNECTED, this.lastLeaseRenewalTime);
        ++this.numDisconnects;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RendezvousConnectionMetric) {
            RendezvousConnectionMetric other = (RendezvousConnectionMetric)obj;
            return this.peerID.equals(other.peerID);
        }
        return false;
    }

    public int hashCode() {
        return this.peerID.hashCode();
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.peerID != null) {
            DocumentSerializableUtilities.addString(element2, "peerID", this.peerID.toString());
        }
        if (this.state != null) {
            DocumentSerializableUtilities.addString(element2, "state", this.state);
        }
        if (this.transitionTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "transitionTime", this.transitionTime);
        }
        if (this.lease != 0L) {
            DocumentSerializableUtilities.addLong(element2, "lease", this.lease);
        }
        if (this.numConnectionsBegun != 0) {
            DocumentSerializableUtilities.addInt(element2, "numConnectionsBegun", this.numConnectionsBegun);
        }
        if (this.numConnectionsEstablished != 0) {
            DocumentSerializableUtilities.addInt(element2, "numConnectionsEstablished", this.numConnectionsEstablished);
        }
        if (this.numConnectionsRefused != 0) {
            DocumentSerializableUtilities.addInt(element2, "numConnectionsRefused", this.numConnectionsRefused);
        }
        if (this.totalTimesToConnect != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalTimesToConnect", this.totalTimesToConnect);
        }
        if (this.totalTimeConnected != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalTimeConnected", this.totalTimeConnected);
        }
        if (this.lastLeaseRenewalTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "lastLeaseRenewalTime", this.lastLeaseRenewalTime);
        }
        if (this.numLeaseRenewals != 0) {
            DocumentSerializableUtilities.addInt(element2, "numLeaseRenewals", this.numLeaseRenewals);
        }
        if (this.numDisconnects != 0) {
            DocumentSerializableUtilities.addInt(element2, "numDisconnects", this.numDisconnects);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("peerID")) {
                String peerIDText = DocumentSerializableUtilities.getString(childElement);
                this.peerID = MetricUtilities.getPeerIdFromString(peerIDText);
                continue;
            }
            if (tagName.equals("state")) {
                this.state = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("transitionTime")) {
                this.transitionTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("lease")) {
                this.lease = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numConnectionsBegun")) {
                this.numConnectionsBegun = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numConnectionsEstablished")) {
                this.numConnectionsEstablished = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numConnectionsRefused")) {
                this.numConnectionsRefused = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("totalTimesToConnect")) {
                this.totalTimesToConnect = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("totalTimeConnected")) {
                this.totalTimeConnected = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("lastLeaseRenewalTime")) {
                this.lastLeaseRenewalTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numLeaseRenewals")) {
                this.numLeaseRenewals = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("numDisconnects")) continue;
            this.numDisconnects = DocumentSerializableUtilities.getInt(childElement);
        }
    }

    public void mergeMetrics(RendezvousConnectionMetric otherRendezvousConnectionMetric) {
        if (otherRendezvousConnectionMetric == null) {
            return;
        }
        if (otherRendezvousConnectionMetric.state != null) {
            this.state = otherRendezvousConnectionMetric.state;
        }
        if (otherRendezvousConnectionMetric.transitionTime != 0L) {
            this.transitionTime = otherRendezvousConnectionMetric.transitionTime;
        }
        if (otherRendezvousConnectionMetric.lastLeaseRenewalTime != 0L) {
            this.lastLeaseRenewalTime = otherRendezvousConnectionMetric.transitionTime;
        }
        this.lease = otherRendezvousConnectionMetric.lease;
        this.numConnectionsBegun += otherRendezvousConnectionMetric.numConnectionsBegun;
        this.numConnectionsEstablished += otherRendezvousConnectionMetric.numConnectionsEstablished;
        this.numConnectionsRefused += otherRendezvousConnectionMetric.numConnectionsRefused;
        this.totalTimeConnected += otherRendezvousConnectionMetric.totalTimeConnected;
        this.numLeaseRenewals += otherRendezvousConnectionMetric.numLeaseRenewals;
        this.numDisconnects += otherRendezvousConnectionMetric.numDisconnects;
    }
}

