/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMetric;

public class RendezvousMeter {
    private RendezvousMetric cumulativeMetrics;
    private RendezvousMetric deltaMetrics;
    private long transitionTime = System.currentTimeMillis();

    public RendezvousMeter() {
        this.cumulativeMetrics = new RendezvousMetric(null);
    }

    public RendezvousMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public synchronized RendezvousMetric collectMetrics() {
        RendezvousMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new RendezvousMetric(this.cumulativeMetrics);
    }

    public String toString() {
        return "RendezvousMeter";
    }

    public void startEdge() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.transitionTime = System.currentTimeMillis();
        this.deltaMetrics.startEdge(this.transitionTime);
        this.cumulativeMetrics.startEdge(this.transitionTime);
    }

    public void stopEdge() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        long timeAsEdge = now - this.transitionTime;
        this.transitionTime = now;
        if (!this.cumulativeMetrics.isEdge()) {
            timeAsEdge = 0L;
        }
        this.deltaMetrics.stopEdge(now, timeAsEdge);
        this.cumulativeMetrics.stopEdge(now, timeAsEdge);
    }

    public void startRendezvous() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.transitionTime = System.currentTimeMillis();
        this.deltaMetrics.startRendezvous(this.transitionTime);
        this.cumulativeMetrics.startRendezvous(this.transitionTime);
    }

    public void stopRendezvous() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        long timeAsRendezvous = this.cumulativeMetrics.isRendezvous() ? now - this.transitionTime : 0L;
        this.transitionTime = now;
        this.deltaMetrics.stopRendezvous(now, timeAsRendezvous);
        this.cumulativeMetrics.stopRendezvous(now, timeAsRendezvous);
    }

    public void invalidMessageReceived() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.invalidMessageReceived();
        this.cumulativeMetrics.invalidMessageReceived();
    }

    public void receivedMessageProcessedLocally() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receivedMessageProcessedLocally();
        this.cumulativeMetrics.receivedMessageProcessedLocally();
    }

    public void receivedMessageRepropagatedInGroup() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receivedMessageRepropagatedInGroup();
        this.cumulativeMetrics.receivedMessageRepropagatedInGroup();
    }

    public void receivedDeadMessage() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receivedDeadMessage();
        this.cumulativeMetrics.receivedDeadMessage();
    }

    public void receivedLoopbackMessage() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receivedLoopbackMessage();
        this.cumulativeMetrics.receivedLoopbackMessage();
    }

    public void receivedDuplicateMessage() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receivedDuplicateMessage();
        this.cumulativeMetrics.receivedDuplicateMessage();
    }

    public void propagateToPeers(int numPeers) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.propagateToPeers(numPeers);
        this.cumulativeMetrics.propagateToPeers(numPeers);
    }

    public void propagateToNeighbors() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.propagateToNeighbors();
        this.cumulativeMetrics.propagateToNeighbors();
    }

    public void propagateToNeighborsFailed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.propagateToNeighborsFailed();
        this.cumulativeMetrics.propagateToNeighborsFailed();
    }

    public void propagateToGroup() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.propagateToGroup();
        this.cumulativeMetrics.propagateToGroup();
    }

    public void walk() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.walk();
        this.cumulativeMetrics.walk();
    }

    public void walkFailed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.walkFailed();
        this.cumulativeMetrics.walkFailed();
    }

    public void walkToPeers(int numPeers) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.walkToPeers(numPeers);
        this.cumulativeMetrics.walkToPeers(numPeers);
    }

    public void walkToPeersFailed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.walkToPeersFailed();
        this.cumulativeMetrics.walkToPeersFailed();
    }
}

