/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.resolver.resolverMeter.QueryHandlerMeter;
import net.jxta.impl.resolver.resolverMeter.ResolverMetric;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitor;
import net.jxta.impl.resolver.resolverMeter.SrdiHandlerMeter;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;

public class ResolverMeter {
    private ResolverServiceMonitor resolverServiceMonitor;
    private ResolverMetric cumulativeMetrics;
    private ResolverMetric deltaMetrics;

    public ResolverMeter(ResolverServiceMonitor resolverServiceMonitor) {
        this.resolverServiceMonitor = resolverServiceMonitor;
        this.cumulativeMetrics = new ResolverMetric();
    }

    public ResolverMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public synchronized ResolverMetric collectMetrics() {
        ResolverMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new ResolverMetric();
    }

    public String toString() {
        return "ResolverMeter";
    }

    public void invalidSrdiMessageDiscarded(EndpointAddress src) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.invalidSrdiMessageDiscarded();
        this.cumulativeMetrics.invalidSrdiMessageDiscarded();
    }

    public void unknownHandlerForSrdiMessage(EndpointAddress src, String handlerName) {
        if (handlerName != null) {
            SrdiHandlerMeter srdiHandlerMeter = this.resolverServiceMonitor.getSrdiHandlerMeter(handlerName);
            srdiHandlerMeter.srdiToUnregisteredHandler(src);
        } else {
            this.invalidSrdiDiscarded();
        }
    }

    public void invalidSrdiDiscarded() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.invalidResponseDiscarded();
        this.cumulativeMetrics.invalidResponseDiscarded();
    }

    public void invalidResponseDiscarded(EndpointAddress src) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.invalidResponseDiscarded();
        this.cumulativeMetrics.invalidResponseDiscarded();
    }

    public void unknownHandlerForResponse(EndpointAddress src, ResolverResponseMsg resp) {
        String handlerName = resp.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.responseToUnregisteredHandler(src);
        } else {
            this.invalidResponseDiscarded(src);
        }
    }

    public void invalidQueryDiscarded(EndpointAddress src) {
        this.invalidQueryDiscarded();
    }

    public void invalidQueryDiscarded() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.invalidQueryDiscarded();
        this.cumulativeMetrics.invalidQueryDiscarded();
    }

    public void unknownHandlerForQuery(ResolverQueryMsg query) {
        String handlerName = query.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.queryToUnregisteredHandler(query);
        } else {
            this.invalidQueryDiscarded();
        }
    }

    public void queryPropagatedInGroup(ResolverQueryMsg query) {
        String handlerName = query.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.queryPropagatedInGroup();
        } else {
            this.invalidQueryDiscarded();
        }
    }

    public void queryPropagatedViaWalker(ResolverQueryMsg query) {
        String handlerName = query.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.queryPropagatedViaWalker();
        } else {
            this.invalidQueryDiscarded();
        }
    }

    public void propagationQueryDropped(ResolverQueryMsg query) {
        String handlerName = query.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.propagationQueryDropped();
        } else {
            this.invalidQueryDiscarded();
        }
    }

    public void queryPropagationError(ResolverQueryMsg query) {
        String handlerName = query.getHandlerName();
        if (handlerName != null) {
            QueryHandlerMeter queryHandlerMeter = this.resolverServiceMonitor.getQueryHandlerMeter(handlerName);
            queryHandlerMeter.unableToPropagate();
        } else {
            this.invalidQueryDiscarded();
        }
    }
}

