/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BASE64InputStream
extends InputStream {
    private Reader source;
    private boolean closed = false;
    private boolean atEOF = false;
    private byte[] buffer = new byte[3];
    private byte inBuffer = (byte)3;

    public BASE64InputStream(Reader source) {
        this.source = source;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream closed.");
        }
        int bufferAvail = this.buffer.length - this.inBuffer;
        return bufferAvail > 0 ? bufferAvail : (this.source.ready() ? 1 : 0);
    }

    public void close() throws IOException {
        this.closed = true;
        this.source.close();
        this.source = null;
    }

    public void mark(int readLimit) {
        throw new IllegalStateException("Mark not supported.");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream closed.");
        }
        while (!this.atEOF) {
            int s0;
            if (this.inBuffer < this.buffer.length) {
                byte by = this.inBuffer;
                this.inBuffer = (byte)(by + 1);
                return this.buffer[by] & 0xFF;
            }
            this.inBuffer = 0;
            while (-1 != (s0 = this.source.read()) && Character.isWhitespace((char)s0)) {
            }
            if (-1 == s0) {
                this.atEOF = true;
                break;
            }
            int s1 = this.source.read();
            int s2 = this.source.read();
            int s3 = this.source.read();
            if (-1 == s1 || -1 == s2 || -1 == s3) {
                throw new IOException("Unexpected EOF");
            }
            int c0 = BASE64InputStream.decodeSixBits((char)s0);
            int c1 = BASE64InputStream.decodeSixBits((char)s1);
            int c2 = BASE64InputStream.decodeSixBits((char)s2);
            int c3 = BASE64InputStream.decodeSixBits((char)s3);
            if (-1 == c0 || -1 == c1 || -1 == c2 || -1 == c3) {
                throw new IOException("Bad character in BASE64 data");
            }
            if (Integer.MAX_VALUE == c0) {
                throw new IOException("'=' found in first position of BASE64 data");
            }
            if (Integer.MAX_VALUE == c1) {
                throw new IOException("'=' found in second position of BASE64 data");
            }
            if (Integer.MAX_VALUE == c3) {
                c3 = 0;
                this.inBuffer = (byte)(this.inBuffer + 1);
            }
            if (Integer.MAX_VALUE == c2) {
                c2 = 0;
                this.inBuffer = (byte)(this.inBuffer + 1);
            }
            int val = (c0 << 18) + (c1 << 12) + (c2 << 6) + c3;
            this.buffer[this.inBuffer] = (byte)(val >> 16);
            if (this.inBuffer + 1 < this.buffer.length) {
                this.buffer[this.inBuffer + 1] = (byte)(val >> 8);
            }
            if (this.inBuffer + 2 >= this.buffer.length) continue;
            this.buffer[this.inBuffer + 2] = (byte)val;
        }
        return -1;
    }

    private static int decodeSixBits(char c) {
        int v = 'A' <= c && c <= 'Z' ? c - 65 : ('a' <= c && c <= 'z' ? c - 97 + 26 : ('0' <= c && c <= '9' ? c - 48 + 52 : (c == '+' ? 62 : (c == '/' ? 63 : (c == '=' ? Integer.MAX_VALUE : -1)))));
        return v;
    }
}

