/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.logging.Logging;

public class JxtaHash {
    private static final Logger LOG = Logger.getLogger(JxtaHash.class.getName());
    public static final String SHA = "SHA";
    public static final String SHA1 = "SHA1";
    public static final String MD2 = "MD2";
    public static final String MD5 = "MD5";
    public static final String DSA = "DSA";
    public static final String RSA = "RSA";
    public static final String SHA1withDSA = "SHA1WITHDSA";
    private MessageDigest dig;

    public JxtaHash() {
        block2: {
            this.dig = null;
            try {
                this.dig = MessageDigest.getInstance(SHA1);
            }
            catch (NoSuchAlgorithmException ex) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine(ex.toString());
            }
        }
    }

    public JxtaHash(String expression) {
        this(SHA1, expression);
    }

    @Deprecated
    public JxtaHash(String algorithm, String expression) {
        this(algorithm, expression.getBytes());
    }

    public JxtaHash(String algorithm, byte[] expression) {
        block3: {
            this.dig = null;
            try {
                this.dig = MessageDigest.getInstance(algorithm);
                if (expression != null) {
                    this.dig.update(expression);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine(ex.toString());
            }
        }
    }

    public void update(String expression) {
        if (expression != null) {
            this.dig.update(expression.getBytes());
        }
    }

    public BigInteger getDigestInteger() {
        return new BigInteger(this.dig.digest());
    }

    public BigInteger getDigestInteger(byte[] expression) {
        this.dig.reset();
        this.dig.update(expression);
        return new BigInteger(this.dig.digest());
    }

    public BigInteger getDigestInteger(String expression) {
        return this.getDigestInteger(expression.getBytes());
    }

    public int mod(long m) {
        BigInteger bi = this.getDigestInteger();
        BigInteger mod = new BigInteger(this.longToBytes(m));
        BigInteger result = bi.mod(mod);
        return result.intValue();
    }

    private byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int eachByte = 0; eachByte < 8; ++eachByte) {
            bytes[eachByte] = (byte)(value >> (int)((long)(7 - eachByte) * 8L));
        }
        return bytes;
    }
}

