/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

public final class TimeUtils {
    public static final long ZEROMILLISECONDS = 0L;
    public static final long AMILLISECOND = 1L;
    public static final long AHUNDREDTHOFASECOND = 10L;
    public static final long ATENTHOFASECOND = 100L;
    public static final long ASECOND = 1000L;
    public static final long AMINUTE = 60000L;
    public static final long ANHOUR = 3600000L;
    public static final long ADAY = 86400000L;
    public static final long AWEEK = 604800000L;
    public static final long AFORTNIGHT = 1209600000L;
    public static final long AJANUARY = 2678400000L;
    public static final long AFEBRUARY = 2419200000L;
    public static final long ALEAPFEBRUARY = 2505600000L;
    public static final long AMARCH = 2678400000L;
    public static final long ANAPRIL = 2592000000L;
    public static final long AMAY = 2678400000L;
    public static final long AJUNE = 2592000000L;
    public static final long AJULY = 2678400000L;
    public static final long ANAUGUST = 2678400000L;
    public static final long ASEPTEMBER = 2592000000L;
    public static final long ANOCTOBER = 2678400000L;
    public static final long ANOVEMBER = 2592000000L;
    public static final long ADECEMBER = 2678400000L;
    public static final long AYEAR = 31536000000L;
    public static final long ALEAPYEAR = 31622400000L;
    static volatile long TIMEWARP = 0L;
    static long WARPBEGAN = 0L;
    static double WARPFACTOR = 1.0;

    private TimeUtils() {
    }

    public static long timeNow() {
        long now = System.currentTimeMillis();
        if (WARPFACTOR != 1.0) {
            long elapsed = now - WARPBEGAN;
            long dialation = (long)((double)elapsed * WARPFACTOR);
            TIMEWARP += dialation - elapsed;
        }
        return now + TIMEWARP;
    }

    public static long toAbsoluteTimeMillis(long duration) {
        return TimeUtils.toAbsoluteTimeMillis(duration, TimeUtils.timeNow());
    }

    public static long toAbsoluteTimeMillis(long duration, long fromWhen) {
        if (Long.MAX_VALUE == duration) {
            return Long.MAX_VALUE;
        }
        if (Long.MIN_VALUE == duration) {
            return Long.MIN_VALUE;
        }
        long whence = fromWhen + duration;
        if (duration > 0L) {
            if (whence < fromWhen) {
                whence = Long.MAX_VALUE;
            }
        } else if (whence > fromWhen) {
            whence = Long.MIN_VALUE;
        }
        return whence;
    }

    public static long toRelativeTimeMillis(long whence) {
        return TimeUtils.toRelativeTimeMillis(whence, TimeUtils.timeNow());
    }

    public static long toRelativeTimeMillis(long whence, long fromWhen) {
        if (Long.MAX_VALUE == whence) {
            return Long.MAX_VALUE;
        }
        if (Long.MIN_VALUE == whence) {
            return Long.MIN_VALUE;
        }
        return whence - fromWhen;
    }

    public static long multiplyRelativeTimeMillis(long duration, long multiplier) {
        if (multiplier < 0L) {
            throw new IllegalArgumentException("Only non-negative multipliers are allowed.");
        }
        long result_mag = Long.MIN_VALUE != duration ? Long.highestOneBit(Math.abs(duration)) + Long.highestOneBit(multiplier) : 64L + Long.highestOneBit(multiplier);
        long result = duration * multiplier;
        if (result_mag > 63L) {
            result = duration < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return result;
    }

    public static void timeWarp(long advanceby) {
        if (0L != WARPBEGAN) {
            throw new IllegalStateException("auto time warping already initialized at warp factor " + WARPFACTOR);
        }
        TIMEWARP += advanceby;
    }

    public static void autoWarp(double warpfactor) {
        if (0L != WARPBEGAN) {
            throw new IllegalStateException("Auto time warping already initialized at warp factor " + WARPFACTOR);
        }
        if (warpfactor <= 0.0) {
            throw new IllegalArgumentException("Time should not stand still or run backwards. It's unnatural.");
        }
        if (warpfactor != 1.0) {
            WARPFACTOR = warpfactor;
            WARPBEGAN = System.currentTimeMillis();
        }
    }

    public static long warpedRelativeTime(long initial) {
        if (0L == initial) {
            return 0L;
        }
        long adjusted = (long)((double)initial * WARPFACTOR);
        if (initial < 0L) {
            if (adjusted >= 0L) {
                adjusted = Long.MIN_VALUE;
            }
        } else if (adjusted < 0L) {
            adjusted = Long.MAX_VALUE;
        }
        return 0L != adjusted ? adjusted : 1L;
    }
}

