/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.logging.Logging;
import net.jxta.protocol.PeerAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiscoveryResponseMsg {
    private static final transient Logger LOG = Logger.getLogger(DiscoveryResponseMsg.class.getName());
    protected String attr = null;
    protected PeerAdvertisement peerAdvertisement = null;
    protected final List<String> responses = new ArrayList<String>(0);
    protected final List<Advertisement> advertisements = new ArrayList<Advertisement>(0);
    protected final List<Long> expirations = new ArrayList<Long>(0);
    protected int type = 0;
    protected String value = null;

    public static String getAdvertisementType() {
        return "jxta:DiscoveryResponse";
    }

    public int getDiscoveryType() {
        return this.type;
    }

    public void setDiscoveryType(int type) {
        this.type = type;
    }

    public abstract Document getDocument(MimeMediaType var1);

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    public void setPeerAdvertisement(PeerAdvertisement newAdv) {
        this.peerAdvertisement = newAdv;
    }

    public String getQueryAttr() {
        return this.attr;
    }

    public String getQueryValue() {
        return this.value;
    }

    public int getResponseCount() {
        if (this.expirations.isEmpty() && this.peerAdvertisement != null && this.type == 0) {
            return 1;
        }
        return this.responses.size();
    }

    public Enumeration<Long> getExpirations() {
        if (this.expirations.isEmpty() && this.peerAdvertisement != null && this.type == 0) {
            this.expirations.add(0x6DDD00L);
        }
        return Collections.enumeration(this.expirations);
    }

    public void setExpirations(List<Long> expirations) {
        this.expirations.clear();
        this.expirations.addAll(expirations);
    }

    public Enumeration<String> getResponses() {
        if (this.responses.isEmpty() && this.peerAdvertisement != null && this.type == 0) {
            this.responses.add(this.peerAdvertisement.toString());
        }
        return Collections.enumeration(this.responses);
    }

    public void setResponses(List responses) {
        this.responses.clear();
        for (Object response : responses) {
            if (response instanceof Advertisement) {
                this.responses.add(((Advertisement)response).getDocument(MimeMediaType.XMLUTF8).toString());
                continue;
            }
            if (response instanceof String) {
                this.responses.add((String)response);
                continue;
            }
            if (response instanceof InputStream) {
                String result = this.streamToString((InputStream)response);
                if (null == result) continue;
                this.responses.add(result);
                continue;
            }
            throw new IllegalArgumentException("Non-String or InputStream response recevied.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream is) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException impossible) {
            throw new Error("UTF-8 encoding not supported?!?");
        }
        StringBuilder stw = new StringBuilder();
        char[] buf = new char[512];
        try {
            int c;
            while ((c = reader.read(buf)) != -1) {
                stw.append(buf, 0, c);
            }
        }
        catch (IOException ie) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Got an Exception during stream conversion", ie);
            }
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
        return stw.toString();
    }

    public void setQueryAttr(String attr) {
        this.attr = attr;
    }

    public void setQueryValue(String value) {
        this.value = value;
    }

    public Enumeration<Advertisement> getAdvertisements() {
        if (this.responses.isEmpty() && this.peerAdvertisement != null && this.type == 0) {
            return Collections.enumeration(Collections.singletonList(this.peerAdvertisement));
        }
        if (this.advertisements.isEmpty() && !this.responses.isEmpty()) {
            for (String aResponse : this.responses) {
                try {
                    XMLDocument anXMLDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(aResponse));
                    Advertisement anAdv = AdvertisementFactory.newAdvertisement(anXMLDoc);
                    this.advertisements.add(anAdv);
                }
                catch (IOException badAdvertisement) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Invalid response in message : ", badAdvertisement);
                }
            }
        }
        return Collections.enumeration(this.advertisements);
    }
}

