/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathVariableResolver {
    private String pathPattern;
    private String actualPath;

    private PathVariableResolver(String pathPattern, String actualPath) {
        this.pathPattern = pathPattern;
        this.actualPath = actualPath;
    }

    public String resolveValue(String pathVariableName) {
        String variablePlaceholder = "{" + pathVariableName + "}";
        if (this.pathPattern.contains(variablePlaceholder)) {
            String regex = this.pathPattern.replace(variablePlaceholder, "(.+)");
            Pattern pattern = Pattern.compile(regex = regex.replaceAll("\\{.+\\}", ".+"));
            Matcher matcher = pattern.matcher(this.actualPath);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    public static PathVariableResolver forPathPatternAndActualPath(String pathPattern, String actualPath) {
        return new PathVariableResolver(pathPattern, actualPath);
    }
}

