/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.ArrayList;
import net.kaczmarzyk.spring.data.jpa.domain.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.And;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class AndSpecificationResolver
implements HandlerMethodArgumentResolver {
    private SimpleSpecificationResolver specResolver = new SimpleSpecificationResolver();

    AndSpecificationResolver() {
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(And.class);
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        And def = (And)param.getParameterAnnotation(And.class);
        WebRequestProcessingContext context = new WebRequestProcessingContext(param, webRequest);
        return this.buildSpecification(context, def);
    }

    Specification<Object> buildSpecification(WebRequestProcessingContext context, And def) {
        ArrayList innerSpecs = new ArrayList();
        for (Spec innerDef : def.value()) {
            Specification<Object> innerSpec = this.specResolver.buildSpecification(context, innerDef);
            if (innerSpec == null) continue;
            innerSpecs.add(innerSpec);
        }
        return innerSpecs.isEmpty() ? null : new Conjunction(innerSpecs);
    }
}

