/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import net.kaczmarzyk.spring.data.jpa.utils.PathVariableResolver;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import net.kaczmarzyk.spring.data.jpa.web.InvalidPathVariableRequestedException;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestQueryContext;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestProcessingContext {
    private final MethodParameter methodParameter;
    private final NativeWebRequest webRequest;
    private String pathPattern;

    public WebRequestProcessingContext(MethodParameter methodParameter, NativeWebRequest webRequest) {
        this.methodParameter = methodParameter;
        this.webRequest = webRequest;
    }

    public Class<?> getParameterType() {
        return this.methodParameter.getParameterType();
    }

    public Annotation[] getParameterAnnotations() {
        return this.methodParameter.getParameterAnnotations();
    }

    public String[] getParameterValues(String webParamName) {
        return this.webRequest.getParameterValues(webParamName);
    }

    public QueryContext queryContext() {
        return new WebRequestQueryContext(this.webRequest);
    }

    public String getPathVariableValue(String pathVariableName) {
        String value = PathVariableResolver.forPathPatternAndActualPath(this.pathPattern(), this.actualWebPath()).resolveValue(pathVariableName);
        if (value != null) {
            return value;
        }
        throw new InvalidPathVariableRequestedException(pathVariableName);
    }

    private String pathPattern() {
        if (this.pathPattern != null) {
            return this.pathPattern;
        }
        Class controllerClass = this.methodParameter.getContainingClass();
        if (controllerClass.getAnnotation(RequestMapping.class) != null) {
            RequestMapping controllerMapping = controllerClass.getAnnotation(RequestMapping.class);
            this.pathPattern = this.firstOf(controllerMapping.value(), controllerMapping.path());
        }
        String methodPathPattern = null;
        if (this.methodParameter.hasMethodAnnotation(RequestMapping.class)) {
            RequestMapping methodMapping = (RequestMapping)this.methodParameter.getMethodAnnotation(RequestMapping.class);
            methodPathPattern = this.firstOf(methodMapping.value(), methodMapping.path());
        } else if (this.methodParameter.hasMethodAnnotation(GetMapping.class)) {
            GetMapping methodMapping = (GetMapping)this.methodParameter.getMethodAnnotation(GetMapping.class);
            methodPathPattern = this.firstOf(methodMapping.value(), methodMapping.path());
        }
        if (methodPathPattern != null) {
            String string = this.pathPattern = this.pathPattern != null ? this.pathPattern + methodPathPattern : methodPathPattern;
        }
        if (this.pathPattern == null) {
            throw new IllegalStateException("path pattern could not be resolved (searched for @RequestMapping or @GetMapping)");
        }
        return this.pathPattern;
    }

    private String firstOf(String[] array1, String[] array2) {
        if (array1.length > 0) {
            return array1[0];
        }
        if (array2.length > 0) {
            return array2[0];
        }
        return null;
    }

    private String actualWebPath() {
        HttpServletRequest request = (HttpServletRequest)this.webRequest.getNativeRequest();
        return request.getPathInfo() != null ? request.getPathInfo() : request.getRequestURI().substring(request.getContextPath().length());
    }
}

