/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotEqualIgnoreCase<T>
extends PathSpecification<T>
implements LocaleAware {
    private static final long serialVersionUID = 2L;
    protected String expectedValue;
    private Converter converter;
    private Locale locale;

    public NotEqualIgnoreCase(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (this.path(root).getJavaType().equals(String.class)) {
            return cb.notEqual(cb.upper(this.path(root)), (Object)this.expectedValue.toUpperCase(this.locale));
        }
        Class typeOnPath = this.path(root).getJavaType();
        return cb.notEqual(this.path(root), this.converter.convert(this.expectedValue, typeOnPath, true));
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.converter, this.expectedValue, this.locale);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotEqualIgnoreCase other = (NotEqualIgnoreCase)obj;
        return Objects.equals(this.converter, other.converter) && Objects.equals(this.expectedValue, other.expectedValue) && Objects.equals(this.locale, other.locale);
    }

    public String toString() {
        return "NotEqualIgnoreCase[expectedValue='" + this.expectedValue + '\'' + ", converter=" + this.converter + ", path='" + this.path + '\'' + ", locale=" + this.locale + ']';
    }
}

