/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Locale;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.Like;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class LikeIgnoreCase<T>
extends Like<T>
implements LocaleAware {
    private static final long serialVersionUID = 1L;
    private Locale locale;

    public LikeIgnoreCase(QueryContext queryCtx, String path, String ... args) {
        super(queryCtx, path, args);
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        return builder.like(builder.upper(this.path(root)), this.pattern.toUpperCase(this.locale));
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.locale);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LikeIgnoreCase other = (LikeIgnoreCase)obj;
        return Objects.equals(this.locale, other.locale);
    }

    @Override
    public String toString() {
        return "LikeIgnoreCase [locale=" + this.locale + ", pattern=" + this.pattern + ", path=" + this.path + "]";
    }
}

