/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kaczmarzyk.spring.data.jpa.utils.TypeUtil;
import net.kaczmarzyk.spring.data.jpa.web.AndSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.ConjunctionSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.DisjunctionSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.JoinFetchSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.JoinSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.OrSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.ProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.RepeatedJoinFetchResolver;
import net.kaczmarzyk.spring.data.jpa.web.RepeatedJoinResolver;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationResolver;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationFactory {
    private Map<Class<? extends Annotation>, SpecificationResolver<? extends Annotation>> resolversBySupportedType;

    public SpecificationFactory(ConversionService conversionService, AbstractApplicationContext abstractApplicationContext, Locale locale) {
        SimpleSpecificationResolver simpleSpecificationResolver = new SimpleSpecificationResolver(conversionService, abstractApplicationContext, locale);
        this.resolversBySupportedType = Arrays.asList(simpleSpecificationResolver, new OrSpecificationResolver(simpleSpecificationResolver), new DisjunctionSpecificationResolver(simpleSpecificationResolver), new ConjunctionSpecificationResolver(simpleSpecificationResolver), new AndSpecificationResolver(simpleSpecificationResolver), new JoinSpecificationResolver(), new JoinFetchSpecificationResolver(), new RepeatedJoinFetchResolver(), new RepeatedJoinResolver()).stream().collect(Collectors.toMap(SpecificationResolver::getSupportedSpecificationDefinition, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    public Specification<?> createSpecificationDependingOn(ProcessingContext context) {
        Specification<Object> spec;
        List specs = this.resolveSpec(context);
        if (specs.isEmpty()) {
            return null;
        }
        Specification<Object> specification = spec = specs.size() == 1 ? specs.iterator().next() : new Specification<Object>(specs);
        if (context.getParameterType().isAssignableFrom(spec.getClass())) {
            return spec;
        }
        return (Specification)EnhancerUtil.wrapWithIfaceImplementation(context.getParameterType(), spec);
    }

    private List<Specification<Object>> resolveSpec(ProcessingContext context) {
        ArrayList<Specification<Object>> specAccumulator = new ArrayList<Specification<Object>>();
        this.resolveSpecFromInterfaceAnnotations(context, specAccumulator);
        this.resolveSpecFromParameterAnnotations(context, specAccumulator);
        return specAccumulator;
    }

    private void resolveSpecFromParameterAnnotations(ProcessingContext context, List<Specification<Object>> accum) {
        this.forEachSupportedSpecificationDefinition(context.getParameterAnnotations(), specDefinition -> {
            Specification<Object> specification = this.buildSpecification(context, (Annotation)specDefinition);
            if (Objects.nonNull(specification)) {
                accum.add(specification);
            }
        });
    }

    private void resolveSpecFromInterfaceAnnotations(ProcessingContext context, List<Specification<Object>> accumulator) {
        Collection<Class<?>> ifaceTree = TypeUtil.interfaceTree(context.getParameterType());
        for (Class<?> iface : ifaceTree) {
            this.forEachSupportedInterfaceSpecificationDefinition(iface, specDefinition -> {
                Specification<Object> specification = this.buildSpecification(context, (Annotation)specDefinition);
                if (Objects.nonNull(specification)) {
                    accumulator.add(specification);
                }
            });
        }
    }

    private Specification<Object> buildSpecification(ProcessingContext context, Annotation specDef) {
        SpecificationResolver<? extends Annotation> resolver = this.resolversBySupportedType.get(specDef.annotationType());
        if (resolver == null) {
            throw new IllegalArgumentException("Definition is not supported. Specification resolver is not able to build specification from definition of type :" + String.valueOf(specDef.annotationType()));
        }
        return resolver.buildSpecification(context, specDef);
    }

    private void forEachSupportedSpecificationDefinition(Annotation[] parameterAnnotations, Consumer<Annotation> specificationBuilder) {
        for (Annotation annotation : parameterAnnotations) {
            for (Class<? extends Annotation> annotationType : this.resolversBySupportedType.keySet()) {
                if (!annotationType.isAssignableFrom(annotation.getClass())) continue;
                specificationBuilder.accept(annotation);
            }
        }
    }

    private void forEachSupportedInterfaceSpecificationDefinition(Class<?> target, Consumer<Annotation> specificationBuilder) {
        if (target.getAnnotations().length != 0) {
            for (Class<? extends Annotation> annotationType : this.resolversBySupportedType.keySet()) {
                Annotation potentialAnnotation = target.getAnnotation(annotationType);
                if (potentialAnnotation == null) continue;
                specificationBuilder.accept(potentialAnnotation);
            }
        }
    }

    public Set<Class<? extends Annotation>> getResolversBySupportedType() {
        return this.resolversBySupportedType.keySet();
    }
}

