/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.DateTimeUtils;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class EqualDay<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    private final String expectedDay;
    private final Converter converter;

    public EqualDay(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.converter = converter;
        this.expectedDay = httpParamValues[0];
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Path targetExpression = this.path(root);
        Class typeOnPath = targetExpression.getJavaType();
        Object targetDayDate = this.converter.convert(this.expectedDay, typeOnPath);
        Predicate lowerBoundaryPredicate = criteriaBuilder.greaterThanOrEqualTo(targetExpression, (Comparable)DateTimeUtils.startOfDay(targetDayDate));
        Predicate upperBoundaryPredicate = criteriaBuilder.lessThan(targetExpression, (Comparable)DateTimeUtils.startOfNextDay(targetDayDate));
        return criteriaBuilder.and((Expression)lowerBoundaryPredicate, (Expression)upperBoundaryPredicate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EqualDay equalDay = (EqualDay)o;
        return Objects.equals(this.expectedDay, equalDay.expectedDay) && Objects.equals(this.converter, equalDay.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.expectedDay, this.converter);
    }

    public String toString() {
        return "EqualDay[expectedDay='" + this.expectedDay + "', converter=" + String.valueOf(this.converter) + ", path='" + this.path + "']";
    }
}

