/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Locale;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategyAware;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.domain.NotLike;
import net.kaczmarzyk.spring.data.jpa.utils.CaseConversionHelper;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotLikeIgnoreCase<T>
extends NotLike<T>
implements IgnoreCaseStrategyAware,
LocaleAware {
    private static final long serialVersionUID = 1L;
    private IgnoreCaseStrategy ignoreCaseStrategy;
    private Locale locale;

    public NotLikeIgnoreCase(QueryContext queryContext, String path, String ... args) {
        super(queryContext, path, args);
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        CaseConversionHelper.ConvertedExpressions converted = CaseConversionHelper.applyCaseConversion(builder, this.path(root), this.pattern, this.ignoreCaseStrategy, this.locale);
        return builder.not((Expression)builder.like(converted.column(), converted.value()));
    }

    @Override
    public void setIgnoreCaseStrategy(IgnoreCaseStrategy ignoreCaseStrategy) {
        this.ignoreCaseStrategy = ignoreCaseStrategy;
    }

    @Override
    @Deprecated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ignoreCaseStrategy == null ? 0 : this.ignoreCaseStrategy.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotLikeIgnoreCase other = (NotLikeIgnoreCase)obj;
        if (this.ignoreCaseStrategy != other.ignoreCaseStrategy) {
            return false;
        }
        return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
    }

    @Override
    public String toString() {
        return "NotLikeIgnoreCase [pattern=" + this.pattern + ", path=" + this.path + ", ignoreCaseStrategy=" + String.valueOf((Object)this.ignoreCaseStrategy) + ", locale=" + String.valueOf(this.locale) + "]";
    }
}

