/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import java.util.Locale;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;

public class CaseConversionHelper {
    public static ConvertedExpressions applyCaseConversion(CriteriaBuilder cb, Expression<String> columnExpression, String value, IgnoreCaseStrategy strategy, Locale locale) {
        IgnoreCaseStrategy effectiveStrategy = strategy != null ? strategy : IgnoreCaseStrategy.DATABASE_UPPER;
        switch (effectiveStrategy) {
            case DATABASE_UPPER: {
                return new ConvertedExpressions((Expression<String>)cb.upper(columnExpression), (Expression<String>)cb.upper(cb.literal((Object)value)));
            }
            case DATABASE_LOWER: {
                return new ConvertedExpressions((Expression<String>)cb.lower(columnExpression), (Expression<String>)cb.lower(cb.literal((Object)value)));
            }
            case APPLICATION: {
                Locale effectiveLocale = locale != null ? locale : Locale.getDefault();
                String convertedValue = value.toUpperCase(effectiveLocale);
                return new ConvertedExpressions((Expression<String>)cb.upper(columnExpression), (Expression<String>)cb.literal((Object)convertedValue));
            }
        }
        throw new IllegalArgumentException("Unknown case strategy: " + String.valueOf((Object)effectiveStrategy));
    }

    public record ConvertedExpressions(Expression<String> column, Expression<String> value) {
        public ConvertedExpressions {
            if (column == null) {
                throw new IllegalArgumentException("Column expression must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value expression must not be null");
            }
        }
    }
}

