/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;

public class Disjunction<T>
implements Specification<T> {
    private static final long serialVersionUID = 1L;
    private Collection<Specification<T>> innerSpecs;

    @SafeVarargs
    public Disjunction(Specification<T> ... specs) {
        this(Arrays.asList(specs));
    }

    public Disjunction(Collection<Specification<T>> innerSpecs) {
        this.innerSpecs = innerSpecs;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Specification combinedSpecs = null;
        for (Specification<T> spec : this.innerSpecs) {
            if (combinedSpecs == null) {
                combinedSpecs = Specification.where(spec);
                continue;
            }
            combinedSpecs = combinedSpecs.or(spec);
        }
        return combinedSpecs.toPredicate(root, query, cb);
    }

    public int hashCode() {
        return Objects.hash(this.innerSpecs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disjunction other = (Disjunction)obj;
        return Objects.equals(this.innerSpecs, other.innerSpecs);
    }

    public String toString() {
        return "Disjunction [innerSpecs=" + String.valueOf(this.innerSpecs) + "]";
    }
}

